/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import java.io.EOFException;

public class CoordFloatString {
    public int tcount;
    public int tsize;
    public float[] vals;

    public CoordFloatString(int tuplecount, int tuplesize, BinaryFile input) throws FormatException {
        this.tcount = tuplecount;
        this.tsize = tuplesize;
        int totallen = this.tcount * this.tsize;
        this.vals = new float[totallen];
        try {
            input.readFloatArray(this.vals, 0, totallen);
        }
        catch (EOFException e) {
            throw new FormatException("CoordFloatString EOFException");
        }
    }

    public int maxIndex() {
        return this.tcount;
    }

    public String toString() {
        int j;
        boolean singleCoord = this.vals.length == this.tsize;
        StringBuffer retval = new StringBuffer(singleCoord ? "" : "CFS:");
        if (!singleCoord) {
            retval.append(this.tcount).append("[");
        }
        if (this.vals.length > 0) {
            retval.append("(").append(this.vals[0]);
            j = 1;
            while (j < this.tsize) {
                retval.append(", ").append(this.vals[j]);
                ++j;
            }
            retval.append(")");
        }
        if (this.vals.length > this.tsize) {
            retval.append(" ... (").append(this.vals[this.vals.length - this.tsize]);
            j = this.tsize - 1;
            while (j > 0) {
                retval.append(", ").append(this.vals[this.vals.length - j]);
                --j;
            }
            retval.append(")");
        }
        if (!singleCoord) {
            retval.append("]");
        }
        return retval.toString();
    }

    public float getXasFloat(int tuple) {
        return this.vals[tuple * this.tsize];
    }

    public float getYasFloat(int tuple) {
        return this.vals[tuple * this.tsize + 1];
    }

    public float getZasFloat(int tuple) {
        return this.vals[tuple * this.tsize + 2];
    }

    public float[] getasFloatV(int tuple) {
        float[] rv = new float[this.tsize];
        int i = 0;
        while (i < this.tsize) {
            rv[i] = this.vals[this.tsize * tuple + i];
            ++i;
        }
        return rv;
    }

    public float getasFloat(int tuple, int val) {
        return this.vals[tuple * this.tsize + val];
    }
}

