/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ShapeLayer
extends OMGraphicHandlerLayer
implements ActionListener,
DataBoundsProvider {
    public static final String shapeFileProperty = "shapeFile";
    public static final String spatialIndexProperty = "spatialIndex";
    public static final String pointImageURLProperty = "pointImageURL";
    public static final String shadowXProperty = "shadowX";
    public static final String shadowYProperty = "shadowY";
    protected int shadowX = 0;
    protected int shadowY = 0;
    protected SpatialIndex spatialIndex;
    protected DrawingAttributes drawingAttributes;
    String shapeFileName = null;
    String spatialIndexFileName = null;
    String imageURLString = null;
    protected transient JPanel box;
    static /* synthetic */ Class class$com$bbn$openmap$layer$shape$ShapeLayer;

    public ShapeLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public ShapeLayer(String shapeFileName) {
        this();
        this.spatialIndex = SpatialIndex.locateAndSetShapeData(shapeFileName);
    }

    public void setSpatialIndex(SpatialIndex si) {
        this.spatialIndex = si;
    }

    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        this.shapeFileName = props.getProperty(realPrefix + shapeFileProperty);
        this.spatialIndexFileName = props.getProperty(realPrefix + spatialIndexProperty);
        if (this.shapeFileName != null && !this.shapeFileName.equals("")) {
            this.spatialIndex = this.spatialIndexFileName != null && !this.spatialIndexFileName.equals("") ? SpatialIndex.locateAndSetShapeData(this.shapeFileName, this.spatialIndexFileName) : SpatialIndex.locateAndSetShapeData(this.shapeFileName);
            this.imageURLString = props.getProperty(realPrefix + pointImageURLProperty);
            try {
                if (this.imageURLString != null && !this.imageURLString.equals("")) {
                    URL imageURL = LayerUtils.getResourceOrFileOrURL(this, this.imageURLString);
                    ImageIcon imageIcon = new ImageIcon(imageURL);
                    this.spatialIndex.setPointIcon(imageIcon);
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("ShapeLayer.setProperties: point image URL not so good: \n\t" + this.imageURLString);
            }
            catch (NullPointerException npe) {
                this.fireRequestMessage("Can't access icon image: \n" + this.imageURLString);
            }
        } else {
            Debug.error("One of the following properties was null or empty:");
            Debug.error("\t" + realPrefix + shapeFileProperty);
            Debug.error("\t" + realPrefix + spatialIndexProperty);
        }
        this.drawingAttributes = new DrawingAttributes(prefix, props);
        this.shadowX = LayerUtils.intFromProperties(props, realPrefix + shadowXProperty, 0);
        this.shadowY = LayerUtils.intFromProperties(props, realPrefix + shadowYProperty, 0);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + shapeFileProperty, this.shapeFileName == null ? "" : this.shapeFileName);
        props.put(prefix + spatialIndexProperty, this.spatialIndexFileName == null ? "" : this.spatialIndexFileName);
        props.put(prefix + pointImageURLProperty, this.imageURLString == null ? "" : this.imageURLString);
        props.put(prefix + shadowXProperty, Integer.toString(this.shadowX));
        props.put(prefix + shadowYProperty, Integer.toString(this.shadowY));
        if (this.drawingAttributes != null) {
            this.drawingAttributes.setPropertyPrefix(this.getPropertyPrefix());
            this.drawingAttributes.getProperties(props);
        } else {
            DrawingAttributes da = (DrawingAttributes)DrawingAttributes.DEFAULT.clone();
            da.setPropertyPrefix(this.getPropertyPrefix());
            da.getProperties(props);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        DrawingAttributes da = this.drawingAttributes != null ? this.drawingAttributes : DrawingAttributes.DEFAULT;
        da.getPropertyInfo(list);
        list.put("initProperties", "shapeFile spatialIndex pointImageURL shadowX shadowY" + da.getInitPropertiesOrder() + " " + "addToBeanContext");
        String interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shapeFileProperty, 3, "Location of Shape file - .shp (File, URL or relative file path).");
        list.put(shapeFileProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shapeFileProperty, shapeFileProperty);
        list.put("shapeFile.label", interString);
        list.put("shapeFile.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, spatialIndexProperty, 3, "Location of Spatial Index file - .ssx (File, URL or relative file path).");
        list.put(spatialIndexProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, spatialIndexProperty, spatialIndexProperty);
        list.put("spatialIndex.label", interString);
        list.put("spatialIndex.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, pointImageURLProperty, 3, "Image file to use for map location of point data (optional).");
        list.put(pointImageURLProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, pointImageURLProperty, pointImageURLProperty);
        list.put("pointImageURL.label", interString);
        list.put("pointImageURL.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shadowXProperty, 3, "Horizontal pixel offset for shadow image for shapes.");
        list.put(shadowXProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shadowXProperty, shadowXProperty);
        list.put("shadowX.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shadowYProperty, 3, "Vertical pixel offset for shadow image for shapes.");
        list.put(shadowYProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shadowYProperty, shadowYProperty);
        list.put("shadowY.label", interString);
        return list;
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    protected OMGraphicList computeGraphics() {
        return this.prepare();
    }

    public synchronized OMGraphicList prepare() {
        if (this.spatialIndex == null) {
            Debug.message("shape", "ShapeLayer: spatialIndex is null!");
            return new OMGraphicList();
        }
        Projection projection = this.getProjection();
        if (projection == null) {
            Debug.message("basic", "ShapeLayer|" + this.getName() + ": prepare called with null projection");
            return new OMGraphicList();
        }
        LatLonPoint ul = projection.getUpperLeft();
        LatLonPoint lr = projection.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        OMGraphicList list = null;
        if (ulLon > lrLon || MoreMath.approximately_equal(ulLon, lrLon, 0.001f)) {
            if (Debug.debugging("shape")) {
                Debug.output("ShapeLayer.computeGraphics(): Dateline is on screen");
            }
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                ESRIRecord[] records1 = this.spatialIndex.locateRecords(ulLon, ymin, 180.0, ymax);
                ESRIRecord[] records2 = this.spatialIndex.locateRecords(-180.0, ymin, lrLon, ymax);
                int nRecords1 = records1.length;
                int nRecords2 = records2.length;
                list = new OMGraphicList(nRecords1 + nRecords2);
                int i = 0;
                while (i < nRecords1) {
                    records1[i].addOMGraphics(list, this.drawingAttributes);
                    ++i;
                }
                int i2 = 0;
                while (i2 < nRecords2) {
                    records2[i2].addOMGraphics(list, this.drawingAttributes);
                    ++i2;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        } else {
            double xmin = Math.min(ulLon, lrLon);
            double xmax = Math.max(ulLon, lrLon);
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                ESRIRecord[] records = this.spatialIndex.locateRecords(xmin, ymin, xmax, ymax);
                int nRecords = records.length;
                list = new OMGraphicList(nRecords);
                int i = 0;
                while (i < nRecords) {
                    records[i].addOMGraphics(list, this.drawingAttributes);
                    ++i;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        }
        if (list != null) {
            list.generate(projection, true);
        }
        return list;
    }

    public void paint(Graphics g) {
        if (this.shadowX == 0 && this.shadowY == 0) {
            super.paint(g);
        } else {
            OMGraphicList omg = this.getList();
            if (omg != null) {
                if (Debug.debugging("shape")) {
                    Debug.output("ShapeLayer.paint(): " + omg.size() + " omg" + " shadow=" + this.shadowX + "," + this.shadowY);
                }
                if (this.shadowX != 0 || this.shadowY != 0) {
                    Graphics shadowG = g.create();
                    shadowG.translate(this.shadowX, this.shadowY);
                    omg.render(shadowG);
                } else {
                    omg.render(g);
                }
                if (Debug.debugging("shape")) {
                    Debug.output("ShapeLayer.paint(): done");
                }
            }
        }
    }

    public Component getGUI() {
        if (this.box == null) {
            this.box = new JPanel();
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.box.setAlignmentX(0.0f);
            JPanel stuff = new JPanel();
            DrawingAttributes da = this.getDrawingAttributes();
            if (da != null) {
                stuff.add(da.getGUI());
            }
            this.box.add(stuff);
            JPanel pal2 = new JPanel();
            JButton redraw = new JButton("Redraw Layer");
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            pal2.add(redraw);
            this.box.add(pal2);
        }
        return this.box;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String cmd = e.getActionCommand();
        if (cmd == "redrawCmd" && this.isVisible()) {
            this.doPrepare();
        }
    }

    public DataBounds getDataBounds() {
        ESRIBoundingBox bounds;
        DataBounds box = null;
        if (this.spatialIndex != null && (bounds = this.spatialIndex.getBounds()) != null) {
            box = new DataBounds(bounds.min.x, bounds.min.y, bounds.max.x, bounds.max.y);
        }
        return box;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

