/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIPoint;
import com.bbn.openmap.layer.shape.ESRIPolygonRecord;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.ShapeFile;
import java.io.IOException;

public class ShapeFileCrop {
    public ShapeFile sfin = null;
    public ShapeFile sfout = null;
    ESRIBoundingBox ebb = null;

    public ShapeFileCrop(String namein, String nameout) throws IOException {
        this.sfin = new ShapeFile(namein);
        this.sfout = new ShapeFile(nameout);
    }

    /*
     * WARNING - void declaration
     */
    public void cropShapeFile() throws IOException {
        int nRecordNum = 0;
        int nRecords = 0;
        this.sfin.readHeader();
        this.sfout.setShapeType(this.sfin.fileShapeType);
        switch (this.sfin.fileShapeType) {
            case 3: 
            case 5: {
                ESRIPolygonRecord pr;
                while ((pr = (ESRIPolygonRecord)this.sfin.getNextRecord()) != null) {
                    void var2_3;
                    ++nRecords;
                    if (this.overlapBBTest(var2_3.bounds) == 0) continue;
                    var2_3.recordNumber = nRecordNum + 1;
                    this.sfout.add((ESRIRecord)var2_3);
                    ++nRecordNum;
                    ++nRecords;
                }
                break;
            }
        }
        System.out.println("Number of input records = " + (nRecords + 1));
        System.out.println("Number of candidate records = " + nRecordNum);
        if (nRecordNum > 0) {
            this.sfout.verify(true, true);
        }
        this.sfin.close();
        this.sfout.close();
    }

    private int overlapBBTest(ESRIBoundingBox bb) {
        int result = 0;
        result += this.boundaryTest(bb.min.x, bb.min.y);
        result += this.boundaryTest(bb.max.x, bb.min.y);
        result += this.boundaryTest(bb.min.x, bb.max.y);
        return result += this.boundaryTest(bb.max.x, bb.max.y);
    }

    private int boundaryTest(double x, double y) {
        int ns = 0;
        int ew = 0;
        if (x >= this.ebb.min.x && x < this.ebb.max.x) {
            ++ew;
        }
        if (y >= this.ebb.min.y && y < this.ebb.max.y) {
            ++ns;
        }
        return ns * ew;
    }

    public static void usage() {
        System.out.println("Usage: java ShapeFileCrop [args] -i <infile.shp> -o <outfile.shp>");
        System.out.println("Arguments:");
        System.out.println("-ul lat,lon     Coordinates of upper-left corner of the bounding box to use for cropping");
        System.out.println("-lr lat,lon     Coordinates of lower-right corner of the bounding box to use for cropping");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        int argc = args.length;
        String inpath = "";
        String outpath = "";
        ShapeFileCrop sfc = null;
        ESRIPoint ul = null;
        ESRIPoint lr = null;
        int index = 0;
        int i = 0;
        while (i < args.length) {
            String[] sllpa;
            String sllp;
            if (args[i].equals("-i")) {
                inpath = args[++i];
            } else if (args[i].equals("-o")) {
                outpath = args[++i];
            } else if (args[i].equals("-ul")) {
                if ((index = (sllp = args[++i]).indexOf(",")) != -1) {
                    sllpa = new String[]{sllp.substring(0, index), sllp.substring(index + 1)};
                    ul = new ESRIPoint(Double.valueOf(sllpa[1]), Double.valueOf(sllpa[0]));
                }
            } else if (args[i].equals("-lr")) {
                if ((index = (sllp = args[++i]).indexOf(",")) != -1) {
                    sllpa = new String[]{sllp.substring(0, index), sllp.substring(index + 1)};
                    lr = new ESRIPoint(Double.valueOf(sllpa[1]), Double.valueOf(sllpa[0]));
                }
            } else {
                ShapeFileCrop.usage();
            }
            ++i;
        }
        if (ul == null || lr == null || inpath.equals("") || outpath.equals("")) {
            ShapeFileCrop.usage();
        } else {
            sfc = new ShapeFileCrop(inpath, outpath);
            sfc.ebb = new ESRIBoundingBox(ul, lr);
        }
        sfc.cropShapeFile();
    }
}

