/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIPoly;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.ShapeUtils;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.geom.PolygonGeometry;
import com.bbn.openmap.omGraphics.geom.PolylineGeometry;
import com.bbn.openmap.proj.ProjMath;
import java.io.IOException;

public class ESRIPolygonRecord
extends ESRIRecord {
    protected int shapeType = 5;
    public ESRIBoundingBox bounds;
    public ESRIPoly[] polygons;

    public ESRIPolygonRecord() {
        this.bounds = new ESRIBoundingBox();
        this.polygons = new ESRIPoly[0];
    }

    public ESRIPolygonRecord(byte[] b, int off) throws IOException {
        super(b, off);
        int _len;
        int ptr = off + 8;
        this.shapeType = ShapeUtils.readLEInt(b, ptr);
        ptr += 4;
        if (this.shapeType != 5 && this.shapeType != 3) {
            throw new IOException("Invalid polygon record.  Expected shape type 5 or type 3, but found " + this.shapeType);
        }
        boolean ispolyg = this.isPolygon();
        this.bounds = ShapeUtils.readBox(b, ptr);
        int numParts = ShapeUtils.readLEInt(b, ptr += 32);
        int numPoints = ShapeUtils.readLEInt(b, ptr += 4);
        ptr += 4;
        if (numParts <= 0) {
            return;
        }
        this.polygons = new ESRIPoly[numParts];
        int origin = 0;
        int i = 0;
        while (i < numParts) {
            int nextOrigin = ShapeUtils.readLEInt(b, ptr);
            ptr += 4;
            if (i > 0) {
                _len = nextOrigin - origin;
                if (ispolyg) {
                    ++_len;
                }
                this.polygons[i - 1] = new ESRIPoly.ESRIFloatPoly(_len);
            }
            origin = nextOrigin;
            ++i;
        }
        _len = numPoints - origin;
        if (ispolyg) {
            ++_len;
        }
        this.polygons[numParts - 1] = new ESRIPoly.ESRIFloatPoly(_len);
        int i2 = 0;
        while (i2 < numParts) {
            ptr += this.polygons[i2].read(b, ptr, ispolyg);
            ++i2;
        }
    }

    public boolean isPolygon() {
        return this.shapeType == 5;
    }

    public void setPolygon(boolean isPolygon) {
        this.shapeType = isPolygon ? 5 : 3;
    }

    public void add(float[] radians) {
        ESRIPoly.ESRIFloatPoly newPoly = new ESRIPoly.ESRIFloatPoly(radians);
        int numParts = this.polygons.length;
        ESRIPoly[] oldPolys = this.polygons;
        this.polygons = new ESRIPoly[numParts + 1];
        int i = 0;
        while (i < numParts) {
            this.polygons[i] = oldPolys[i];
            ++i;
        }
        this.polygons[numParts] = newPoly;
        int len = radians.length;
        int i2 = 0;
        while (i2 < len) {
            this.bounds.addPoint(ProjMath.radToDeg(radians[i2 + 1]), ProjMath.radToDeg(radians[i2]));
            i2 += 2;
        }
    }

    public void addOMGraphics(OMGraphicList list, DrawingAttributes drawingAttributes) {
        int nPolys = this.polygons.length;
        if (nPolys <= 0) {
            return;
        }
        OMPoly p = null;
        boolean ispolyg = this.isPolygon();
        OMGraphicList sublist = null;
        if (nPolys > 1) {
            sublist = new OMGraphicList(10);
            sublist.setVague(true);
            list.add(sublist);
            sublist.setAppObject(new Integer(this.getRecordNumber()));
        }
        int i = 0;
        while (i < nPolys) {
            float[] pts = ((ESRIPoly.ESRIFloatPoly)this.polygons[i]).getRadians();
            int len = pts.length;
            p = new OMPoly(pts, 1, 1);
            drawingAttributes.setTo(p);
            if (!ispolyg) {
                p.setIsPolygon(false);
            }
            if (sublist != null) {
                sublist.add(p);
            } else {
                p.setAppObject(new Integer(this.getRecordNumber()));
                list.add(p);
            }
            ++i;
        }
    }

    public OMGeometry addOMGeometry(OMGeometryList list) {
        int nPolys = this.polygons.length;
        if (nPolys <= 0) {
            return null;
        }
        boolean ispolyg = this.isPolygon();
        PolygonGeometry.LL geom = null;
        int i = 0;
        while (i < nPolys) {
            float[] pts = ((ESRIPoly.ESRIFloatPoly)this.polygons[i]).getRadians();
            int len = pts.length;
            geom = ispolyg ? new PolygonGeometry.LL(pts, 1, 1) : new PolylineGeometry.LL(pts, 1, 1);
            list.add(geom);
            ++i;
        }
        return geom;
    }

    public ESRIBoundingBox getBoundingBox() {
        return this.bounds;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public int getRecordLength() {
        int numParts = this.polygons.length;
        int numPoints = 0;
        int i = 0;
        while (i < numParts) {
            numPoints += this.polygons[i].nPoints;
            ++i;
        }
        return 44 + numParts * 4 + numPoints * 16;
    }

    public int write(byte[] b, int off) {
        int nBytes = super.write(b, off);
        nBytes += ShapeUtils.writeLEInt(b, off + nBytes, this.shapeType);
        nBytes += ShapeUtils.writeBox(b, off + nBytes, this.bounds);
        int numParts = this.polygons.length;
        nBytes += ShapeUtils.writeLEInt(b, off + nBytes, numParts);
        int numPoints = 0;
        int i = 0;
        while (i < numParts) {
            numPoints += this.polygons[i].nPoints;
            ++i;
        }
        nBytes += ShapeUtils.writeLEInt(b, off + nBytes, numPoints);
        int ptr = 0;
        int i2 = 0;
        while (i2 < numParts) {
            nBytes += ShapeUtils.writeLEInt(b, off + nBytes, ptr);
            ptr += this.polygons[i2].nPoints;
            ++i2;
        }
        int i3 = 0;
        while (i3 < numParts) {
            float[] pts = ((ESRIPoly.ESRIFloatPoly)this.polygons[i3]).getRadians();
            int nPts = pts.length;
            int j = 0;
            while (j < nPts) {
                nBytes += ShapeUtils.writeLEDouble(b, off + nBytes, ProjMath.radToDeg(pts[j + 1]));
                nBytes += ShapeUtils.writeLEDouble(b, off + nBytes, ProjMath.radToDeg(pts[j]));
                j += 2;
            }
            ++i3;
        }
        return nBytes;
    }
}

