/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.mysql;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.mysql.MysqlGeometry;
import com.bbn.openmap.layer.mysql.MysqlLine;
import com.bbn.openmap.layer.mysql.MysqlMulti;
import com.bbn.openmap.layer.mysql.MysqlPoint;
import com.bbn.openmap.layer.mysql.MysqlPolygon;
import com.bbn.openmap.layer.mysql.MysqlWKTGeometryFactory;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MysqlGeometryLayer
extends OMGraphicHandlerLayer {
    protected String dbUrl = null;
    public static final String dbUrlProperty = "dbUrl";
    protected String dbClass = null;
    public static final String dbClassProperty = "dbClass";
    protected Connection conn = null;
    protected ResultSet rs = null;
    protected Statement stmt = null;
    protected String geomTable = null;
    public static final String geomTableProperty = "geomTable";
    protected String geomColumn = null;
    public static final String geomColumnProperty = "geomColumn";
    protected String pointSymbol = "";
    public static final String pointSymbolProperty = "pointSymbol";
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.dbClass = properties.getProperty(prefix + dbClassProperty);
        this.dbUrl = properties.getProperty(prefix + dbUrlProperty);
        this.geomTable = properties.getProperty(prefix + geomTableProperty);
        this.geomColumn = properties.getProperty(prefix + geomColumnProperty);
        this.pointSymbol = properties.getProperty(prefix + pointSymbolProperty);
        if (Debug.debugging("mysql")) {
            Debug.output("MysqlGeometryLayer (" + this.getName() + ") properties:");
            Debug.output("  " + this.dbClass);
            Debug.output("  " + this.dbUrl);
            Debug.output("  " + this.geomTable);
            Debug.output("  " + this.geomColumn);
        }
        this.drawingAttributes.setProperties(prefix, properties);
    }

    public synchronized OMGraphicList prepare() {
        Projection proj = this.getProjection();
        if (proj == null) {
            Debug.output("MysqlGeometryLayer.prepare: null projection!");
            return null;
        }
        OMGraphicList graphics = new OMGraphicList();
        try {
            Class.forName(this.dbClass).newInstance();
            try {
                this.conn = DriverManager.getConnection(this.dbUrl);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.stmt = this.conn.createStatement();
            String q = "SELECT ID, AsText(" + this.geomColumn + ") FROM " + this.geomTable + " WHERE MBRIntersects(GEO, GeomFromText('Polygon(( " + this.getProjection().getUpperLeft().getLongitude() + " " + this.getProjection().getUpperLeft().getLatitude() + ", " + this.getProjection().getUpperLeft().getLongitude() + " " + this.getProjection().getLowerRight().getLatitude() + ", " + this.getProjection().getLowerRight().getLongitude() + " " + this.getProjection().getLowerRight().getLatitude() + ", " + this.getProjection().getLowerRight().getLongitude() + " " + this.getProjection().getUpperLeft().getLatitude() + ", " + this.getProjection().getUpperLeft().getLongitude() + " " + this.getProjection().getUpperLeft().getLatitude() + "))'))";
            if (Debug.debugging("mysql")) {
                Debug.output("MysqlGeometryLayer query: " + q);
            }
            this.stmt.executeQuery(q);
            this.rs = this.stmt.getResultSet();
            graphics.clear();
            while (this.rs.next()) {
                String result = this.rs.getString(2);
                if (Debug.debugging("mysql")) {
                    Debug.output("MysqlGeometryLayer result: " + result);
                }
                MysqlGeometry mg = MysqlWKTGeometryFactory.createGeometry(result);
                OMGraphic omg = this.createGraphic(mg);
                omg.generate(proj);
                graphics.add(omg);
            }
            this.rs.close();
            this.conn.close();
        }
        catch (SQLException sqlE) {
            sqlE.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graphics;
    }

    protected OMGraphic createPoint(MysqlPoint myPoint) {
        ImageIcon actualPointSymbol = new ImageIcon(this.pointSymbol);
        OMRaster ompoint = new OMRaster((float)myPoint.getNorthings(), (float)myPoint.getEastings(), actualPointSymbol);
        this.drawingAttributes.setTo(ompoint);
        return ompoint;
    }

    protected OMGraphic createLine(MysqlLine myLine) {
        OMPoly ompoly = new OMPoly(this.DoubleToFloat(myLine.getCoordinateArray()), 0, 1);
        this.drawingAttributes.setTo(ompoly);
        return ompoly;
    }

    protected OMGraphic createPolygon(MysqlPolygon myPoly) {
        Vector v = myPoly.getRings();
        int size = v.size();
        OMGraphic ret = null;
        OMPoly ompoly = null;
        OMGraphicList subList = null;
        if (size > 1) {
            ret = subList = new OMGraphicList();
        }
        int i = 0;
        while (i < size) {
            ompoly = new OMPoly(this.DoubleToFloat((double[])v.elementAt(i)), 0, 1);
            this.drawingAttributes.setTo(ompoly);
            if (subList != null) {
                subList.add(ompoly);
            } else {
                ret = ompoly;
            }
            ++i;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OMGraphic createGraphic(MysqlGeometry mg) {
        OMGraphic ret;
        block16: {
            String type;
            block15: {
                ret = null;
                if (mg == null) return ret;
                type = mg.getType();
                if (type.equals(MysqlGeometry.POINTTYPE)) {
                    return this.createPoint((MysqlPoint)mg);
                }
                if (type.equals(MysqlGeometry.LINESTRINGTYPE)) {
                    return this.createLine((MysqlLine)mg);
                }
                if (type.equals(MysqlGeometry.POLYGONTTYPE)) {
                    return this.createPolygon((MysqlPolygon)mg);
                }
                if (type.equals(MysqlGeometry.MULTIPOINTTYPE)) break block15;
                if (type.equals(MysqlGeometry.MULTILINESTRINGTYPE)) break block15;
                if (type.equals(MysqlGeometry.MULTIPOLYGONTYPE)) break block15;
                if (!type.equals(MysqlGeometry.GEOMETRYCOLLECTIONTYPE)) break block16;
            }
            MysqlMulti multi = (MysqlMulti)mg;
            OMGraphicList subList = new OMGraphicList();
            int i = 0;
            while (i < multi.countElements()) {
                OMGraphic subRet = null;
                if (type.equals(MysqlGeometry.MULTIPOINTTYPE)) {
                    subRet = this.createPoint((MysqlPoint)multi.getElementByIndex(i));
                } else if (type.equals(MysqlGeometry.MULTILINESTRINGTYPE)) {
                    subRet = this.createLine((MysqlLine)multi.getElementByIndex(i));
                } else if (type.equals(MysqlGeometry.MULTIPOLYGONTYPE)) {
                    subRet = this.createPolygon((MysqlPolygon)multi.getElementByIndex(i));
                } else if (type.equals(MysqlGeometry.GEOMETRYCOLLECTIONTYPE)) {
                    subRet = this.createGraphic(multi.getElementByIndex(i));
                }
                if (subRet != null) {
                    subList.add(subRet);
                }
                ++i;
            }
            return subList;
        }
        if (!Debug.debugging("mysql")) return ret;
        Debug.output("MysqlGeometryLayer.createGeometry: Geometry type not supported");
        return ret;
    }

    private float[] DoubleToFloat(double[] d) {
        float[] f = new float[d.length];
        int i = 0;
        while (i < d.length) {
            f[i] = (float)d[i];
            ++i;
        }
        return f;
    }
}

