/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.csv;

import com.bbn.openmap.layer.location.Link;
import com.bbn.openmap.layer.location.csv.CSVLocationHandler;
import com.bbn.openmap.util.CSVTokenizer;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.HandleError;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.quadtree.QuadTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class CSVLinkHandler
extends CSVLocationHandler {
    public static final String Lat1IndexProperty = "lat1Index";
    public static final String Lon1IndexProperty = "lon1Index";
    public static final String Lat2IndexProperty = "lat2Index";
    public static final String Lon2IndexProperty = "lon2Index";
    public static final String LinkTypeIndexProperty = "linkTypeIndex";
    public static final String DashIndexProperty = "dashIndex";
    public static final String ColorIndexProperty = "colorIndex";
    public static final String ThicknessIndexProperty = "thicknessIndex";
    public static final String GeoStyleIndexProperty = "geoStyleIndex";
    public static final String LinkTypesProperty = "linkTypes";
    protected int lat1Index = -1;
    protected int lon1Index = -1;
    protected int lat2Index = -1;
    protected int lon2Index = -1;
    protected int linkTypeIndex = -1;
    protected int geoStyleIndex = -1;
    protected int dashIndex = -1;
    protected int colorIndex = -1;
    protected int thicknessIndex = -1;

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        String lat1IndexString = properties.getProperty(realPrefix + Lat1IndexProperty);
        String lon1IndexString = properties.getProperty(realPrefix + Lon1IndexProperty);
        String lat2IndexString = properties.getProperty(realPrefix + Lat2IndexProperty);
        String lon2IndexString = properties.getProperty(realPrefix + Lon2IndexProperty);
        String linkTypeIndexString = properties.getProperty(realPrefix + LinkTypeIndexProperty);
        String dashIndexString = properties.getProperty(realPrefix + DashIndexProperty);
        String colorIndexString = properties.getProperty(realPrefix + ColorIndexProperty);
        String thicknessIndexString = properties.getProperty(realPrefix + ThicknessIndexProperty);
        String geoStyleIndexString = properties.getProperty(realPrefix + GeoStyleIndexProperty);
        this.lat1Index = -1;
        this.lon1Index = -1;
        this.lat2Index = -1;
        this.lon2Index = -1;
        this.colorIndex = -1;
        this.dashIndex = -1;
        this.thicknessIndex = -1;
        this.geoStyleIndex = -1;
        if (lat1IndexString != null && lon1IndexString != null) {
            try {
                this.lat1Index = Integer.valueOf(lat1IndexString);
                this.lon1Index = Integer.valueOf(lon1IndexString);
            }
            catch (NumberFormatException e) {
                Debug.error("CSVLinkHandler: Unable to parse node1Index string.");
            }
        } else {
            Debug.error("CSVNodeLayer: no Index-1 specified as lat/lon or node");
        }
        if (lat2IndexString != null && lon2IndexString != null) {
            try {
                this.lat2Index = Integer.valueOf(lat2IndexString);
                this.lon2Index = Integer.valueOf(lon2IndexString);
            }
            catch (NumberFormatException e) {
                Debug.error("CSVLinkHandler: Unable to parse node2Index string.");
            }
        } else {
            Debug.error("CSVNodeLayer: no Index-2 specified as lat/lon or node");
        }
        if (linkTypeIndexString != null) {
            try {
                this.linkTypeIndex = Integer.valueOf(linkTypeIndexString);
            }
            catch (NumberFormatException e) {
                Debug.error("CSVLinkHandler: Unable to parse linkTypeIndex string.");
            }
        } else {
            Debug.error("CSVNodeLayer: no linkTypeIndex specified");
        }
        if (geoStyleIndexString != null) {
            try {
                this.geoStyleIndex = Integer.valueOf(geoStyleIndexString);
            }
            catch (NumberFormatException e) {
                Debug.error("CSVLinkHandler: Unable to parse geoStyleIndex string.");
            }
        } else {
            Debug.error("CSVNodeLayer: no geoStyleIndex specified");
        }
        if (dashIndexString != null) {
            try {
                this.dashIndex = Integer.valueOf(dashIndexString);
            }
            catch (NumberFormatException e) {
                Debug.error("CSVLinkHandler: Unable to parse dashIndex string.");
            }
        } else {
            Debug.error("CSVNodeLayer: no dashIndex specified");
        }
        if (colorIndexString != null) {
            try {
                this.colorIndex = Integer.valueOf(colorIndexString);
            }
            catch (NumberFormatException e) {
                Debug.error("CSVLinkHandler: Unable to parse colorIndex string.");
            }
        } else {
            Debug.error("CSVNodeLayer: no colorIndex specified");
        }
        if (thicknessIndexString != null) {
            try {
                this.thicknessIndex = Integer.valueOf(thicknessIndexString);
            }
            catch (NumberFormatException e) {
                Debug.error("CSVLinkHandler: Unable to parse thicknessIndex string.");
            }
        } else {
            Debug.error("CSVNodeLayer: no thicknessIndex specified");
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + Lat1IndexProperty, Integer.toString(this.lat1Index));
        props.put(prefix + Lon1IndexProperty, Integer.toString(this.lon1Index));
        props.put(prefix + Lat2IndexProperty, Integer.toString(this.lat2Index));
        props.put(prefix + Lon2IndexProperty, Integer.toString(this.lon2Index));
        props.put(prefix + DashIndexProperty, Integer.toString(this.dashIndex));
        props.put(prefix + ColorIndexProperty, Integer.toString(this.colorIndex));
        props.put(prefix + ThicknessIndexProperty, Integer.toString(this.thicknessIndex));
        props.put(prefix + GeoStyleIndexProperty, Integer.toString(this.geoStyleIndex));
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put(Lat1IndexProperty, "The column index, in the location file, of the first node latitude.");
        list.put(Lon1IndexProperty, "The column index, in the location file, of the first node longitude.");
        list.put(Lat2IndexProperty, "The column index, in the location file, of the second node latitude.");
        list.put(Lon2IndexProperty, "The column index, in the location file, of the second node longitude.");
        list.put(DashIndexProperty, "The column index, in the location file, of the true/false dash indicator.");
        list.put(ColorIndexProperty, "The column index, in the location file, of the color string.");
        list.put(ThicknessIndexProperty, "The column index, in the location file, of the pixel thickness of the link.");
        list.put(GeoStyleIndexProperty, "The column index, in the location file, of the render type of the link.");
        return list;
    }

    protected QuadTree createData() {
        QuadTree qt = new QuadTree(90.0f, -180.0f, -90.0f, 180.0f, 100, 50.0f);
        try {
            Object token = null;
            URL csvURL = new URL(new URL("file:"), this.locationFile);
            CSVTokenizer csvt = new CSVTokenizer(new BufferedReader(new InputStreamReader(csvURL.openStream())));
            float lat1 = 0.0f;
            float lon1 = 0.0f;
            float lat2 = 0.0f;
            float lon2 = 0.0f;
            String linkType = "";
            int linetype = 1;
            Color color = Color.black;
            boolean dashed = false;
            float thickness = 0.0f;
            Link link = null;
            token = csvt.token();
            if (Debug.debugging("link")) {
                Debug.output("CSVLinkHandler: Reading File:" + this.locationFile + " lat1Index: " + this.lat1Index + " lon1Index: " + this.lon1Index + " lat2Index: " + this.lat2Index + " lon2Index: " + this.lon2Index + " geoStyleIndex: " + this.geoStyleIndex + " dashIndex: " + this.dashIndex + " colorIndex: " + this.colorIndex + " thicknessIndex: " + this.thicknessIndex);
            }
            while (!csvt.isEOF(token)) {
                int i = 0;
                Debug.message("link", "CSVLinkHandler: Starting a line");
                while (!csvt.isNewline(token)) {
                    try {
                        if (i == this.lat1Index) {
                            lat1 = ((Double)token).floatValue();
                        } else if (i == this.lon1Index) {
                            lon1 = ((Double)token).floatValue();
                        } else if (i == this.lat2Index) {
                            lat2 = ((Double)token).floatValue();
                        } else if (i == this.lon2Index) {
                            lon2 = ((Double)token).floatValue();
                        } else if (i == this.geoStyleIndex) {
                            linetype = this.getLineTypeFromToken(token);
                        } else if (i == this.colorIndex) {
                            color = this.getColorFromToken(token);
                        } else if (i == this.thicknessIndex) {
                            thickness = ((Double)token).floatValue();
                        } else if (i == this.dashIndex) {
                            dashed = Boolean.valueOf((String)token);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    token = csvt.token();
                    ++i;
                }
                link = new Link(lat1, lon1, lat2, lon2, "no details", color, dashed, thickness, linetype);
                link.setLocationHandler(this);
                Debug.message("link", "CSVLinkHandler: " + link.getDetails());
                qt.put(lat1, lon1, link);
                qt.put(lat2, lon2, link);
                token = csvt.token();
            }
        }
        catch (IOException ioe) {
            throw new HandleError(ioe);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new HandleError(aioobe);
        }
        catch (NumberFormatException nfe) {
            throw new HandleError(nfe);
        }
        catch (ClassCastException cce) {
            throw new HandleError(cce);
        }
        Debug.message("link", "CSVLinkHandler: Finished File:" + this.locationFile);
        return qt;
    }

    public Component getGUI() {
        JCheckBox showCSVLinkCheck = new JCheckBox("Show Links", this.isShowLocations());
        showCSVLinkCheck.setActionCommand("showLocations");
        showCSVLinkCheck.addActionListener(this);
        JButton rereadFilesButton = new JButton("Re-Read Data File");
        rereadFilesButton.setActionCommand("readData");
        rereadFilesButton.addActionListener(this);
        Box box = Box.createVerticalBox();
        box.add(showCSVLinkCheck);
        box.add(rereadFilesButton);
        return box;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "showLocations") {
            JCheckBox linkCheck = (JCheckBox)e.getSource();
            this.setShowLocations(linkCheck.isSelected());
            if (Debug.debugging("location")) {
                Debug.output("CSVLinkHandler::actionPerformed showLocations is " + this.isShowLocations());
            }
            this.getLayer().repaint();
        } else if (cmd == "readData") {
            Debug.output("Re-reading links file");
            this.quadtree = null;
            this.getLayer().doPrepare();
        } else {
            Debug.error("Unknown action command \"" + cmd + "\" in CSVLinkLayer.actionPerformed().");
        }
    }

    protected int getLineTypeFromToken(Object token) {
        int default_lintetype = 1;
        String tokstring = (String)token;
        if (Debug.debugging("link")) {
            Debug.output("CSVLinkHandler:getLineTypeFromToken(" + tokstring + ")");
        }
        if (tokstring.equals("STRAIGHT")) {
            return 1;
        }
        if (tokstring.equals("GC")) {
            return 3;
        }
        if (tokstring.equals("RHUMB")) {
            return 2;
        }
        Debug.error("Don't understand Linetype " + tokstring + ", using default (STRAIGHT)");
        return default_lintetype;
    }

    protected Color getColorFromToken(Object token) {
        String tokstring = (String)token;
        Color result = Color.black;
        if (Debug.debugging("link")) {
            Debug.output("CSVLinkHandler: getColorFromToken(" + tokstring + ")");
        }
        result = tokstring.equals("black") ? Color.black : (tokstring.equals("blue") ? Color.blue : (tokstring.equals("cyan") ? Color.cyan : (tokstring.equals("darkGray") ? Color.darkGray : (tokstring.equals("gray") ? Color.gray : (tokstring.equals("green") ? Color.green : (tokstring.equals("lightGray") ? Color.lightGray : (tokstring.equals("magenta") ? Color.magenta : (tokstring.equals("orange") ? Color.orange : (tokstring.equals("pink") ? Color.pink : (tokstring.equals("red") ? Color.red : (tokstring.equals("white") ? Color.white : (tokstring.equals("yellow") ? Color.yellow : Color.decode(tokstring)))))))))))));
        if (Debug.debugging("link")) {
            Debug.output("CSVLinkHandler: getColorFromToken returns (" + result + ")");
        }
        return result;
    }
}

