/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.grid.GridData;
import com.bbn.openmap.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkGrid
implements LinkGraphicConstants {
    public static void write(float lt, float ln, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:GRID>".getBytes());
        dos.writeInt(8);
        dos.writeInt(1);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(rows);
        dos.writeInt(columns);
        dos.writeFloat(orientation);
        dos.writeFloat(vResolution);
        dos.writeFloat(hResolution);
        dos.writeInt(major);
        dos.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            dos.writeInt(data[i]);
            ++i;
        }
        properties.write(dos);
    }

    public static void write(int x1, int y1, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:GRID>".getBytes());
        dos.writeInt(8);
        dos.writeInt(2);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(rows);
        dos.writeInt(columns);
        dos.writeFloat(orientation);
        dos.writeFloat(vResolution);
        dos.writeFloat(hResolution);
        dos.writeInt(major);
        dos.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            dos.writeInt(data[i]);
            ++i;
        }
        properties.write(dos);
    }

    public static void write(float lt, float ln, int offset_x1, int offset_y1, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:GRID>".getBytes());
        dos.writeInt(8);
        dos.writeInt(3);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        dos.writeInt(rows);
        dos.writeInt(columns);
        dos.writeFloat(orientation);
        dos.writeFloat(vResolution);
        dos.writeFloat(hResolution);
        dos.writeInt(major);
        dos.writeInt(data.length);
        int i = 0;
        while (i < data.length) {
            dos.writeInt(data[i]);
            ++i;
        }
        properties.write(dos);
    }

    public static void write(OMGrid grid, Link link, LinkProperties props) throws IOException {
        int major = grid.getMajor() ? 1 : 0;
        int rows = grid.getRows();
        int columns = grid.getColumns();
        GridData gd = grid.getData();
        if (!(gd instanceof GridData.Int)) {
            Debug.output("LinkGrid requires OMGrid containing integer data.");
            return;
        }
        int[][] d = ((GridData.Int)gd).getData();
        int[] data = new int[rows * columns];
        int i = 0;
        while (i < d.length) {
            int j = 0;
            while (j < d[0].length) {
                data[i * d[0].length + j] = d[i][j];
                ++j;
            }
            ++i;
        }
        switch (grid.getRenderType()) {
            case 1: {
                LinkGrid.write(grid.getLatitude(), grid.getLongitude(), rows, columns, grid.getOrientation(), grid.getVerticalResolution(), grid.getHorizontalResolution(), major, data, props, (DataOutputStream)link.dos);
                break;
            }
            case 2: {
                LinkGrid.write((int)grid.getPoint().getX(), (int)grid.getPoint().getY(), rows, columns, grid.getOrientation(), grid.getVerticalResolution(), grid.getHorizontalResolution(), major, data, props, (DataOutputStream)link.dos);
                break;
            }
            case 3: {
                LinkGrid.write(grid.getLatitude(), grid.getLongitude(), (int)grid.getPoint().getX(), (int)grid.getPoint().getY(), rows, columns, grid.getOrientation(), grid.getVerticalResolution(), grid.getHorizontalResolution(), major, data, props, link.dos);
                break;
            }
            default: {
                Debug.error("LinkGrid.write: grid rendertype unknown.");
            }
        }
    }

    public static OMGrid read(DataInputStream dis) throws IOException {
        Debug.message("linkdetail", "LinkGrid: reading from link.");
        OMGrid grid = null;
        float lat = 0.0f;
        float lon = 0.0f;
        int x = 0;
        int y = 0;
        int renderType = dis.readInt();
        switch (renderType) {
            case 3: {
                lat = dis.readFloat();
                lon = dis.readFloat();
                Debug.message("linkdetail", "LinkGrid: Offset Lat/Lon = " + lat + "/" + lon + " with");
            }
            case 2: {
                x = dis.readInt();
                y = dis.readInt();
                Debug.message("linkdetail", "LinkGrid: x/y = " + x + "/" + y);
                break;
            }
            default: {
                lat = dis.readFloat();
                lon = dis.readFloat();
                Debug.message("linkdetail", "LinkGrid: Lat/Lon = " + lat + "/" + lon);
            }
        }
        int rows = dis.readInt();
        int columns = dis.readInt();
        float orientation = dis.readFloat();
        float vResolution = dis.readFloat();
        float hResolution = dis.readFloat();
        int major = dis.readInt();
        int length = dis.readInt();
        Debug.message("linkdetail", "LinkGrid details: rows = " + rows + ", columns = " + columns + ", orientation = " + orientation + ", vertical resolution = " + vResolution + ", horizontal resolution = " + hResolution + ", major dimension = " + (major == 0 ? "COLUMN_MAJOR" : "ROW_MAJOR") + ", with number of points = " + length);
        int[][] data = major == 0 ? new int[columns][rows] : new int[rows][columns];
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[0].length) {
                data[i][j] = dis.readInt();
                ++j;
            }
            ++i;
        }
        Debug.message("linkdetail", "LinkGrid read all the data.");
        switch (renderType) {
            case 3: {
                grid = new OMGrid(lat, lon, x, y, vResolution, hResolution, data);
                break;
            }
            case 2: {
                grid = new OMGrid(x, y, vResolution, hResolution, data);
                break;
            }
            default: {
                grid = new OMGrid(lat, lon, vResolution, hResolution, data);
            }
        }
        Debug.message("linkdetail", "LinkGrid created OMGrid.");
        LinkProperties properties = new LinkProperties(dis);
        if (grid != null) {
            grid.setMajor(major == 0);
            grid.setOrientation(orientation);
            grid.setAppObject(properties);
        }
        Debug.message("linkdetail", "LinkGrid done.");
        return grid;
    }
}

