/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.ProgressListener;
import com.bbn.openmap.event.ProgressSupport;
import com.bbn.openmap.gui.ProgressListenerGauge;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.layer.dted.DTEDFrameUtil;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class DTEDCoverageManager {
    public static final String defaultLevel0ColorString = "CE4F3F";
    public static final String defaultLevel1ColorString = "339159";
    public static final String defaultLevel2ColorString = "0C75D3";
    protected Paint level0Color = new Color(Integer.parseInt("CE4F3F", 16));
    protected Paint level1Color = new Color(Integer.parseInt("339159", 16));
    protected Paint level2Color = new Color(Integer.parseInt("0C75D3", 16));
    protected int opaqueness = 255;
    protected boolean fillRects = false;
    protected boolean[][] level0Frames = null;
    protected boolean[][] level1Frames = null;
    protected boolean[][] level2Frames = null;
    protected ProgressSupport progressSupport = new ProgressSupport(this);

    public DTEDCoverageManager(String[] paths, String[] paths2, String coverageURL, String coverageFile) {
        if (!this.readCoverageFile(coverageURL, coverageFile)) {
            this.addProgressListener(new ProgressListenerGauge("Creating DTED Coverage File"));
            this.fireProgressUpdate(0, "Building DTED Coverage file...", 0, 100);
            this.level0Frames = new boolean[180][360];
            this.level1Frames = new boolean[180][360];
            this.level2Frames = new boolean[180][360];
            if (paths != null || paths2 != null) {
                Debug.output("DTEDCoverageManager: Scanning for frames - This could take several minutes!");
                this.checkOutCoverage(paths, paths2);
            } else {
                Debug.message("dtedcov", "DTEDCoverageManader: No paths for DTED data given.");
            }
            if (coverageFile != null) {
                this.fireProgressUpdate(1, "Writing DTED Coverage file...", 100, 100);
                this.writeCoverageFile(coverageFile);
            } else {
                Debug.message("dtedcov", "DTEDCoverageManager: No file path specified to write coverage file!");
            }
            this.fireProgressUpdate(2, "Wrote DTED Coverage file", 100, 100);
        }
    }

    public void setPaint(Paint lev0Color, Paint lev1Color, Paint lev2Color, int opaque, boolean fillRectangles) {
        this.level0Color = lev0Color;
        this.level1Color = lev1Color;
        this.level2Color = lev2Color;
        this.opaqueness = opaque;
        this.fillRects = fillRectangles;
    }

    public void checkOutCoverage(String[] paths, String[] paths2) {
        int d1;
        int maxNumPaths = 0;
        if (paths != null) {
            maxNumPaths = paths.length;
        }
        if (paths2 != null && paths2.length > maxNumPaths) {
            maxNumPaths = paths2.length;
        }
        if (maxNumPaths == 0) {
            System.err.println("DTEDCoverageManader: No paths for DTED data given.");
            return;
        }
        if (paths != null) {
            Debug.message("dtedcov", "DTEDCoverageManager: checking out DTED level 0, 1 at paths:");
            d1 = 0;
            while (d1 < paths.length) {
                if (Debug.debugging("dtedcov")) {
                    Debug.output("       " + paths[d1]);
                }
                if (!BinaryFile.exists(paths[d1])) {
                    paths[d1] = null;
                    Debug.message("dtedcov", "       - path invalid, ignoring.");
                }
                ++d1;
            }
        } else {
            Debug.message("dtedcov", "DTEDCoverageManager: No DTED level 0, 1 paths specified.");
        }
        if (paths2 != null) {
            Debug.message("dtedcov", "DTEDCoverageManager: checking out DTED level 2 at paths:");
            d1 = 0;
            while (d1 < paths2.length) {
                if (Debug.debugging("dtedcov")) {
                    Debug.output("       " + paths2[d1]);
                }
                if (!BinaryFile.exists(paths2[d1])) {
                    paths2[d1] = null;
                    Debug.message("dtedcov", "       - path invalid, ignoring.");
                }
                ++d1;
            }
        } else {
            Debug.message("dtedcov", "DTEDCoverageManager: No DTED level 2 paths specified.");
        }
        int pathNum = 0;
        while (pathNum < maxNumPaths) {
            int lat = -90;
            while (lat < 90) {
                int lon = -180;
                while (lon < 180) {
                    int latindex = lat + 90;
                    int lonindex = lon + 180;
                    if (paths != null && pathNum < paths.length && paths[pathNum] != null) {
                        if (!this.level0Frames[latindex][lonindex]) {
                            this.level0Frames[latindex][lonindex] = BinaryFile.exists(paths[pathNum] + File.separator + DTEDFrameUtil.lonToFileString(lon) + File.separator + DTEDFrameUtil.latToFileString(lat, 0));
                        }
                        if (!this.level1Frames[latindex][lonindex]) {
                            this.level1Frames[latindex][lonindex] = BinaryFile.exists(paths[pathNum] + File.separator + DTEDFrameUtil.lonToFileString(lon) + File.separator + DTEDFrameUtil.latToFileString(lat, 1));
                        }
                    }
                    if (paths2 != null && pathNum < paths2.length && paths2[pathNum] != null && !this.level2Frames[latindex][lonindex]) {
                        this.level2Frames[latindex][lonindex] = BinaryFile.exists(paths2[pathNum] + File.separator + DTEDFrameUtil.lonToFileString(lon) + File.separator + DTEDFrameUtil.latToFileString(lat, 1));
                    }
                    ++lon;
                }
                float pathFactor = ((float)pathNum + 1.0f) / (float)maxNumPaths;
                float latFactor = 100.0f * ((float)lat + 90.0f) / 180.0f;
                int whereWeAre = (int)(pathFactor * latFactor);
                if (Debug.debugging("dtedcov")) {
                    Debug.output("Building DTED Coverage, " + whereWeAre + "% complete.");
                }
                this.fireProgressUpdate(1, "Finding DTED frames...", whereWeAre, 100);
                ++lat;
            }
            ++pathNum;
        }
    }

    public OMGraphicList[] getCoverageRects(Projection proj) {
        LatLonPoint ul = proj.getUpperLeft();
        LatLonPoint lr = proj.getLowerRight();
        int startx = (int)Math.floor(ul.getLongitude());
        int endx = (int)Math.floor(lr.getLongitude());
        if (endx > 179) {
            endx = 179;
        }
        if (startx > 179) {
            startx = 179;
        }
        int starty = (int)Math.floor(lr.getLatitude());
        int endy = (int)Math.floor(ul.getLatitude());
        if (endy > 89) {
            endy = 89;
        }
        if (starty > 89) {
            starty = 89;
        }
        int LineType2 = proj instanceof Cylindrical ? 1 : 2;
        if (startx > endx) {
            OMGraphicList[] ret1 = this.getCoverageRects(startx, starty, 179, endy, LineType2);
            OMGraphicList[] ret2 = this.getCoverageRects(-180, starty, endx, endy, LineType2);
            ret1[0].add(ret2[0]);
            ret1[1].add(ret2[1]);
            ret1[2].add(ret2[2]);
            return ret1;
        }
        return this.getCoverageRects(startx, starty, endx, endy, LineType2);
    }

    public OMGraphicList[] getCoverageRects(int startx, int starty, int endx, int endy, int LineType2) {
        OMGraphicList gl0 = new OMGraphicList();
        OMGraphicList gl1 = new OMGraphicList();
        OMGraphicList gl2 = new OMGraphicList();
        OMGraphicList[] ret = new OMGraphicList[]{gl0, gl1, gl2};
        int lat = starty;
        while (lat <= endy) {
            int lon = startx;
            while (lon <= endx) {
                OMRect rect;
                if (this.level0Frames[lat + 90][lon + 180]) {
                    rect = new OMRect(lat, lon, (float)lat + 1.0f, (float)lon + 1.0f, LineType2);
                    rect.setLinePaint(this.level0Color);
                    if (this.fillRects) {
                        rect.setFillPaint(this.level0Color);
                    }
                    gl0.add(rect);
                }
                if (this.level1Frames[lat + 90][lon + 180]) {
                    rect = new OMRect((float)lat + 0.1f, (float)lon + 0.1f, (float)lat + 0.9f, (float)lon + 0.9f, LineType2);
                    rect.setLinePaint(this.level1Color);
                    if (this.fillRects) {
                        rect.setFillPaint(this.level1Color);
                    }
                    gl1.add(rect);
                }
                if (this.level2Frames[lat + 90][lon + 180]) {
                    rect = new OMRect((float)lat + 0.2f, (float)lon + 0.2f, (float)lat + 0.8f, (float)lon + 0.8f, LineType2);
                    rect.setLinePaint(this.level2Color);
                    if (this.fillRects) {
                        rect.setFillPaint(this.level2Color);
                    }
                    gl2.add(rect);
                }
                ++lon;
            }
            ++lat;
        }
        return ret;
    }

    public boolean readCoverageFile(String coverage) {
        try {
            Debug.message("dtedcov", "DTEDCoverageManager: Reading coverage file - " + coverage);
            BinaryBufferedFile binFile = new BinaryBufferedFile(coverage);
            this.level0Frames = new boolean[180][];
            this.level1Frames = new boolean[180][];
            this.level2Frames = new boolean[180][];
            byte[] row = new byte[360];
            int level = 0;
            while (level < 3) {
                int lat = 0;
                while (lat < 180) {
                    binFile.read(row);
                    if (level == 0) {
                        this.level0Frames[lat] = this.convertBytesToBooleans(row);
                    } else if (level == 1) {
                        this.level1Frames[lat] = this.convertBytesToBooleans(row);
                    } else {
                        this.level2Frames[lat] = this.convertBytesToBooleans(row);
                    }
                    ++lat;
                }
                ++level;
            }
            return true;
        }
        catch (IOException ioe) {
            Debug.message("dtedcov", "DTEDCoverageManager: No coverage file - will create one at " + coverage);
            this.level0Frames = null;
            this.level1Frames = null;
            this.level2Frames = null;
            return false;
        }
    }

    protected boolean readCoverageFile(String urlCov, String coverage) {
        URL url = null;
        BufferedInputStream bin = null;
        BinaryBufferedFile binFile = null;
        this.level0Frames = null;
        this.level1Frames = null;
        this.level2Frames = null;
        if (urlCov != null) {
            Debug.message("dtedcov", "DTEDCoverageManager: Reading coverage file from URL - " + urlCov);
            try {
                url = new URL(urlCov);
                bin = new BufferedInputStream(url.openStream());
            }
            catch (MalformedURLException mue) {
                System.err.println("DTEDCoverageManager: Weird URL given : \"" + urlCov + "\"");
                bin = null;
            }
            catch (IOException e) {
                System.err.println("DTEDCoverageManager: Unable to read coverage file at \"" + urlCov + "\"");
                bin = null;
            }
        }
        if (bin == null && coverage != null) {
            try {
                Debug.message("dtedcov", "DTEDCoverageManager: Reading coverage file - " + coverage);
                binFile = new BinaryBufferedFile(coverage);
            }
            catch (IOException e) {
                System.err.println("DTEDCoverageManager: Unable to read coverage file at \"" + coverage + "\"");
            }
        }
        if (bin != null || binFile != null) {
            try {
                this.level0Frames = new boolean[180][];
                this.level1Frames = new boolean[180][];
                this.level2Frames = new boolean[180][];
                byte[] row = new byte[360];
                int level = 0;
                while (level < 3) {
                    int lat = 0;
                    while (lat < 180) {
                        if (bin != null) {
                            int k = 0;
                            while (k < row.length) {
                                row[k] = (byte)bin.read();
                                ++k;
                            }
                        } else {
                            binFile.read(row);
                        }
                        if (level == 0) {
                            this.level0Frames[lat] = this.convertBytesToBooleans(row);
                        } else if (level == 1) {
                            this.level1Frames[lat] = this.convertBytesToBooleans(row);
                        } else {
                            this.level2Frames[lat] = this.convertBytesToBooleans(row);
                        }
                        ++lat;
                    }
                    ++level;
                }
                return true;
            }
            catch (IOException ioe) {
                System.err.println("DTECoverageLayer: Error reading coverage.");
                this.level0Frames = null;
                this.level1Frames = null;
                this.level2Frames = null;
            }
        }
        if (this.level0Frames == null) {
            System.err.println("DTEDCoverageManager: Error reading coverage file - will try to create a valid one at " + coverage);
        }
        return false;
    }

    protected boolean[] convertBytesToBooleans(byte[] row) {
        boolean[] ret = new boolean[row.length];
        int i = 0;
        while (i < row.length) {
            ret[i] = row[i] != 0;
            ++i;
        }
        return ret;
    }

    protected byte[] convertBooleansToBytes(boolean[] row) {
        byte[] ret = new byte[row.length];
        int i = 0;
        while (i < row.length) {
            ret[i] = row[i] ? (byte)1 : 0;
            ++i;
        }
        return ret;
    }

    public void writeCoverageFile(String covFilename) {
        try {
            Debug.message("dtedcov", "DTEDCoverageManager: Writing coverage summary file...");
            FileOutputStream binFile = new FileOutputStream(covFilename);
            int level = 0;
            while (level < 3) {
                int lat = 0;
                while (lat < 180) {
                    byte[] row = level == 0 ? this.convertBooleansToBytes(this.level0Frames[lat]) : (level == 1 ? this.convertBooleansToBytes(this.level1Frames[lat]) : this.convertBooleansToBytes(this.level2Frames[lat]));
                    binFile.write(row);
                    ++lat;
                }
                ++level;
            }
            binFile.close();
        }
        catch (IOException ioe) {
            System.err.println("DTEDCoverageManager: Error writing coverage file!");
        }
    }

    public void addProgressListener(ProgressListener list) {
        this.progressSupport.addProgressListener(list);
    }

    public void removeProgressListener(ProgressListener list) {
        this.progressSupport.removeProgressListener(list);
    }

    public void clearProgressListeners() {
        this.progressSupport.removeAll();
    }

    protected void fireProgressUpdate(int type, String task, int frameNumber, int totalFrames) {
        this.progressSupport.fireUpdate(type, task, totalFrames, frameNumber);
    }
}

