/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.layer.dted.DTEDCoverageManager;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JCheckBox;

public class DTEDCoverageLayer
extends Layer
implements ProjectionListener,
ActionListener {
    protected OMGraphicList[] omGraphics;
    protected Projection projection;
    protected boolean cancelled = false;
    protected String[] paths;
    protected String[] paths2;
    protected boolean showDTEDLevel0;
    protected boolean showDTEDLevel1;
    protected boolean showDTEDLevel2;
    protected Color level0Color;
    protected Color level1Color;
    protected Color level2Color;
    protected int opaqueness;
    protected boolean fillRects;
    protected String coverageFile = null;
    protected String coverageURL = null;
    protected DTEDCoverageManager coverageManager = null;
    private static final String showLevel0Command = "showLevel0";
    private static final String showLevel1Command = "showLevel1";
    private static final String showLevel2Command = "showLevel2";
    public static final String DTEDPathsProperty = ".paths";
    public static final String DTED2PathsProperty = ".level2.paths";
    public static final String ShowLevel0Property = ".level0.showcov";
    public static final String Level0ColorProperty = ".level0.color";
    public static final String ShowLevel1Property = ".level1.showcov";
    public static final String Level1ColorProperty = ".level1.color";
    public static final String ShowLevel2Property = ".level2.showcov";
    public static final String Level2ColorProperty = ".level2.color";
    public static final String OpaquenessProperty = ".opaque";
    public static final String FillProperty = ".fill";
    public static final String CoverageFileProperty = ".coverageFile";
    public static final String CoverageURLProperty = ".coverageURL";
    protected DTEDCoverageWorker currentWorker;

    protected void setDefaultValues() {
        this.paths = null;
        this.paths2 = null;
        this.showDTEDLevel0 = true;
        this.showDTEDLevel1 = true;
        this.showDTEDLevel2 = true;
        this.opaqueness = 255;
        this.fillRects = false;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.setDefaultValues();
        this.paths = LayerUtils.initPathsFromProperties(properties, prefix + DTEDPathsProperty);
        this.paths2 = LayerUtils.initPathsFromProperties(properties, prefix + DTED2PathsProperty);
        this.coverageFile = properties.getProperty(prefix + CoverageFileProperty);
        this.coverageURL = properties.getProperty(prefix + CoverageURLProperty);
        this.fillRects = LayerUtils.booleanFromProperties(properties, prefix + FillProperty, false);
        this.opaqueness = LayerUtils.intFromProperties(properties, prefix + OpaquenessProperty, 255);
        this.level0Color = LayerUtils.parseColorFromProperties(properties, prefix + Level0ColorProperty, "CE4F3F");
        this.level1Color = LayerUtils.parseColorFromProperties(properties, prefix + Level1ColorProperty, "339159");
        this.level2Color = LayerUtils.parseColorFromProperties(properties, prefix + Level2ColorProperty, "0C75D3");
        this.showDTEDLevel0 = LayerUtils.booleanFromProperties(properties, prefix + ShowLevel0Property, true);
        this.showDTEDLevel1 = LayerUtils.booleanFromProperties(properties, prefix + ShowLevel1Property, true);
        this.showDTEDLevel2 = LayerUtils.booleanFromProperties(properties, prefix + ShowLevel2Property, true);
    }

    public synchronized void setGraphicLists(OMGraphicList[] aList) {
        this.omGraphics = aList;
    }

    public synchronized OMGraphicList[] getGraphicLists() {
        return this.omGraphics;
    }

    public synchronized void setCancelled(boolean set) {
        this.cancelled = set;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            Debug.error("DTEDCoverageLayer.renderDataForProjection: null projection!");
            return;
        }
        if (!proj.equals(this.projection)) {
            this.projection = proj.makeClone();
            this.setGraphicLists(this.prepare());
        }
        this.paint(g);
    }

    public void projectionChanged(ProjectionEvent e) {
        Debug.message("basic", this.getName() + "|DTEDCoverageLayer.projectionChanged()");
        if (this.projection != null && this.projection.equals(e.getProjection())) {
            this.repaint();
            return;
        }
        this.setGraphicLists(null);
        this.projection = e.getProjection().makeClone();
        if (this.currentWorker == null) {
            this.currentWorker = new DTEDCoverageWorker();
            this.currentWorker.execute();
        } else {
            this.setCancelled(true);
        }
    }

    protected synchronized void workerComplete(DTEDCoverageWorker worker) {
        if (!this.isCancelled()) {
            this.currentWorker = null;
            this.setGraphicLists((OMGraphicList[])worker.get());
            this.repaint();
        } else {
            this.setCancelled(false);
            this.currentWorker = new DTEDCoverageWorker();
            this.currentWorker.execute();
        }
    }

    public synchronized OMGraphicList[] prepare() {
        if (this.isCancelled()) {
            Debug.message("dtedcov", this.getName() + "|DTEDCoverageLayer.prepare(): aborted.");
            return null;
        }
        Debug.message("basic", this.getName() + "|DTEDCoverageLayer.prepare(): doing it");
        if (Debug.debugging("dtedcov")) {
            Debug.output(this.getName() + "|DTEDCoverageLayer.prepare(): " + "calling prepare with projection: " + this.projection + " ul = " + this.projection.getUpperLeft() + " lr = " + this.projection.getLowerRight());
        }
        if (this.coverageManager == null) {
            this.coverageManager = new DTEDCoverageManager(this.paths, this.paths2, this.coverageURL, this.coverageFile);
            this.coverageManager.setPaint(this.level0Color, this.level1Color, this.level2Color, this.opaqueness, this.fillRects);
        }
        OMGraphicList[] omGraphicLists = this.coverageManager.getCoverageRects(this.projection);
        int size = 0;
        if (omGraphicLists != null) {
            int j = 0;
            while (j < omGraphicLists.length) {
                size = omGraphicLists[j].size();
                Debug.message("basic", this.getName() + "|DTEDCoverageLayer.prepare(): finished with " + size + " level " + j + " graphics");
                ++j;
            }
        } else {
            Debug.message("basic", this.getName() + "|DTEDCoverageLayer.prepare(): finished with null graphics list");
        }
        int k = 0;
        while (k < omGraphicLists.length) {
            omGraphicLists[k].project(this.projection, true);
            ++k;
        }
        return omGraphicLists;
    }

    public void paint(Graphics g) {
        Debug.message("dtedcov", this.getName() + "|DTEDCoverageLayer.paint()");
        OMGraphicList[] tmpGraphics = this.getGraphicLists();
        if (tmpGraphics != null) {
            int k = 0;
            while (k < tmpGraphics.length) {
                if (k == 0 && this.showDTEDLevel0) {
                    tmpGraphics[k].render(g);
                }
                if (k == 1 && this.showDTEDLevel1) {
                    tmpGraphics[k].render(g);
                }
                if (k == 2 && this.showDTEDLevel2) {
                    tmpGraphics[k].render(g);
                }
                ++k;
            }
        }
    }

    public Component getGUI() {
        JCheckBox showLevel0Check = new JCheckBox("Show Level 0 Coverage", this.showDTEDLevel0);
        showLevel0Check.setActionCommand(showLevel0Command);
        showLevel0Check.addActionListener(this);
        JCheckBox showLevel1Check = new JCheckBox("Show Level 1 Coverage", this.showDTEDLevel1);
        showLevel1Check.setActionCommand(showLevel1Command);
        showLevel1Check.addActionListener(this);
        JCheckBox showLevel2Check = new JCheckBox("Show Level 2 Coverage", this.showDTEDLevel2);
        showLevel2Check.setActionCommand(showLevel2Command);
        showLevel2Check.addActionListener(this);
        Box box = Box.createVerticalBox();
        box.add(showLevel0Check);
        box.add(showLevel1Check);
        box.add(showLevel2Check);
        return box;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String cmd = e.getActionCommand();
        if (cmd == showLevel0Command) {
            JCheckBox level0Check = (JCheckBox)e.getSource();
            this.showDTEDLevel0 = level0Check.isSelected();
            this.repaint();
        } else if (cmd == showLevel1Command) {
            JCheckBox level1Check = (JCheckBox)e.getSource();
            this.showDTEDLevel1 = level1Check.isSelected();
            this.repaint();
        } else if (cmd == showLevel2Command) {
            JCheckBox level2Check = (JCheckBox)e.getSource();
            this.showDTEDLevel2 = level2Check.isSelected();
            this.repaint();
        }
    }

    class DTEDCoverageWorker
    extends SwingWorker {
        public Object construct() {
            Debug.message("dtedcov", DTEDCoverageLayer.this.getName() + "|DTEDCoverageWorker.construct()");
            DTEDCoverageLayer.this.fireStatusUpdate(8342);
            try {
                return DTEDCoverageLayer.this.prepare();
            }
            catch (OutOfMemoryError e) {
                String msg = DTEDCoverageLayer.this.getName() + "|DTEDCoverageLayer.DTEDCoverageWorker.construct(): " + e;
                Debug.error(msg);
                e.printStackTrace();
                DTEDCoverageLayer.this.fireRequestMessage(new InfoDisplayEvent(this, msg));
                DTEDCoverageLayer.this.fireStatusUpdate(8359);
                return null;
            }
        }

        public void finished() {
            DTEDCoverageLayer.this.workerComplete(this);
            DTEDCoverageLayer.this.fireStatusUpdate(8359);
        }
    }
}

