/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.EditableOMPoly;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMArc;
import com.bbn.openmap.omGraphics.OMAreaList;
import com.bbn.openmap.omGraphics.OMBitmap;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMDecoratedSpline;
import com.bbn.openmap.omGraphics.OMEllipse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMSpline;
import com.bbn.openmap.omGraphics.awt.TextShapeDecoration;
import com.bbn.openmap.omGraphics.labeled.LabeledOMSpline;
import com.bbn.openmap.omGraphics.meteo.OMColdSurfaceFront;
import com.bbn.openmap.omGraphics.meteo.OMHotSurfaceFront;
import com.bbn.openmap.omGraphics.meteo.OMOcclusion;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.tools.drawing.DrawingTool;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DemoLayer
extends OMGraphicHandlerLayer
implements DrawingToolRequestor {
    protected JPanel legend;
    protected final DrawingToolRequestor layer = this;
    protected static final String internalKey = "ik";
    protected static final String externalKey = "ek";
    protected GraphicAttributes filterGA = null;
    protected DrawingTool drawingTool;

    public DemoLayer() {
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.legend != null) {
            this.legend.paint(g);
        }
    }

    public void init() {
        OMGraphicList omList = this.getList();
        int bytearrsize = 32;
        byte[] bytearr = new byte[bytearrsize];
        int i = 0;
        while (i < bytearr.length) {
            bytearr[i] = -1;
            ++i;
        }
        OMBitmap omb = new OMBitmap(45.3583f, -71.06f, 16, 16, bytearr);
        omb.setLinePaint(Color.red);
        omb.setFillPaint(null);
        omb.setSelectPaint(Color.blue);
        omb.setRotationAngle(1.5707963267948966);
        omList.add(omb);
        OMPoint point = new OMPoint(42.0f, -72.0f, 14);
        point.setFillPaint(Color.green);
        point.setOval(true);
        omList.add(point);
        OMCircle circle = new OMCircle(40.0f, -70.0f, 50, 200);
        circle.setRotationAngle(0.7853981852531433);
        omList.add(circle);
        int[] llPointsx = new int[5];
        int[] llPointsy = new int[5];
        llPointsy[0] = 10;
        llPointsx[0] = 170;
        llPointsy[1] = 42;
        llPointsx[1] = 273;
        llPointsy[2] = 38;
        llPointsx[2] = 374;
        llPointsy[3] = 78;
        llPointsx[3] = 468;
        llPointsy[4] = 84;
        llPointsx[4] = 369;
        LabeledOMSpline spline = new LabeledOMSpline(40.0f, -72.0f, llPointsx, llPointsy, 0);
        spline.setText("Testing");
        spline.setLocateAtCenter(true);
        omList.add(spline);
        OMSpline spline2 = new OMSpline(llPointsx, llPointsy);
        omList.add(spline2);
        float[] llPoints = new float[]{55.0f, -10.0f, 50.0f, -5.0f, 45.0f, -7.0f, 43.0f, -12.0f};
        OMColdSurfaceFront cf = new OMColdSurfaceFront(llPoints, 0, 1);
        omList.add(cf);
        float[] llPoints2 = new float[]{55.0f, -12.0f, 50.0f, -7.0f, 45.0f, -9.0f, 43.0f, -14.0f};
        OMHotSurfaceFront hf = new OMHotSurfaceFront(llPoints2, 0, 1);
        omList.add(hf);
        float[] llPoints3 = new float[]{55.0f, -14.0f, 50.0f, -9.0f, 45.0f, -11.0f, 43.0f, -16.0f};
        OMOcclusion oc = new OMOcclusion(llPoints3, 0, 1);
        omList.add(oc);
        float[] llPoints4 = new float[]{55.0f, -16.0f, 50.0f, -11.0f, 45.0f, -13.0f, 43.0f, -18.0f};
        OMDecoratedSpline spline3 = new OMDecoratedSpline(llPoints4, 0, 1){

            protected void initDecorations() {
                this.getDecorator().addDecoration(new TextShapeDecoration(" This one has a text ", new Font("arial", 0, 10), 19, 2));
            }
        };
        OMLine line = new OMLine(40.0f, -75.0f, 42.0f, -70.0f, 1);
        line.addArrowHead(2);
        line.setStroke(new BasicStroke(2.0f));
        omList.add(line);
        OMGraphicList pointList = new OMGraphicList();
        int i2 = 0;
        while (i2 < 100) {
            point = new OMPoint((float)(Math.random() * 89.0), (float)(Math.random() * -179.0), 3);
            point.setSelectPaint(Color.yellow);
            pointList.add(point);
            ++i2;
        }
        omList.add(pointList);
        OMEllipse ell = new OMEllipse(new LatLonPoint(60.0f, -110.0f), 1000.0, 300.0, Length.NM, 0.7853981852531433);
        ell.setLinePaint(Color.blue);
        omList.add(ell);
        ell = new OMEllipse(new LatLonPoint(40.0f, -75.0f), 800.0, 250.0, Length.MILE, 0.0);
        ell.setFillPaint(Color.yellow);
        omList.add(ell);
        float[] llp2 = new float[]{0.41789755f, -1.435303f, 0.41813868f, -1.3967744f};
        OMPoly p2 = new OMPoly(llp2, 1, 2);
        p2.setLinePaint(Color.yellow);
        omList.add(p2);
        OMArc arc = new OMArc(40.0f, 65.0f, 750.0f, Length.MILE, 20.0f, 95.0f);
        arc.setLinePaint(Color.red);
        arc.setFillPaint(new Color(120, 0, 0, 128));
        arc.setArcType(2);
        omList.add(arc);
        OMAreaList combo = new OMAreaList();
        combo.addOMGraphic(new OMLine(50.453335f, 5.223889f, 50.37528f, 4.873889f, 2));
        combo.addOMGraphic(new OMLine(50.37528f, 4.873889f, 50.436943f, 4.860556f, 2));
        combo.addOMGraphic(new OMArc(50.49127f, 4.704239f, 0.091685206f, 118.41945f, -90.21759f));
        combo.addOMGraphic(new OMLine(50.53417f, 4.831111f, 50.640835f, 4.832222f, 2));
        combo.addOMGraphic(new OMLine(50.640835f, 4.832222f, 50.54778f, 5.223889f, 2));
        combo.addOMGraphic(new OMLine(50.54778f, 5.223889f, 50.453335f, 5.223889f, 2));
        combo.setLinePaint(Color.blue);
        combo.setFillPaint(Color.green);
        omList.add(combo);
        OMAreaList combo1 = new OMAreaList();
        combo1.addOMGraphic(new OMLine(66.61852f, 141.56349f, 66.028244f, 140.19397f, 3));
        combo1.addOMGraphic(new OMLine(66.028244f, 140.19397f, 66.968056f, 137.61104f, 2));
        combo1.addOMGraphic(new OMLine(66.968056f, 137.61104f, 67.55826f, 139.03395f, 3));
        combo1.addOMGraphic(new OMLine(67.55826f, 139.03395f, 66.61852f, 141.56349f, 2));
        combo1.setLinePaint(Color.red);
        combo1.setFillPaint(Color.blue);
        omList.add(combo1);
        combo1 = new OMAreaList();
        combo1.addOMGraphic(new OMLine(65.49528f, 55.488888f, 65.02278f, 55.74917f, 3));
        combo1.addOMGraphic(new OMLine(65.02278f, 55.74917f, 64.970276f, 55.20861f, 2));
        combo1.addOMGraphic(new OMLine(64.970276f, 55.20861f, 65.44278f, 54.94889f, 3));
        combo1.addOMGraphic(new OMLine(65.44278f, 54.94889f, 65.49528f, 55.488888f, 2));
        combo1.setLinePaint(Color.blue);
        combo1.setFillPaint(Color.red);
        omList.add(combo1);
        OMArc arc1 = new OMArc(100, 100, 200, 200, 0.0f, -45.0f);
        arc1.setLinePaint(Color.blue);
        arc1.setFillPaint(Color.yellow);
        arc1.setArcType(2);
        omList.add(arc1);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.init();
        this.setAddToBeanContext(true);
    }

    public OMGraphicList getList() {
        OMGraphicList list = super.getList();
        if (list == null) {
            list = new OMGraphicList();
            super.setList(list);
        }
        return list;
    }

    protected GraphicAttributes getFilterGA() {
        if (this.filterGA == null) {
            this.filterGA = new GraphicAttributes();
            this.filterGA.setLinePaint(Color.red);
            this.filterGA.setRenderType(1);
            this.filterGA.setLineType(3);
            BasicStroke filterStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
            this.filterGA.setStroke(filterStroke);
        }
        return (GraphicAttributes)this.filterGA.clone();
    }

    public Component getGUI() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        JPanel box = PaletteHelper.createVerticalPanel(" Create Filters for Map ");
        box.setLayout(new GridLayout(0, 1));
        JButton button = new JButton("Create Containing Rectangle Filter");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawingTool dt = DemoLayer.this.getDrawingTool();
                if (dt != null) {
                    GraphicAttributes fga = DemoLayer.this.getFilterGA();
                    fga.setFillPaint(new OMColor(0xC0A0A0A));
                    OMRect rect = (OMRect)DemoLayer.this.getDrawingTool().create("com.bbn.openmap.omGraphics.OMRect", fga, DemoLayer.this.layer, false);
                    if (rect != null) {
                        rect.setAppObject(DemoLayer.internalKey);
                    } else {
                        Debug.error("DemoLayer: Drawing tool can't create OMRect");
                    }
                } else {
                    Debug.output("DemoLayer can't find a drawing tool");
                }
            }
        });
        box.add(button);
        button = new JButton("Create Containing Polygon Filter");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawingTool dt = DemoLayer.this.getDrawingTool();
                if (dt != null) {
                    GraphicAttributes fga = DemoLayer.this.getFilterGA();
                    fga.setFillPaint(OMColor.clear);
                    EditableOMPoly eomp = new EditableOMPoly(fga);
                    eomp.setEnclosed(true);
                    eomp.setShowGUI(false);
                    dt.setBehaviorMask(10);
                    OMPoly poly = (OMPoly)DemoLayer.this.getDrawingTool().edit(eomp, DemoLayer.this.layer);
                    if (poly != null) {
                        poly.setIsPolygon(true);
                        poly.setAppObject(DemoLayer.internalKey);
                    } else {
                        Debug.error("DemoLayer: Drawing tool can't create OMPoly");
                    }
                } else {
                    Debug.output("DemoLayer can't find a drawing tool");
                }
            }
        });
        box.add(button);
        button = new JButton("Create Excluding Rectangle Filter");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DrawingTool dt = DemoLayer.this.getDrawingTool();
                if (dt != null) {
                    GraphicAttributes fga = DemoLayer.this.getFilterGA();
                    fga.setFillPaint(OMColor.clear);
                    OMRect rect = (OMRect)DemoLayer.this.getDrawingTool().create("com.bbn.openmap.omGraphics.OMRect", fga, DemoLayer.this.layer, false);
                    if (rect != null) {
                        rect.setAppObject(DemoLayer.externalKey);
                    } else {
                        Debug.error("DemoLayer: Drawing tool can't create OMRect");
                    }
                } else {
                    Debug.output("DemoLayer can't find a drawing tool");
                }
            }
        });
        box.add(button);
        button = new JButton("Reset filter");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DemoLayer.this.resetFiltering();
                DemoLayer.this.repaint();
            }
        });
        box.add(button);
        gridbag.setConstraints(box, c);
        panel.add(box);
        return panel;
    }

    public DrawingTool getDrawingTool() {
        return this.drawingTool;
    }

    public void setDrawingTool(DrawingTool dt) {
        this.drawingTool = dt;
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        Debug.message("demo", "DemoLayer: DrawingTool complete");
        Object obj = omg.getAppObject();
        if (!(obj == null || obj != internalKey && obj != externalKey || action.isMask(4))) {
            GeneralPath filterShape = omg.getShape();
            OMGraphicList filteredList = this.filter(filterShape, omg.getAppObject() == internalKey);
            if (Debug.debugging("demo")) {
                Debug.output("DemoLayer filter: " + filteredList.getDescription());
            }
        } else {
            this.getList().doAction(omg, action);
        }
        this.repaint();
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof DrawingTool) {
            Debug.message("demo", "DemoLayer: found a drawing tool");
            this.setDrawingTool((DrawingTool)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof DrawingTool && this.getDrawingTool() == (DrawingTool)someObj) {
            this.setDrawingTool(null);
        }
    }

    public boolean isHighlightable(OMGraphic omg) {
        return true;
    }

    public boolean isSelectable(OMGraphic omg) {
        DrawingTool dt = this.getDrawingTool();
        return dt != null && dt.canEdit(omg.getClass());
    }

    public String getInfoText(OMGraphic omg) {
        DrawingTool dt = this.getDrawingTool();
        if (dt != null && dt.canEdit(omg.getClass())) {
            return "Click to edit graphic.";
        }
        return null;
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return "Demo Layer Object";
    }

    public void select(OMGraphicList list) {
        if (list != null && list.size() > 0) {
            OMGraphic omg = list.getOMGraphicAt(0);
            DrawingTool dt = this.getDrawingTool();
            if (dt != null && dt.canEdit(omg.getClass())) {
                dt.setBehaviorMask(10);
                if (dt.edit(omg, (DrawingToolRequestor)this) == null) {
                    this.fireRequestInfoLine("Can't figure out how to modify this object.");
                }
            }
        }
    }
}

