/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.image.ImageReceiver;
import com.bbn.openmap.image.ImageServer;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ImageMaster {
    public static final String ImageServersProperty = "servers";
    public static final String ServerPropertiesProperty = "properties";
    public static final String ImageProjectionProperty = "imageProjection";
    public static final String ImageLatitudeProperty = "imageLatitude";
    public static final String ImageLongitudeProperty = "imageLongitude";
    public static final String ImageScaleProperty = "imageScale";
    public static final String ImageHeightProperty = "imageHeight";
    public static final String ImageWidthProperty = "imageWidth";
    public static final String ImageBackgroundColorProperty = "imageBackgroundColor";
    public static final String ImageNameProperty = "outputName";
    public static final String ScaleToWidthProperty = "scaleToWidth";
    public static final String ScaleToHeightProperty = "scaleToHeight";
    public static final String OutputLogFileProperty = "outputLogFile";
    public static final String ErrorLogFileProperty = "errorLogFile";
    protected Hashtable instantiatedLayers = new Hashtable();
    ImageMasterHelper[] helpers;

    public ImageMaster(Properties props) {
        this.setProperties(props);
    }

    public ImageMaster(String propertiesFile) {
        Properties props = new Properties();
        this.loadProperties(props, propertiesFile);
        this.setProperties(props);
    }

    public ImageMaster(URL propertiesURL) {
        Properties props = new Properties();
        this.loadProperties(props, propertiesURL);
        this.setProperties(props);
    }

    protected boolean loadPropertiesFromResource(Properties props, String resourceName) {
        InputStream propsIn = this.getClass().getResourceAsStream(resourceName);
        if (propsIn == null) {
            if (Debug.debugging("imagemaster")) {
                Debug.error("Unable to locate resources: " + resourceName);
            }
            return false;
        }
        try {
            props.load(propsIn);
            return true;
        }
        catch (IOException e) {
            Debug.error("ImageMaster: Caught IOException loading resources: " + resourceName);
            return false;
        }
    }

    public boolean loadProperties(Properties props, URL url) {
        try {
            InputStream propsIn = url.openStream();
            props.load(propsIn);
            return true;
        }
        catch (IOException e) {
            Debug.error("ImageMaster: Caught IOException loading resources: " + url);
            return false;
        }
    }

    public boolean loadProperties(Properties props, String file) {
        File propsFile = new File(file);
        try {
            FileInputStream propsStream = new FileInputStream(propsFile);
            props.load(propsStream);
            return true;
        }
        catch (FileNotFoundException e) {
            Debug.error("ImageMaster.loadProperties(): Unable to read configuration file \"" + propsFile + "\"");
        }
        catch (IOException e) {
            Debug.error("ImageMaster.loadProperties(): Caught IO Exception reading configuration file \"" + propsFile + "\" \n" + e);
        }
        return false;
    }

    public void setProperties(Properties properties) {
        this.helpers = this.setImageServers(properties);
    }

    public void run() {
        this.doNext();
    }

    protected void doNext() {
        int i = 0;
        while (i < this.helpers.length) {
            if (!this.helpers[i].complete) {
                this.helpers[i].create();
                return;
            }
            ++i;
        }
        System.exit(0);
    }

    public ImageMasterHelper[] setImageServers(Properties properties) {
        String serversValue = properties.getProperty(ImageServersProperty);
        if (Debug.debugging("imagemaster")) {
            Debug.output("ImageMaster.setImageServers(): servers = \"" + serversValue + "\"");
        }
        if (serversValue == null) {
            Debug.error("ImageMaster.setImageServers(): No property \"servers\" found in application properties.");
            return new ImageMasterHelper[0];
        }
        StringTokenizer tokens = new StringTokenizer(serversValue, " ");
        Vector<String> serverNames = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            serverNames.addElement(tokens.nextToken());
        }
        if (Debug.debugging("imagemaster")) {
            Debug.output("ImageMaster.setImageServers(): " + serverNames);
        }
        int nServerNames = serverNames.size();
        ImageMasterHelper[] masterHelpers = new ImageMasterHelper[nServerNames];
        int i = 0;
        while (i < nServerNames) {
            String serverName = (String)serverNames.elementAt(i);
            masterHelpers[i] = new ImageMasterHelper(serverName, properties, this);
            ++i;
        }
        return masterHelpers;
    }

    public static void main(String[] args) {
        Debug.init();
        ImageMaster master = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-file")) {
                master = new ImageMaster(args[++i]);
            } else if (args[i].equalsIgnoreCase("-url")) {
                String url = null;
                try {
                    url = args[++i];
                    master = new ImageMaster(new URL(url));
                }
                catch (MalformedURLException mue) {
                    Debug.output("ImageMaster: Malformed URL: " + url);
                    master = null;
                }
            } else if (args[i].equalsIgnoreCase("-masterprops")) {
                ImageMaster.printMasterProps();
            } else if (args[i].equalsIgnoreCase("-serverprops")) {
                ImageMaster.printServerProps();
            } else if (args[i].equalsIgnoreCase("-h")) {
                ImageMaster.printHelp();
            }
            ++i;
        }
        if (master != null) {
            master.run();
        } else {
            ImageMaster.printHelp();
        }
    }

    public static void printHelp() {
        Debug.output("");
        Debug.output("usage: java com.bbn.openmap.image.ImageMaster [-file <properties file> || -url <properties file>] [-masterprops || -serverprops");
        Debug.output("     -file requires a complete path to a ImageMaster properties file.");
        Debug.output("     -url requires an URL to a ImageMaster properties file.");
        Debug.output("     -masterprops prints out an example of a ImageMaster properties file.");
        Debug.output("     -serverprops prints out an example of a ImageServer properties file.");
        Debug.output("");
        System.exit(1);
    }

    public static void printMasterProps() {
        Debug.output("");
        Debug.output("#################################################");
        Debug.output("# Properties file for the ImageMaster");
        Debug.output("# List of unique server nicknames (your choice).");
        Debug.output("servers=<server1> <server2> <server3> <etc>");
        Debug.output("");
        Debug.output("# URL of server1 properties");
        Debug.output("# If this is not included, it is assumed that ");
        Debug.output("# the ImageServer properties reside in the ");
        Debug.output("# ImageMaster properties file.");
        Debug.output("server1.properties=http://<url to server1 properties>");
        Debug.output("# Projection type of server1 image.");
        Debug.output("server1.imageProjection=mercator");
        Debug.output("# Center latitude of server1 image.");
        Debug.output("server1.imageLatitude=40f");
        Debug.output("# Center longitude of server1 image.");
        Debug.output("server1.imageLongitude=-72f");
        Debug.output("# Projection scale of server1 image.");
        Debug.output("server1.imageScale=20000000");
        Debug.output("# Pixel height of server1 image.");
        Debug.output("server1.imageHeight=640");
        Debug.output("# Pixel width of server1 image.");
        Debug.output("server1.imageWidth=480");
        Debug.output("# ARGB representation of the map background color (default is a saucy blue)");
        Debug.output("server1.imageBackgroundColor=ffffffff");
        Debug.output("# Complete path to server1 image output.");
        Debug.output("server1.outputName=<path to output file>");
        Debug.output("");
        Debug.output("# Repeat for each server listed in the servers property");
        Debug.output("#################################################");
        Debug.output("");
    }

    public static void printServerProps() {
        Debug.output("");
        Debug.output("#################################################");
        Debug.output("# Properties for ImageServer");
        Debug.output("# List of unique layer nicknames to use for the image (your choice).");
        Debug.output("# server1 is the name specified in the ImageMaster properties.");
        Debug.output("server1.imageServer.layers=<layer1> <layer2> <etc>");
        Debug.output("# Classname of object to determine image format.");
        Debug.output("server1.imageServer.formatter=<classname of ImageFormatter>");
        Debug.output("");
        Debug.output("layer1.class=<com.bbn.openmap.layer.ShapeLayer");
        Debug.output("layer1.prettyName=ShapeLayer");
        Debug.output("# Continue with layer specific properties.  See each layer's documentation or source for more details.");
        Debug.output("");
        Debug.output("# Continue for each layer listed in the imageServer.layers property.");
        Debug.output("#################################################");
        Debug.output("");
    }

    public class ImageMasterHelper
    implements ImageReceiver {
        public ImageServer iServer;
        public String outputFileName;
        public boolean complete = false;
        public ImageMaster iMaster;
        public Proj proj;
        public String outputLogFileName;
        public String errorLogFileName;
        public int scaleToWidth = -1;
        public int scaleToHeight = -1;

        public ImageMasterHelper(String prefix, Properties props, ImageMaster master) {
            Properties uniqueProps;
            String propPrefix = prefix + ".";
            float scale = PropUtils.floatFromProperties(props, propPrefix + ImageMaster.ImageScaleProperty, 2.0E7f);
            int height = PropUtils.intFromProperties(props, propPrefix + ImageMaster.ImageHeightProperty, 480);
            int width = PropUtils.intFromProperties(props, propPrefix + ImageMaster.ImageWidthProperty, 640);
            float longitude = PropUtils.floatFromProperties(props, propPrefix + ImageMaster.ImageLongitudeProperty, -71.0f);
            float latitude = PropUtils.floatFromProperties(props, propPrefix + ImageMaster.ImageLatitudeProperty, 42.0f);
            String projType = props.getProperty(propPrefix + ImageMaster.ImageProjectionProperty);
            String uniquePropsURL = props.getProperty(propPrefix + ImageMaster.ServerPropertiesProperty);
            this.scaleToWidth = PropUtils.intFromProperties(props, propPrefix + ImageMaster.ScaleToWidthProperty, -1);
            this.scaleToHeight = PropUtils.intFromProperties(props, propPrefix + ImageMaster.ScaleToHeightProperty, -1);
            this.outputFileName = props.getProperty(propPrefix + ImageMaster.ImageNameProperty);
            this.outputLogFileName = props.getProperty(propPrefix + ImageMaster.OutputLogFileProperty);
            this.errorLogFileName = props.getProperty(propPrefix + ImageMaster.ErrorLogFileProperty);
            if (this.outputLogFileName != null && this.errorLogFileName != null) {
                if (this.outputLogFileName.equalsIgnoreCase(this.errorLogFileName)) {
                    Debug.setLog(new File(this.outputFileName), true);
                } else {
                    Debug.directErrors(this.errorLogFileName, true, true);
                    Debug.directOutput(new File(this.outputLogFileName), true);
                }
            } else {
                if (this.errorLogFileName != null) {
                    Debug.directErrors(this.errorLogFileName, true, true);
                }
                if (this.outputLogFileName != null) {
                    Debug.directOutput(new File(this.outputLogFileName), true);
                }
            }
            if (projType == null) {
                projType = "mercator";
            }
            this.proj = (Proj)ProjectionFactory.makeProjection(ProjectionFactory.getProjType(projType), latitude, longitude, scale, width, height);
            Color background = (Color)PropUtils.parseColorFromProperties(props, propPrefix + ImageMaster.ImageBackgroundColorProperty, MapBean.DEFAULT_BACKGROUND_COLOR);
            this.iMaster = master;
            if (uniquePropsURL != null) {
                uniqueProps = new Properties();
                try {
                    ImageMaster.this.loadProperties(uniqueProps, new URL(uniquePropsURL));
                }
                catch (MalformedURLException mue) {
                    Debug.error("ImageMaster: Malformed URL for server properties: " + uniquePropsURL);
                    uniqueProps = null;
                }
            } else {
                uniqueProps = props;
            }
            if (uniqueProps != null && this.outputFileName != null) {
                this.iServer = new ImageServer(propPrefix, uniqueProps, ImageMaster.this.instantiatedLayers);
                this.iServer.setBackground(background);
            }
        }

        public void create() {
            this.receiveImageData(this.iServer.createImage(this.proj, this.scaleToWidth, this.scaleToHeight));
        }

        public void receiveImageData(byte[] imageBytes) {
            this.writeDataFile(this.outputFileName, imageBytes);
            this.complete = true;
            this.iMaster.doNext();
        }

        public void writeDataFile(String fileName, byte[] imageData) {
            try {
                Debug.message("imagemaster", "ImageMasterHelper: Writing image file " + fileName);
                FileOutputStream binFile = new FileOutputStream(fileName);
                binFile.write(imageData);
                binFile.close();
            }
            catch (IOException ioe) {
                Debug.error("ImageMasterHelper: Error writing image file " + fileName);
            }
        }
    }
}

