/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.Environment;
import com.bbn.openmap.image.ImageReceiver;
import com.bbn.openmap.image.ImageServer;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class GeneratorTester
implements ImageReceiver {
    ImageServer server;
    String propertiesURLString = null;
    String fileName = null;
    Properties props = System.getProperties();

    public GeneratorTester(String[] args) {
        Debug.init(this.props);
        this.parseArgs(args);
        try {
            URL propsURL = new URL(this.propertiesURLString);
            Environment.init(this.props);
            this.loadProperties(propsURL, this.props);
        }
        catch (MalformedURLException mul) {
            System.out.println("GeneratorTester: Malformed URL");
            return;
        }
        Projection proj = ProjectionFactory.makeProjection(42, 42.0f, -72.0f, 5000000.0f, 500, 500);
        this.server = new ImageServer(this.props);
    }

    public void receiveImageData(byte[] bytes) {
        try {
            File f = new File(this.fileName);
            FileOutputStream writef = new FileOutputStream(f);
            ((OutputStream)writef).write(bytes);
            ((OutputStream)writef).close();
            System.out.println(this.fileName + " JPEG written.");
        }
        catch (IOException ioe) {
            System.out.println("No JPEG written due to IOExeception.");
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        GeneratorTester generatorTester = new GeneratorTester(args);
    }

    public boolean loadProperties(URL url, Properties props) {
        try {
            InputStream propsIn = url.openStream();
            props.load(propsIn);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-url")) {
                this.propertiesURLString = args[++i];
            } else if (args[i].equalsIgnoreCase("-outputFile")) {
                this.fileName = args[++i];
            } else if (args[i].equalsIgnoreCase("-h")) {
                this.printHelp();
            }
            ++i;
        }
        if (this.propertiesURLString == null || this.fileName == null) {
            this.printHelp();
        }
    }

    public void printHelp() {
        System.err.println("usage: java GeneratorTester -url <URL for properties file> -outputFile <path to output file>");
        System.exit(1);
    }
}

