/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.gui.menu.MapHandlerMenuItem;
import com.bbn.openmap.gui.menu.SaveAsImageFileChooser;
import com.bbn.openmap.image.AbstractImageFormatter;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;

public class SaveAsImageMenuItem
extends MapHandlerMenuItem
implements ActionListener {
    AbstractImageFormatter formatter = null;

    public SaveAsImageMenuItem(String display, AbstractImageFormatter in_formatter) {
        super(display);
        this.formatter = in_formatter;
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        block6: {
            Debug.message("saveimage", "SaveAsImageMenuItem: actionPerformed");
            if (this.mapHandler == null) {
                Debug.output("SaveAsImageMenuItem: mapHandler = null, returning");
                return;
            }
            MapBean mb = (MapBean)this.mapHandler.get("com.bbn.openmap.MapBean");
            if (mb == null) break block6;
            Debug.message("saveimage", "MapBean found, creating image");
            try {
                while (true) {
                    SaveAsImageFileChooser chooser;
                    int returnVal;
                    if ((returnVal = (chooser = new SaveAsImageFileChooser(mb.getWidth(), mb.getHeight())).showSaveDialog(this.getParent())) == 0) {
                        String filename = chooser.getSelectedFile().getAbsolutePath();
                        if (this.formatter == null) break;
                        if ((filename = this.checkFileName(filename, this.formatter.getFormatLabel().toLowerCase())) == null) continue;
                        int imageHeight = chooser.getImageHeight();
                        int imageWidth = chooser.getImageWidth();
                        byte[] imageBytes = this.formatter.getImageFromMapBean(mb, imageWidth, imageHeight);
                        FileOutputStream binFile = new FileOutputStream(filename);
                        binFile.write(imageBytes);
                        binFile.close();
                        if (Debug.debugging("saveimage")) {
                            Projection proj = mb.getProjection();
                            Debug.output("Created image at " + filename + "where projection covers " + proj.getUpperLeft() + " to " + proj.getLowerRight());
                        }
                        break;
                    }
                    if (returnVal == 1) break;
                }
            }
            catch (IOException e) {
                Debug.error("SaveAsImageMenuItem: " + e);
            }
        }
    }

    protected String checkFileName(String filePath, String imageSuffix) {
        int choice;
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator));
        String newFilePath = fileName.indexOf(46) == -1 ? filePath + "." + imageSuffix : filePath;
        File file = new File(newFilePath);
        if (file.exists() && (choice = JOptionPane.showConfirmDialog(null, "The file " + newFilePath + " exists, replace?", "Confirm File Replacement", 0)) != 0) {
            newFilePath = null;
        }
        return newFilePath;
    }
}

