/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.util.PaletteHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SaveAsImageFileChooser
extends JFileChooser {
    DimensionQueryPanel dqp = new DimensionQueryPanel();

    public SaveAsImageFileChooser(int width, int height) {
        this.dqp.setImageHeight(height);
        this.dqp.setImageWidth(width);
        JPanel imageSizePanel = PaletteHelper.createPaletteJPanel(" Set Image Size ");
        imageSizePanel.setLayout(new BorderLayout());
        imageSizePanel.add((Component)this.dqp, "Center");
        this.setAccessory(imageSizePanel);
    }

    public void setImageWidth(int w) {
        this.dqp.setImageWidth(w);
    }

    public int getImageWidth() {
        return this.dqp.getImageWidth();
    }

    public void setImageHeight(int h) {
        this.dqp.setImageHeight(h);
    }

    public int getImageHeight() {
        return this.dqp.getImageHeight();
    }

    public class DimensionQueryPanel
    extends JPanel {
        private JTextField hfield;
        private JTextField vfield;
        private JLabel htext = new JLabel("Width: ");
        private JLabel vtext;
        private JLabel ptext1;
        private JLabel ptext2;

        public DimensionQueryPanel() {
            this(0, 0);
        }

        public DimensionQueryPanel(int width, int height) {
            this.htext.setHorizontalAlignment(4);
            this.vtext = new JLabel("Height: ");
            this.vtext.setHorizontalAlignment(4);
            this.hfield = new JTextField(Integer.toString(width), 5);
            this.vfield = new JTextField(Integer.toString(height), 5);
            this.ptext1 = new JLabel(" pixels");
            this.ptext2 = new JLabel(" pixels");
            this.layoutPanel();
        }

        public void setImageWidth(int width) {
            this.hfield.setText(Integer.toString(width));
        }

        public int getImageWidth() {
            return Integer.parseInt(this.hfield.getText());
        }

        public void setImageHeight(int height) {
            this.vfield.setText(Integer.toString(height));
        }

        public int getImageHeight() {
            return Integer.parseInt(this.vfield.getText());
        }

        public void layoutPanel() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gb);
            c.insets = new Insets(3, 3, 3, 3);
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 0;
            c.weightx = 0.0;
            c.anchor = 13;
            gb.setConstraints(this.htext, c);
            this.add(this.htext);
            c.gridx = 1;
            c.fill = 2;
            c.weightx = 1.0;
            c.anchor = 17;
            gb.setConstraints(this.hfield, c);
            this.add(this.hfield);
            c.gridx = 2;
            c.fill = 0;
            c.weightx = 0.0;
            gb.setConstraints(this.ptext1, c);
            this.add(this.ptext1);
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 0;
            c.weightx = 0.0;
            c.anchor = 13;
            gb.setConstraints(this.vtext, c);
            this.add(this.vtext);
            c.gridx = 1;
            c.fill = 2;
            c.weightx = 1.0;
            c.anchor = 17;
            gb.setConstraints(this.vfield, c);
            this.add(this.vfield);
            c.gridx = 2;
            c.fill = 0;
            c.weightx = 0.0;
            gb.setConstraints(this.ptext2, c);
            this.add(this.ptext2);
        }
    }
}

