/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.gui.CoordPanel;
import com.bbn.openmap.proj.coords.UTMPoint;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class UTMCoordPanel
extends CoordPanel
implements Serializable {
    protected transient JTextField zoneLetter;
    protected transient JTextField zoneNumber;
    protected transient JTextField easting;
    protected transient JTextField northing;

    public UTMCoordPanel() {
    }

    public UTMCoordPanel(CenterSupport support) {
        super(support);
    }

    protected void makeWidgets() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        this.setBorder(new TitledBorder(new EtchedBorder(), "Zone Number|Zone Letter|Easting|Northing"));
        JLabel utmLabel = new JLabel("UTM: ");
        c.gridx = 0;
        gridbag.setConstraints(utmLabel, c);
        this.add(utmLabel);
        c.gridx = -1;
        this.zoneNumber = new JTextField(3);
        gridbag.setConstraints(this.zoneNumber, c);
        this.add(this.zoneNumber);
        this.zoneLetter = new JTextField(2);
        gridbag.setConstraints(this.zoneLetter, c);
        this.add(this.zoneLetter);
        this.easting = new JTextField(8);
        gridbag.setConstraints(this.easting, c);
        this.add(this.easting);
        this.northing = new JTextField(8);
        gridbag.setConstraints(this.northing, c);
        this.add(this.northing);
    }

    public LatLonPoint getLatLon() {
        try {
            int iZoneNumber = Float.valueOf(this.zoneNumber.getText()).intValue();
            char cZoneLetter = this.zoneLetter.getText().charAt(0);
            float minEasting = this.easting.getText().equals("") ? 0.0f : Float.valueOf(this.easting.getText()).floatValue();
            this.easting.setText(Float.toString(Math.abs(minEasting)));
            float minNorthing = this.northing.getText().equals("") ? 0.0f : Float.valueOf(this.northing.getText()).floatValue();
            this.northing.setText(Float.toString(Math.abs(minNorthing)));
            UTMPoint utm = new UTMPoint(minNorthing, minEasting, iZoneNumber, cZoneLetter);
            return utm.toLatLonPoint();
        }
        catch (NumberFormatException except) {
            this.clearTextBoxes();
            return null;
        }
    }

    public void setLatLon(LatLonPoint llpoint) {
        if (llpoint == null) {
            this.clearTextBoxes();
            return;
        }
        UTMPoint utm = new UTMPoint(llpoint);
        this.northing.setText(Float.toString(utm.northing));
        this.easting.setText(Float.toString(utm.easting));
        this.zoneNumber.setText(Integer.toString(utm.zone_number));
        this.zoneLetter.setText(utm.zone_letter + "");
    }

    protected void clearTextBoxes() {
        this.northing.setText("");
        this.easting.setText("");
        this.zoneLetter.setText("");
        this.zoneNumber.setText("");
    }
}

