/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class ToolPanel
extends JToolBar
implements BeanContextChild,
BeanContextMembershipListener,
MapPanelChild,
PropertyConsumer,
ComponentListener {
    protected Hashtable items = new Hashtable();
    protected boolean autoSpace = false;
    private BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport(this);
    protected String propertyPrefix = null;
    public static final String ComponentsProperty = "components";
    public static final String AvoidComponentsProperty = "avoid";
    protected List componentList = null;
    protected List avoidList = null;
    protected GridBagLayout gridbag = new GridBagLayout();
    protected GridBagConstraints c = new GridBagConstraints();
    protected JLabel filler = null;
    protected boolean[] usedIndexes;
    public int MAX_INDEXES = 101;
    protected String preferredLocation = "North";
    static /* synthetic */ Class class$java$awt$BorderLayout;

    public ToolPanel() {
        this.setLayout(this.gridbag);
        this.setFloatable(false);
        this.setVisible(false);
    }

    public void add(String key, Tool item) {
        this.add(key, item, -1);
    }

    protected int getNextAvailableIndex() {
        return this.getNextAvailableIndex(0);
    }

    protected int getNextAvailableIndex(int startAt) {
        if (this.usedIndexes == null) {
            this.usedIndexes = new boolean[this.MAX_INDEXES];
        }
        if (startAt < 0) {
            startAt = 0;
        }
        if (startAt >= this.MAX_INDEXES) {
            startAt = this.MAX_INDEXES - 1;
        }
        int i = startAt;
        while (i < this.MAX_INDEXES && this.usedIndexes[i]) {
            ++i;
        }
        this.usedIndexes[i] = true;
        return i;
    }

    public void add(String key, Tool item, int index) {
        Container face = item.getFace();
        if (face != null) {
            face.addComponentListener(this);
            this.items.put(key.intern(), item);
            if (this.autoSpace) {
                index *= 2;
            }
            this.c.gridy = 0;
            this.c.weightx = 0.0;
            this.c.anchor = 17;
            this.c.gridx = this.getNextAvailableIndex(index);
            this.gridbag.setConstraints(face, this.c);
            this.add(face);
            if (this.filler == null) {
                this.c.gridx = this.getNextAvailableIndex(this.MAX_INDEXES);
                this.c.anchor = 13;
                this.c.weightx = 1.0;
                this.filler = new JLabel("");
                this.gridbag.setConstraints(this.filler, this.c);
                this.add(this.filler);
            }
            if (this.autoSpace) {
                this.addSpace();
            }
        }
        this.setVisibility();
    }

    public void add(Tool item) {
        this.add(item, -1);
    }

    public void add(Tool item, int index) {
        block3: {
            try {
                this.add(item.getKey(), item, index);
            }
            catch (NullPointerException npe) {
                if (item != null) {
                    Debug.error("ToolPanel.add(): no name for " + item.getClass().getName());
                    npe.printStackTrace();
                    break block3;
                }
                Debug.error("ToolPanel.add(): no name for null tool.");
            }
        }
    }

    public Tool get(String key) {
        return (Tool)this.items.get(key.intern());
    }

    public void remove(String key) {
        Tool tool = (Tool)this.items.remove(key.intern());
        if (tool != null) {
            this.remove(tool.getFace());
            tool.getFace().removeComponentListener(this);
        }
    }

    protected void addSpace() {
        this.add(new JLabel(" "));
    }

    public void setAutoSpace(boolean set) {
        this.autoSpace = set;
    }

    public void setPreferredLocation(String value) {
        this.preferredLocation = value;
    }

    public String getPreferredLocation() {
        return this.preferredLocation;
    }

    public boolean isAutoSpace() {
        return this.autoSpace;
    }

    public void setComponentList(List list) {
        this.componentList = list;
    }

    public List getComponentList() {
        return this.componentList;
    }

    public void setAvoidList(List list) {
        this.avoidList = list;
    }

    public List getAvoidList() {
        return this.avoidList;
    }

    public void findAndInit(Iterator it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    protected int keyOnList(String key, List list) {
        int ret = -1;
        int index = 0;
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String listKey = (String)it.next();
                if (listKey.equalsIgnoreCase(key)) {
                    ret = index;
                    break;
                }
                ++index;
            }
        }
        return ret;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof Tool) {
            String key = ((Tool)someObj).getKey();
            List list = this.getComponentList();
            if (list != null) {
                int index = this.keyOnList(key, list);
                if (index >= 0) {
                    if (Debug.debugging("basic")) {
                        Debug.output("ToolPanel: found a tool Object " + key + " for placement at " + index);
                    }
                    this.add((Tool)someObj, index);
                }
            } else {
                int index = this.keyOnList(key, this.getAvoidList());
                if (index < 0) {
                    Debug.message("basic", "ToolPanel: found a tool Object");
                    this.add((Tool)someObj);
                }
            }
        }
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            Object someObj = it.next();
            if (!(someObj instanceof Tool)) continue;
            Debug.message("toolpanel", "ToolPanel removing tool Object");
            this.remove(((Tool)someObj).getKey());
        }
    }

    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.beanContextChildSupport.addPropertyChangeListener(propertyName, in_pcl);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.beanContextChildSupport.removePropertyChangeListener(propertyName, in_pcl);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        String preferredLocationString;
        String avoidComponentsString;
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String componentsString = props.getProperty(prefix + ComponentsProperty);
        if (componentsString != null) {
            this.setComponentList(PropUtils.parseSpacedMarkers(componentsString));
        }
        if ((avoidComponentsString = props.getProperty(prefix + AvoidComponentsProperty)) != null) {
            this.setAvoidList(PropUtils.parseSpacedMarkers(avoidComponentsString));
        }
        if ((preferredLocationString = props.getProperty(prefix + "preferredLocation")) != null) {
            try {
                preferredLocationString = (String)(class$java$awt$BorderLayout == null ? (class$java$awt$BorderLayout = ToolPanel.class$("java.awt.BorderLayout")) : class$java$awt$BorderLayout).getField(preferredLocationString).get(null);
            }
            catch (NoSuchFieldException nsfe) {
                preferredLocationString = null;
            }
            catch (IllegalAccessException iae) {
                preferredLocationString = null;
            }
            if (preferredLocationString != null) {
                this.setPreferredLocation(preferredLocationString);
            }
        }
    }

    protected StringBuffer rebuildListProperty(List aList) {
        StringBuffer list = null;
        if (aList != null) {
            list = new StringBuffer();
            Iterator it = aList.iterator();
            while (it.hasNext()) {
                list.append((String)it.next() + " ");
            }
        }
        return list;
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        StringBuffer listProp = this.rebuildListProperty(this.getComponentList());
        if (listProp != null) {
            props.put(prefix + ComponentsProperty, listProp.toString());
        }
        if ((listProp = this.rebuildListProperty(this.getAvoidList())) != null) {
            props.put(prefix + AvoidComponentsProperty, listProp.toString());
        }
        props.put(prefix + "preferredLocation", this.getPreferredLocation());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(ComponentsProperty, "List of Names of Tools to Add");
        return props;
    }

    protected void setVisibility() {
        this.setVisible(this.areComponentsVisible());
    }

    public boolean areComponentsVisible() {
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            Component comp = (Component)enumeration.nextElement();
            if (comp == this.filler || !comp.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void componentHidden(ComponentEvent ce) {
        this.setVisibility();
    }

    public void componentMoved(ComponentEvent ce) {
    }

    public void componentResized(ComponentEvent ce) {
    }

    public void componentShown(ComponentEvent ce) {
        this.setVisibility();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

