/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.examples.hello;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.MultipleSoloMapComponentException;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.ToolPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

public class HelloWorld
extends JFrame {
    public static final String layersProperty = "hello.layers";
    public static String helloResources = "HelloWorld.properties";
    public static String message = "Hello, World!";
    static /* synthetic */ Class class$com$bbn$openmap$examples$hello$HelloWorld;

    public HelloWorld() throws MultipleSoloMapComponentException {
        this(new Properties());
    }

    public HelloWorld(Properties props) throws MultipleSoloMapComponentException {
        super("HelloWorld Example");
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                HelloWorld.this.quit();
            }
        });
        System.out.println("Creating MapHandler");
        MapHandler mapHandler = new MapHandler();
        System.out.println("Creating MapBean");
        MapBean map = new MapBean();
        map.setCenter(new LatLonPoint(43.0f, -95.0f));
        map.setScale(8.0E7f);
        mapHandler.add(map);
        this.getContentPane().add((Component)map, "Center");
        System.out.println("Adding MouseEvent support...");
        mapHandler.add(new MouseDelegator());
        mapHandler.add(new NavMouseMode());
        System.out.println("Creating ToolPanel...");
        mapHandler.add(new OMToolSet());
        ToolPanel toolPanel = new ToolPanel();
        mapHandler.add(toolPanel);
        this.getContentPane().add((Component)toolPanel, "North");
        System.out.println("Creating Layers...");
        Layer[] layers = this.getLayers(props);
        LayerHandler layerHandler = new LayerHandler();
        int i = 0;
        while (i < layers.length) {
            layers[i].setVisible(true);
            layerHandler.addLayer(layers[i]);
            ++i;
        }
        mapHandler.add(layerHandler);
        System.out.println("Done creating...");
    }

    protected void quit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        Properties helloProps = new Properties();
        HelloWorld.loadResource(helloResources, helloProps);
        try {
            HelloWorld hello = new HelloWorld(helloProps);
            hello.setSize(700, 500);
            hello.setVisible(true);
        }
        catch (MultipleSoloMapComponentException msmce) {}
    }

    private static void loadResource(String resources, Properties props) {
        InputStream in = (class$com$bbn$openmap$examples$hello$HelloWorld == null ? (class$com$bbn$openmap$examples$hello$HelloWorld = HelloWorld.class$("com.bbn.openmap.examples.hello.HelloWorld")) : class$com$bbn$openmap$examples$hello$HelloWorld).getResourceAsStream(resources);
        if (props == null) {
            System.err.println("Unable to locate resources: " + resources);
            System.err.println("Using default resources.");
        } else {
            try {
                props.load(in);
            }
            catch (IOException e) {
                System.err.println("Caught IOException loading resources: " + resources);
                System.err.println("Using default resources.");
            }
        }
    }

    private Layer[] getLayers(Properties p) {
        String layersValue = p.getProperty(layersProperty);
        if (layersValue == null) {
            System.err.println("No property \"hello.layers\" found in application properties.");
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(layersValue, " ");
        Vector<String> layerNames = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            layerNames.addElement(tokens.nextToken());
        }
        int nLayerNames = layerNames.size();
        Vector<Layer> layers = new Vector<Layer>(nLayerNames);
        int i = 0;
        while (i < nLayerNames) {
            String layerName = (String)layerNames.elementAt(i);
            String classProperty = layerName + ".class";
            String className = p.getProperty(classProperty);
            if (className == null) {
                System.err.println("Failed to locate property \"" + classProperty + "\"");
                System.err.println("Skipping layer \"" + layerName + "\"");
            } else {
                try {
                    Object obj = Beans.instantiate(null, className);
                    if (obj instanceof Layer) {
                        Layer l = (Layer)obj;
                        l.setProperties(layerName, p);
                        layers.addElement(l);
                    }
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Layer class not found: \"" + className + "\"");
                    System.err.println("Skipping layer \"" + layerName + "\"");
                }
                catch (IOException e) {
                    System.err.println("IO Exception instantiating class \"" + className + "\"");
                    System.err.println("Skipping layer \"" + layerName + "\"");
                }
            }
            ++i;
        }
        int nLayers = layers.size();
        if (nLayers == 0) {
            return null;
        }
        Object[] value = new Layer[nLayers];
        layers.copyInto(value);
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

