/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Properties;
import java.util.Vector;

public class DistanceMouseMode
extends CoordMouseMode {
    public static final transient String modeID = "Distance".intern();
    public static final String UnitProperty = "units";
    public static final String ShowCircleProperty = "showCircle";
    public static final String ShowAngleProperty = "showAngle";
    public static final String RepaintToCleanProperty = "repaintToClean";
    public LatLonPoint rPoint1;
    public LatLonPoint rPoint2;
    public boolean mousePressed = false;
    public Vector segments = new Vector();
    public double distance = 0.0;
    public double totalDistance = 0.0;
    public static int lineType = 3;
    private boolean displayCircle = true;
    private Length unit = Length.MILE;
    boolean showAngle = true;
    boolean repaintToClean = false;
    MapBean theMap;

    public DistanceMouseMode() {
        this(true);
    }

    public DistanceMouseMode(boolean consumeEvents) {
        super(modeID, consumeEvents);
    }

    public DistanceMouseMode(String name, boolean consumeEvents) {
        super(name, consumeEvents);
    }

    public DistanceMouseMode(boolean consumeEvents, InformationDelegator id, Length units) {
        super(modeID, consumeEvents);
        this.infoDelegator = id;
        this.unit = units;
    }

    public DistanceMouseMode(boolean consumeEvents, InformationDelegator id, Length units, int lType) {
        super(modeID, consumeEvents);
        this.infoDelegator = id;
        this.unit = units;
        lineType = lType;
    }

    public DistanceMouseMode(boolean consumeEvents, InformationDelegator id) {
        super(modeID, consumeEvents);
        this.infoDelegator = id;
    }

    public DistanceMouseMode(String name, boolean consumeEvents, InformationDelegator id) {
        super(name, consumeEvents);
        this.infoDelegator = id;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof MapBean && e.getClickCount() >= 2) {
            this.mousePressed = false;
            this.segments.addElement(this.rPoint2);
            if (!this.repaintToClean) {
                this.eraseLines();
                this.eraseCircle();
            } else {
                ((MapBean)e.getSource()).repaint();
            }
            this.cleanUp();
        }
    }

    public void mousePressed(MouseEvent e) {
        e.getComponent().requestFocus();
        if (e.getSource() instanceof MapBean) {
            this.mousePressed = true;
            this.eraseCircle();
            this.rPoint1 = this.theMap.getProjection().inverse(e.getPoint());
            this.rPoint2 = null;
            this.segments.addElement(this.rPoint1);
            this.totalDistance += this.distance;
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getSource() instanceof MapBean) {
            if (this.mousePressed) {
                this.theMap = (MapBean)e.getSource();
                this.paintRubberband(this.rPoint1, this.rPoint2);
                this.rPoint2 = this.theMap.getProjection().inverse(e.getPoint());
                this.paintRubberband(this.rPoint1, this.rPoint2);
                if (this.infoDelegator != null) {
                    Debug.message("mousemodedetail", "DistanceMouseMode: firing mouse location");
                    float lat1 = this.rPoint1.getLatitude();
                    float long1 = this.rPoint1.getLongitude();
                    float lat2 = this.rPoint2.getLatitude();
                    float long2 = this.rPoint2.getLongitude();
                    this.distance = GreatCircle.spherical_distance(ProjMath.degToRad(lat1), ProjMath.degToRad(long1), ProjMath.degToRad(lat2), ProjMath.degToRad(long2));
                    float azimuth = this.getSphericalAzimuth(lat1, long1, lat2, long2);
                    double tmpDistance = this.totalDistance + this.distance;
                    String infoLine = this.createDistanceInformationLine(this.rPoint2, tmpDistance, azimuth);
                    InfoDisplayEvent info = new InfoDisplayEvent(this, infoLine, 1);
                    this.infoDelegator.requestInfoLine(info);
                }
            } else {
                this.fireMouseLocation(e);
            }
        }
    }

    protected String createDistanceInformationLine(LatLonPoint llp, double distance, double azimuth) {
        String unitInfo = null;
        unitInfo = this.unit == null ? this.df.format(Length.NM.fromRadians((float)distance)) + Length.NM.getAbbr() + ",  " + this.df.format(Length.KM.fromRadians((float)distance)) + Length.KM.getAbbr() + ",  " + this.df.format(Length.MILE.fromRadians((float)distance)) + Length.MILE.getAbbr() + "  " : this.unit.fromRadians((float)distance) + " " + this.unit.getAbbr();
        String infoLine = "Lat, Lon (" + this.df.format(llp.getLatitude()) + ", " + this.df.format(llp.getLongitude()) + "), distance (";
        infoLine = infoLine + unitInfo + ")";
        if (this.showAngle) {
            infoLine = infoLine + ", angle (" + this.df.format(azimuth) + ")";
        }
        return infoLine;
    }

    public void mouseEntered(MouseEvent e) {
        if (e.getSource() instanceof MapBean) {
            this.theMap = (MapBean)e.getSource();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() instanceof MapBean) {
            this.paintRubberband(this.rPoint1, this.rPoint2);
            this.rPoint2 = null;
        }
    }

    public void paintLine(LatLonPoint pt1, LatLonPoint pt2) {
        if (this.theMap != null) {
            this.paintLine(pt1, pt2, this.theMap.getGraphics());
        }
    }

    public void paintLine(LatLonPoint pt1, LatLonPoint pt2, Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setXORMode(Color.lightGray);
        g.setColor(Color.darkGray);
        if (pt1 != null && pt2 != null) {
            OMLine cLine = new OMLine(pt1.getLatitude(), pt1.getLongitude(), pt2.getLatitude(), pt2.getLongitude(), lineType);
            Projection proj = this.theMap.getProjection();
            cLine.generate(proj);
            cLine.render(g);
        }
    }

    public void paintCircle(LatLonPoint pt1, LatLonPoint pt2) {
        if (this.theMap != null) {
            this.paintCircle(pt1, pt2, this.theMap.getGraphics());
        }
    }

    public void paintCircle(LatLonPoint pt1, LatLonPoint pt2, Graphics graphics) {
        if (this.displayCircle) {
            Graphics2D g = (Graphics2D)graphics;
            g.setXORMode(Color.lightGray);
            g.setColor(Color.darkGray);
            if (pt1 != null && pt2 != null) {
                float radphi1 = ProjMath.degToRad(pt1.getLatitude());
                float radlambda0 = ProjMath.degToRad(pt1.getLongitude());
                float radphi = ProjMath.degToRad(pt2.getLatitude());
                float radlambda = ProjMath.degToRad(pt2.getLongitude());
                double dRad = GreatCircle.spherical_distance(radphi1, radlambda0, radphi, radlambda);
                float rad = (float)ProjMath.radToDeg(dRad);
                OMCircle circle = new OMCircle(pt1.getLatitude(), pt1.getLongitude(), rad);
                Projection proj = this.theMap.getProjection();
                circle.generate(proj);
                circle.render(g);
            }
        }
    }

    public void paintRubberband(LatLonPoint pt1, LatLonPoint pt2) {
        if (this.theMap != null) {
            this.paintRubberband(pt1, pt2, this.theMap.getGraphics());
        }
    }

    public void paintRubberband(LatLonPoint pt1, LatLonPoint pt2, Graphics g) {
        this.paintLine(pt1, pt2, g);
        this.paintCircle(pt1, pt2, g);
    }

    public void eraseLines() {
        int i = 0;
        while (i < this.segments.size() - 1) {
            this.paintLine((LatLonPoint)this.segments.elementAt(i), (LatLonPoint)this.segments.elementAt(i + 1));
            ++i;
        }
    }

    public void eraseCircle() {
        this.paintCircle(this.rPoint1, this.rPoint2);
    }

    public void cleanUp() {
        this.segments = new Vector();
        this.totalDistance = 0.0;
        this.distance = 0.0;
    }

    public double getGreatCircleDist(float phi1, float lambda0, float phi, float lambda, int units) {
        double dist = 0.0;
        float radphi1 = ProjMath.degToRad(phi1);
        float radlambda0 = ProjMath.degToRad(lambda0);
        float radphi = ProjMath.degToRad(phi);
        float radlambda = ProjMath.degToRad(lambda);
        double distRad = GreatCircle.spherical_distance(radphi1, radlambda0, radphi, radlambda);
        if (units == 0) {
            dist = distRad * 21600.0 / 6.2831854820251465;
        }
        if (units == 1) {
            dist = distRad * 40075.015625 / 6.2831854820251465;
        }
        if (units == 2) {
            dist = distRad * 24901.4609375 / 6.2831854820251465;
        }
        return dist;
    }

    public float getSphericalAzimuth(float phi1, float lambda0, float phi, float lambda) {
        float radphi1 = ProjMath.degToRad(phi1);
        float radlambda0 = ProjMath.degToRad(lambda0);
        float radphi = ProjMath.degToRad(phi);
        float radlambda = ProjMath.degToRad(lambda);
        float az = GreatCircle.spherical_azimuth(radphi1, radlambda0, radphi, radlambda);
        return ProjMath.radToDeg(az);
    }

    public void setMapBean(MapBean aMap) {
        this.theMap = aMap;
    }

    public MapBean getMapBean() {
        return this.theMap;
    }

    public void setUnit(Length units) {
        this.unit = units;
    }

    public Length getUnit() {
        return this.unit;
    }

    public void showAzimuth(boolean onOff) {
        this.showAngle = onOff;
    }

    public boolean getShowAzimuth() {
        return this.showAngle;
    }

    public void setLineType(int lype) {
        lineType = lype;
    }

    public int getLineType() {
        return lineType;
    }

    public void showCircle(boolean onOff) {
        this.displayCircle = onOff;
    }

    public boolean getShowCircle() {
        return this.displayCircle;
    }

    public void setRepaintToClean(boolean rtc) {
        this.repaintToClean = rtc;
    }

    public boolean getRepaintToClean() {
        return this.repaintToClean;
    }

    public void setProperties(String prefix, Properties setList) {
        Length length;
        super.setProperties(prefix, setList);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String name = setList.getProperty(prefix + UnitProperty);
        if (name != null && (length = Length.get(name)) != null) {
            this.setUnit(length);
        }
        this.showCircle(LayerUtils.booleanFromProperties(setList, prefix + ShowCircleProperty, true));
        this.showAzimuth(LayerUtils.booleanFromProperties(setList, prefix + ShowAngleProperty, true));
        this.setRepaintToClean(LayerUtils.booleanFromProperties(setList, prefix + RepaintToCleanProperty, false));
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(prefix + UnitProperty, this.unit.toString());
        getList.put(prefix + ShowCircleProperty, new Boolean(this.getShowCircle()).toString());
        getList.put(prefix + ShowAngleProperty, new Boolean(this.getShowAzimuth()).toString());
        getList.put(prefix + RepaintToCleanProperty, new Boolean(this.getRepaintToClean()).toString());
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(UnitProperty, "Units to use for measurements, from Length.name possibilities.");
        list.put(ShowCircleProperty, "Flag to set whether the range circle is drawn at the end of the line (true/false).");
        list.put(ShowAngleProperty, "Flag to note the azimuth angle of the line in the information line (true/false).");
        list.put(RepaintToCleanProperty, "Flag to tell the map to repaint to clean up on a double click (true/false).");
        return list;
    }

    public void listenerPaint(Graphics g) {
        int i = 0;
        while (i < this.segments.size() - 1) {
            this.paintLine((LatLonPoint)this.segments.elementAt(i), (LatLonPoint)this.segments.elementAt(i + 1), g);
            ++i;
        }
        this.paintRubberband(this.rPoint1, this.rPoint2, g);
    }
}

