/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.Environment;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.DrawingToolRenderException;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.output.DbfOutputStream;
import com.bbn.openmap.dataAccess.shape.output.ShpOutputStream;
import com.bbn.openmap.dataAccess.shape.output.ShxOutputStream;
import com.bbn.openmap.omGraphics.BasicStrokeEditor;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRangeRings;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EsriShapeExport
implements ShapeConstants,
OMGraphicConstants {
    protected OMGraphicList graphicList = null;
    protected DbfTableModel masterDBF = null;
    protected Projection projection;
    protected String filePath;
    protected boolean DEBUG = false;
    protected ArrayList eseInterfaces = new ArrayList();
    protected boolean writeDBF = true;
    protected boolean dbfHasRenderingInfo = false;
    protected EsriPolygonList polyList = null;
    protected EsriPolylineList lineList = null;
    protected EsriPointList pointList = null;
    int badGraphics;
    protected JFrame frame = null;

    public EsriShapeExport(OMGraphicList list, Projection proj, String pathToFile) {
        this.setGraphicList(list);
        this.projection = proj;
        this.filePath = pathToFile;
        this.DEBUG = Debug.debugging("shape");
    }

    public EsriShapeExport(EsriGraphicList list, DbfTableModel dbf, String pathToFile) {
        this.setGraphicList(list);
        this.setMasterDBF(dbf);
        this.filePath = pathToFile;
        this.DEBUG = Debug.debugging("shape");
    }

    public void setGraphicList(OMGraphicList list) {
        Object obj;
        this.graphicList = list;
        if (list != null && (obj = list.getAppObject()) instanceof DbfTableModel) {
            this.masterDBF = (DbfTableModel)obj;
            Debug.message("shape", "Setting master DBF in ESE");
        }
    }

    public OMGraphicList getGraphicList() {
        return this.graphicList;
    }

    public void setProjection(Projection proj) {
        this.projection = proj;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setFilePath(String pathToFile) {
        this.filePath = pathToFile;
    }

    public String getFilePath() {
        return this.filePath;
    }

    protected EsriPolygonList getPolyList() {
        if (this.polyList == null) {
            this.polyList = new EsriPolygonList();
            this.polyList.setTable(this.getMasterDBFHeaderClone());
        }
        return this.polyList;
    }

    protected EsriPolylineList getLineList() {
        if (this.lineList == null) {
            this.lineList = new EsriPolylineList();
            this.lineList.setTable(this.getMasterDBFHeaderClone());
        }
        return this.lineList;
    }

    protected EsriPointList getPointList() {
        if (this.pointList == null) {
            this.pointList = new EsriPointList();
            this.pointList.setTable(this.getMasterDBFHeaderClone());
        }
        return this.pointList;
    }

    protected void addGraphic(EsriGraphicList egl, OMGraphic graphic, ArrayList record) {
        egl.add(graphic);
        DbfTableModel dtm = egl.getTable();
        if (dtm != null && record != null) {
            dtm.addRecord(record);
        }
    }

    protected void addPolygon(OMGraphic graphic, ArrayList record) {
        this.addGraphic(this.getPolyList(), graphic, record);
    }

    protected void addLine(OMGraphic graphic, ArrayList record) {
        this.addGraphic(this.getLineList(), graphic, record);
    }

    protected void addPoint(OMGraphic graphic, ArrayList record) {
        this.addGraphic(this.getPointList(), graphic, record);
    }

    public void setMasterDBF(DbfTableModel dbf) {
        this.masterDBF = dbf;
    }

    public DbfTableModel getMasterDBF() {
        return this.masterDBF;
    }

    public void setWriteDBF(boolean value) {
        this.writeDBF = value;
    }

    public boolean getWriteDBF() {
        return this.writeDBF;
    }

    public void setDBFHasRenderingInfo(boolean value) {
        this.dbfHasRenderingInfo = value;
    }

    public boolean getDBFHasRenderingInfo() {
        return this.dbfHasRenderingInfo;
    }

    protected DbfTableModel getMasterDBFHeaderClone() {
        if (this.masterDBF != null) {
            return this.masterDBF.headerClone();
        }
        return null;
    }

    protected ArrayList getMasterDBFRecord(int index) {
        try {
            if (this.masterDBF != null) {
                return (ArrayList)this.masterDBF.getRecord(index);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {}
        return null;
    }

    public void export() {
        OMGraphicList list = this.getGraphicList();
        if (list == null) {
            Debug.error("EsriShapeExport: no graphic list to export!");
            return;
        }
        this.export(list, null, true);
    }

    protected void export(OMGraphicList list, ArrayList record) {
        this.export(list, record, true);
    }

    protected void export(OMGraphicList list, ArrayList masterRecord, boolean writeFiles) {
        this.badGraphics = 0;
        if (list == null) {
            return;
        }
        if (list instanceof EsriGraphicList) {
            this.export((EsriGraphicList)list);
            return;
        }
        int dbfIndex = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            OMGraphic dtlGraphic = (OMGraphic)it.next();
            ArrayList record = masterRecord;
            if (record == null) {
                record = this.getMasterDBFRecord(dbfIndex++);
            }
            if (dtlGraphic instanceof OMGraphicList) {
                if (this.DEBUG) {
                    Debug.output("ESE: handling OMGraphicList");
                }
                this.export((OMGraphicList)dtlGraphic, record, false);
                continue;
            }
            if (dtlGraphic.getRenderType() != 1) {
                ++this.badGraphics;
                continue;
            }
            if (dtlGraphic instanceof OMPoly) {
                OMPoly omPoly = (OMPoly)dtlGraphic;
                if (EsriShapeExport.isPolygon(omPoly)) {
                    if (this.DEBUG) {
                        Debug.output("ESE: handling OMPoly polygon");
                    }
                    this.addPolygon(dtlGraphic, record);
                    continue;
                }
                if (this.DEBUG) {
                    Debug.output("ESE: handling OMPoly line");
                }
                this.addLine(dtlGraphic, record);
                continue;
            }
            if (dtlGraphic instanceof OMRect) {
                if (this.DEBUG) {
                    Debug.output("ESE: handling OMRect");
                }
                this.addPolygon(EsriPolygonList.convert((OMRect)dtlGraphic), record);
                continue;
            }
            if (dtlGraphic instanceof OMCircle) {
                if (this.DEBUG) {
                    Debug.output("ESE: handling OMCircle");
                }
                this.addPolygon(EsriPolygonList.convert((OMCircle)dtlGraphic, this.projection), record);
                continue;
            }
            if (dtlGraphic instanceof OMRangeRings) {
                if (this.DEBUG) {
                    Debug.output("ESE: handling OMRangeRings");
                }
                this.export(EsriPolygonList.convert((OMRangeRings)dtlGraphic, this.projection), record, false);
                continue;
            }
            if (dtlGraphic instanceof OMLine) {
                if (this.DEBUG) {
                    Debug.output("ESE: handling OMLine");
                }
                this.addLine(EsriPolylineList.convert((OMLine)dtlGraphic), record);
                continue;
            }
            if (!(dtlGraphic instanceof OMPoint)) continue;
            if (this.DEBUG) {
                Debug.output("ESE: handling OMPoint");
            }
            this.addPoint(dtlGraphic, record);
        }
        if (this.badGraphics > 0) {
            DrawingToolRenderException.notifyUserOfNonLatLonGraphics(this.badGraphics);
        }
        if (!writeFiles) {
            return;
        }
        boolean needConfirmation = false;
        if (this.filePath == null) {
            this.filePath = this.getFilePathFromUser();
            needConfirmation = true;
        }
        if (this.DEBUG) {
            Debug.output("ESE: writing files...");
        }
        boolean needTypeSuffix = false;
        if (this.polyList != null) {
            this.eseInterfaces.add(new ESEInterface(this.polyList, this.filePath, null));
            needTypeSuffix = true;
        }
        if (this.lineList != null) {
            this.eseInterfaces.add(new ESEInterface(this.lineList, this.filePath, needTypeSuffix ? "Lines" : null));
            needTypeSuffix = true;
        }
        if (this.pointList != null) {
            this.eseInterfaces.add(new ESEInterface(this.pointList, this.filePath, needTypeSuffix ? "Pts" : null));
        }
        if (needConfirmation) {
            this.showGUI();
        } else {
            this.writeFiles();
        }
    }

    protected void export(EsriGraphicList egList) {
        Object obj = egList.getAppObject();
        if (obj == null) {
            egList.setAppObject(this.getMasterDBF());
        }
        this.eseInterfaces.add(new ESEInterface(egList, this.filePath, null));
        this.writeFiles();
    }

    protected Iterator getInterfaces() {
        return this.eseInterfaces.iterator();
    }

    protected void writeFiles() {
        Iterator it = this.getInterfaces();
        while (it.hasNext()) {
            ((ESEInterface)it.next()).write();
        }
    }

    public void showGUI() {
        if (this.frame == null) {
            this.frame = new JFrame("Saving Shape Files");
            this.frame.getContentPane().add(this.getGUI(), "Center");
            this.frame.pack();
        }
        this.frame.setVisible(true);
    }

    public void hideGUI() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    public Component getGUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel interfacePanel = new JPanel();
        interfacePanel.setLayout(new GridLayout(0, 1));
        Iterator interfaces = this.getInterfaces();
        int count = 0;
        while (interfaces.hasNext()) {
            interfacePanel.add(((ESEInterface)interfaces.next()).getGUI());
            ++count;
        }
        panel.add((Component)interfacePanel, "Center");
        if (count > 1) {
            JLabel notification = new JLabel("  " + count + " Shape file sets needed:");
            panel.add((Component)notification, "North");
        }
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EsriShapeExport.this.writeFiles();
                EsriShapeExport.this.hideGUI();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EsriShapeExport.this.hideGUI();
            }
        });
        JPanel controlPanel = new JPanel();
        controlPanel.add(saveButton);
        controlPanel.add(cancelButton);
        panel.add((Component)controlPanel, "South");
        return panel;
    }

    public DbfTableModel createDefaultModel(EsriGraphicList list) {
        if (this.DEBUG) {
            Debug.output("ESE: creating DbfTableModel");
        }
        DbfTableModel _model = new DbfTableModel(7);
        _model.setLength(0, 50);
        _model.setColumnName(0, "Description");
        _model.setType(0, (byte)67);
        _model.setDecimalCount(0, (byte)0);
        _model.setLength(1, 10);
        _model.setColumnName(1, "lineColor");
        _model.setType(1, (byte)67);
        _model.setDecimalCount(1, (byte)0);
        _model.setLength(2, 10);
        _model.setColumnName(2, "fillColor");
        _model.setType(2, (byte)67);
        _model.setDecimalCount(2, (byte)0);
        _model.setLength(3, 10);
        _model.setColumnName(3, "selectColor");
        _model.setType(3, (byte)67);
        _model.setDecimalCount(3, (byte)0);
        _model.setLength(4, 4);
        _model.setColumnName(4, "lineWidth");
        _model.setType(4, (byte)78);
        _model.setDecimalCount(4, (byte)0);
        _model.setLength(5, 20);
        _model.setColumnName(5, "dashPattern");
        _model.setType(5, (byte)67);
        _model.setDecimalCount(5, (byte)0);
        _model.setLength(6, 10);
        _model.setColumnName(6, "dashPhase");
        _model.setType(6, (byte)78);
        _model.setDecimalCount(6, (byte)4);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            OMGraphic omg = (OMGraphic)iterator.next();
            ArrayList<Object> record = new ArrayList<Object>();
            Object obj = omg.getAppObject();
            if (obj instanceof String) {
                record.add(obj);
            } else {
                record.add("");
            }
            record.add(ColorFactory.getHexColorString(omg.getLineColor()));
            record.add(ColorFactory.getHexColorString(omg.getFillColor()));
            record.add(ColorFactory.getHexColorString(omg.getSelectColor()));
            BasicStroke bs = (BasicStroke)omg.getStroke();
            record.add(new Double(bs.getLineWidth()));
            String dp = BasicStrokeEditor.dashArrayToString(bs.getDashArray());
            if (dp == "No Dash Pattern") {
                dp = "";
            }
            record.add(dp);
            record.add(new Double(bs.getDashPhase()));
            _model.addRecord(record);
            if (!this.DEBUG) continue;
            Debug.output("ESE: adding record: " + record);
        }
        return _model;
    }

    public static boolean isPolygon(OMPoly omPoly) {
        int i;
        boolean isPolygon = false;
        float[] points = omPoly.getLatLonArray();
        if (points[0] == points[(i = points.length) - 2] && points[1] == points[i - 1]) {
            isPolygon = true;
        }
        if (omPoly.isPolygon()) {
            isPolygon = true;
        }
        return isPolygon;
    }

    protected void handleException(Exception e) {
        StringBuffer sb = new StringBuffer("ShapeFile Export Error:");
        sb.append("\nProblem with creating the shapefile set.");
        sb.append("\n" + e.toString());
        JOptionPane.showMessageDialog(null, sb.toString(), "ESRI Shape Export to File", 0);
        e.printStackTrace();
    }

    public String getFilePathFromUser() {
        String ret = null;
        try {
            File startingPoint = new File(Environment.get("lastchosendirectory", System.getProperty("user.home")));
            JFileChooser chooser = new JFileChooser(startingPoint);
            chooser.setDialogTitle("Select ShapeFile Set Name...");
            int state = chooser.showSaveDialog(null);
            if (state != 1 && state != -1) {
                ret = chooser.getSelectedFile().getCanonicalPath();
                Environment.set("lastchosendirectory", ret);
            } else if (this.DEBUG) {
                Debug.output("ESE: No output file chosen.");
            }
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
        return ret;
    }

    public static void main(String[] argv) {
        Debug.init();
        boolean toUpper = true;
        ArgParser ap = new ArgParser("EsriShapeExport");
        ap.add("shp", "A URL to a shape file (.shp).", 1);
        if (argv.length < 1) {
            ap.bail("", true);
        }
        ap.parse(argv);
        String[] files = ap.getArgValues("shp");
        if (files != null && files[0] != null) {
            String shp = files[0];
            String shx = null;
            String dbf = null;
            try {
                shx = shp.substring(0, shp.lastIndexOf(46) + 1) + "shx";
                dbf = shp.substring(0, shp.lastIndexOf(46) + 1) + "dbf";
                DbfTableModel model = DbfTableModel.getDbfTableModel(PropUtils.getResourceOrFileOrURL(null, dbf));
                EsriGraphicList list = EsriGraphicList.getEsriGraphicList(PropUtils.getResourceOrFileOrURL(null, shp), PropUtils.getResourceOrFileOrURL(null, shx), null, null);
                Debug.output(list.getDescription());
                EsriShapeExport ese = new EsriShapeExport(list, model, null);
                ese.export();
            }
            catch (MalformedURLException murle) {
                Debug.error("EsriShapeExport: Malformed URL Exception\n" + murle.getMessage());
            }
            catch (NullPointerException npe) {
                Debug.error("EsriShapeExport: Path to shape file isn't good enough to find .dbf file and .shx file.");
            }
            catch (Exception exception) {
                Debug.error("EsriShapeExport: Exception\n" + exception.getMessage());
                exception.printStackTrace();
            }
        } else {
            ap.bail("Need a path to a Shape file (.shp)", true);
        }
        System.exit(0);
    }

    public class ESEInterface {
        protected EsriGraphicList list;
        protected DbfTableModel model;
        protected String suffix;
        protected String filePath;
        File shpFile = null;
        File shxFile = null;
        File dbfFile = null;
        protected JTextField filePathField;

        public ESEInterface(EsriGraphicList eglist, String filePathString, String fileNameSuffix) {
            this.list = eglist;
            this.filePath = filePathString;
            this.model = eglist.getTable();
            if (this.model == null) {
                this.model = EsriShapeExport.this.createDefaultModel(this.list);
            }
            this.model.setWritable(true);
            this.suffix = fileNameSuffix == null ? "" : fileNameSuffix;
        }

        public Component getGUI() {
            String sectionTitle;
            JPanel panel = new JPanel();
            int type = this.list.getType();
            switch (type) {
                case 1: {
                    sectionTitle = "Point Shape File";
                    break;
                }
                case 3: {
                    sectionTitle = "Line Shape File";
                    break;
                }
                case 5: {
                    sectionTitle = "Polygon Shape File";
                    break;
                }
                default: {
                    sectionTitle = "Shape File";
                }
            }
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), sectionTitle));
            panel.setLayout(new GridLayout(0, 1));
            JPanel pathPanel = new JPanel();
            this.filePathField = new JTextField(20);
            this.filePathField.setText(this.filePath + this.suffix);
            JButton filePathChooserLauncher = new JButton("Change Path");
            filePathChooserLauncher.addActionListener(new ActionListener(this){
                private final /* synthetic */ ESEInterface this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.setFilePath(ESEInterface.access$000(this.this$1).getFilePathFromUser());
                }
            });
            panel.add(this.filePathField);
            JButton editDBFButton = new JButton("Edit the Attribute File...");
            editDBFButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ESEInterface this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.model.showGUI(ESEInterface.access$000(this.this$1).getFilePath() + " Attributes", 10);
                }
            });
            pathPanel.add(editDBFButton);
            pathPanel.add(filePathChooserLauncher);
            panel.add(pathPanel);
            return panel;
        }

        protected void setFilePath(String path) {
            this.filePath = path;
        }

        public void write() {
            if (this.filePathField != null) {
                this.filePath = this.filePathField.getText();
            }
            if (this.filePath == null) {
                this.filePath = EsriShapeExport.this.getFilePathFromUser();
                if (this.filePath == null) {
                    return;
                }
            }
            this.shpFile = new File(this.filePath + ".shp");
            this.shxFile = new File(this.filePath + ".shx");
            this.dbfFile = new File(this.filePath + ".dbf");
            try {
                if (EsriShapeExport.this.DEBUG) {
                    Debug.output("ESE writing: " + this.list.size() + " elements");
                }
                ShpOutputStream pos = new ShpOutputStream(new FileOutputStream(this.shpFile));
                int[][] indexData = pos.writeGeometry(this.list);
                ShxOutputStream xos = new ShxOutputStream(new FileOutputStream(this.shxFile));
                xos.writeIndex(indexData, this.list.getType());
                if (EsriShapeExport.this.getWriteDBF()) {
                    DbfOutputStream dos = new DbfOutputStream(new FileOutputStream(this.dbfFile));
                    dos.writeModel(this.model);
                }
            }
            catch (Exception e) {
                EsriShapeExport.this.handleException(e);
            }
        }

        static /* synthetic */ EsriShapeExport access$000(ESEInterface x0) {
            return x0.EsriShapeExport.this;
        }
    }
}

