/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPolygon;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRangeRings;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Iterator;
import java.util.Vector;

public class EsriPolygonList
extends EsriGraphicList {
    public void add(OMGraphic shape) {
        block9: {
            try {
                if (shape instanceof OMPoly) {
                    shape = EsriPolygon.convert((OMPoly)shape);
                }
                if (shape instanceof OMGraphicList) {
                    OMGraphicList list = (OMGraphicList)shape;
                    EsriGraphic graphic = (EsriGraphic)((Object)list.getOMGraphicAt(0));
                    if (graphic instanceof EsriPolygon || graphic instanceof EsriPolygonList) {
                        this.graphics.add(shape);
                        this.addExtents(((EsriGraphicList)shape).getExtents());
                    } else if (graphic instanceof OMGraphic) {
                        this.add((OMGraphic)((Object)graphic));
                    } else {
                        Debug.message("esri", "EsriPolygonList.add()- graphic list isn't a EsriPolygonList, can't add.");
                    }
                    break block9;
                }
                if (shape instanceof EsriPolygon) {
                    this.graphics.add(shape);
                    this.addExtents(((EsriPolygon)shape).getExtents());
                    break block9;
                }
                Debug.message("esri", "EsriPolygonList.add()- graphic isn't a EsriPoly or OMPoly, can't add.");
            }
            catch (ClassCastException cce) {}
        }
    }

    public int getType() {
        return 5;
    }

    public EsriPolygonList() {
    }

    public EsriPolygonList(int initialCapacity) {
        super(initialCapacity);
    }

    public EsriPolygonList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity);
    }

    public static OMPoly convert(OMRect omRect) {
        float[] rectPoints = new float[]{omRect.getNorthLat(), omRect.getWestLon(), omRect.getSouthLat(), omRect.getWestLon(), omRect.getSouthLat(), omRect.getEastLon(), omRect.getNorthLat(), omRect.getEastLon(), omRect.getNorthLat(), omRect.getWestLon()};
        OMPoly poly = new OMPoly(rectPoints, 0, omRect.getLineType());
        poly.setAppObject(omRect.getAppObject());
        DrawingAttributes da = new DrawingAttributes();
        da.setFrom(omRect);
        da.setTo(poly);
        return poly;
    }

    public static OMPoly convert(OMCircle omCircle, Projection proj) {
        GeneralPath shape = omCircle.getShape();
        PathIterator circle = shape.getPathIterator(null);
        Vector<Float> initialPoints = new Vector<Float>();
        float[] segPoints = new float[2];
        while (!circle.isDone()) {
            int segType = circle.currentSegment(segPoints);
            initialPoints.add(new Float(segPoints[0]));
            initialPoints.add(new Float(segPoints[1]));
            circle.next();
        }
        float[] circlePoints = new float[initialPoints.size()];
        if (proj == null) {
            return null;
        }
        int p = 0;
        while (p < initialPoints.size()) {
            LatLonPoint llp = proj.inverse(((Float)initialPoints.elementAt(p)).intValue(), ((Float)initialPoints.elementAt(p + 1)).intValue());
            circlePoints[p] = llp.getLatitude();
            circlePoints[p + 1] = llp.getLongitude();
            p += 2;
        }
        OMPoly poly = new OMPoly(circlePoints, 0, omCircle.getLineType());
        poly.setAppObject(omCircle.getAppObject());
        DrawingAttributes da = new DrawingAttributes();
        da.setFrom(omCircle);
        da.setTo(poly);
        return poly;
    }

    public static OMGraphicList convert(OMRangeRings omRR, Projection proj) {
        OMCircle[] circles = omRR.createCircles();
        OMGraphicList circleList = new OMGraphicList();
        circleList.setAppObject(omRR.getAppObject());
        if (proj == null) {
            return circleList;
        }
        int i = 0;
        while (i < circles.length) {
            if (circles[i].generate(proj)) {
                OMPoly poly = EsriPolygonList.convert(circles[i], proj);
                if (poly != null) {
                    circleList.add(poly);
                }
            } else {
                System.out.println("Could not generate circle from RangeRing");
                return null;
            }
            ++i;
        }
        DrawingAttributes da = new DrawingAttributes();
        da.setFrom(omRR);
        da.setTo(circleList);
        return circleList;
    }

    public EsriGraphic shallowCopy() {
        EsriPolygonList ret = new EsriPolygonList(this.size());
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            EsriGraphic g = (EsriGraphic)iter.next();
            ret.add((OMGraphic)((Object)g.shallowCopy()));
        }
        ret.setAppObject(this.getAppObject());
        return ret;
    }
}

