/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.InfoDisplayListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.ProgressEvent;
import com.bbn.openmap.event.ProgressListener;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.MiniBrowser;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.StatusLightPanel;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.WebBrowser;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ToolTipManager;

public class InformationDelegator
extends OMComponentPanel
implements InfoDisplayListener,
PropertyChangeListener,
ProgressListener,
MapPanelChild {
    protected JLabel infoLineHolder;
    protected JLabel infoLineHolder2;
    protected WebBrowser browser;
    protected StatusLightPanel statusBar;
    protected JProgressBar progressBar;
    protected MapBean map;
    protected ToolTipManager ttmanager;
    protected String propertyPrefix;
    private String fudgeString = " ";
    protected Cursor fallbackMapBeanCursor = Cursor.getDefaultCursor();
    protected Cursor currentMapBeanCursor = null;
    protected boolean waitingForLayers = false;
    protected boolean showWaitCursor = false;
    protected boolean showLights = true;
    public static final String ShowLightsProperty = "showLights";
    protected boolean showInfoLine = true;
    public static final String ShowInfoLineProperty = "showInfoLine";
    public static final int MAP_OBJECT_INFO_LINE = 0;
    public static final int COORDINATE_INFO_LINE = 1;
    protected ArrayList infoLineOrganizer = new ArrayList();
    protected String preferredLocation = "South";
    static /* synthetic */ Class class$java$awt$Frame;

    public InformationDelegator() {
        this.initInfoWidgets();
    }

    public void initInfoWidgets() {
        Debug.message("info", "InformationDelegator.initInfoWidgets");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setFont(new Font("Helvetica", 0, 9));
        this.setLayout(gridbag);
        this.progressBar = new JProgressBar();
        gridbag.setConstraints(this.progressBar, c);
        this.add(this.progressBar);
        this.progressBar.setVisible(false);
        JPanel infoLinePanel = new JPanel();
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        gridbag.setConstraints(infoLinePanel, c);
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        infoLinePanel.setLayout(gridbag2);
        this.infoLineHolder = new JLabel(this.fudgeString);
        c2.weightx = 1.0;
        c2.fill = 2;
        c2.anchor = 17;
        c2.insets = new Insets(3, 10, 3, 10);
        gridbag2.setConstraints(this.infoLineHolder, c2);
        infoLinePanel.add(this.infoLineHolder);
        this.infoLineHolder2 = new JLabel(this.fudgeString, 4);
        c2.weightx = 0.0;
        c2.anchor = 13;
        gridbag2.setConstraints(this.infoLineHolder2, c2);
        infoLinePanel.add(this.infoLineHolder2);
        this.addInfoLine(1, this.infoLineHolder);
        this.addInfoLine(0, this.infoLineHolder2);
        this.add(infoLinePanel);
        infoLinePanel.setVisible(this.showInfoLine);
        c.weightx = 0.0;
        c.anchor = 13;
        this.statusBar = new StatusLightPanel();
        gridbag.setConstraints(this.statusBar, c);
        this.add(this.statusBar);
        this.statusBar.setVisible(this.showLights);
    }

    public void setMap(MapBean map) {
        if (this.map != null) {
            this.map.removePropertyChangeListener(this);
        }
        this.map = map;
        if (map != null) {
            map.addPropertyChangeListener(this);
            this.fallbackMapBeanCursor = map.getCursor();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "NewActiveMouseMode") {
            MapMouseMode mmm = (MapMouseMode)evt.getNewValue();
            this.setAllLabels(this.fudgeString);
            this.setResetCursor(mmm.getModeCursor());
        } else if (evt.getPropertyName() == "MapBean.cursor") {
            this.fallbackMapBeanCursor = (Cursor)evt.getNewValue();
        } else if (evt.getPropertyName() == "MapBean.layers") {
            this.resetForLayers((Layer[])evt.getNewValue(), (Layer[])evt.getOldValue());
            this.setAllLabels(this.fudgeString);
        } else if (evt.getPropertyName() == "MapBean.projection") {
            this.setAllLabels(this.fudgeString);
        }
    }

    public void resetForLayers(Layer[] connectToLayers, Layer[] removeFromLayers) {
        int removeLength;
        int i = 0;
        if (removeFromLayers != null && removeFromLayers.length != 0) {
            removeLength = removeFromLayers.length;
            i = 0;
            while (i < removeLength) {
                removeFromLayers[i].removeInfoDisplayListener(this);
                ++i;
            }
        }
        if (connectToLayers != null && connectToLayers.length != 0) {
            removeLength = connectToLayers.length;
            i = 0;
            while (i < removeLength) {
                connectToLayers[i].addInfoDisplayListener(this);
                ++i;
            }
        }
    }

    public void updateProgress(ProgressEvent evt) {
        if (this.progressBar != null) {
            int type = evt.getType();
            if (type == 0 || type == 1) {
                this.progressBar.setVisible(true);
                this.progressBar.setValue(evt.getPercentComplete());
                this.setLabel(evt.getTaskDescription());
            } else {
                this.progressBar.setVisible(false);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addInfoLine(int refIndex, JLabel iLine) {
        block4: {
            block3: {
                try {
                    this.infoLineOrganizer.set(refIndex, iLine);
                    return;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    if (!true) break block3;
                    if (refIndex <= 0) return;
                    if (this.infoLineOrganizer.size() > refIndex + 1) break block4;
                }
            }
            do {
                this.infoLineOrganizer.add(iLine);
                if (refIndex <= 0) return;
            } while (this.infoLineOrganizer.size() <= refIndex + 1);
        }
    }

    public void removeInfoLine(int refIndex) {
        try {
            this.infoLineOrganizer.set(refIndex, null);
        }
        catch (IndexOutOfBoundsException iiobe) {}
    }

    public void setLabel(String str) {
        this.setLabel(str, 0);
    }

    public void setAllLabels(String str) {
        int i = 0;
        while (i < this.infoLineOrganizer.size()) {
            this.setLabel(str, i);
            ++i;
        }
    }

    public void setLabel(String str, int infoLineDesignator) {
        JLabel iLine;
        try {
            iLine = (JLabel)this.infoLineOrganizer.get(infoLineDesignator);
        }
        catch (IndexOutOfBoundsException ioobe) {
            iLine = (JLabel)this.infoLineOrganizer.get(0);
        }
        if (iLine != null) {
            iLine.setText(str);
        }
    }

    protected void setStatusBar() {
        this.statusBar.reset();
    }

    public void initBrowser() {
        this.setBrowser(new WebBrowser());
    }

    public void setBrowser(WebBrowser wb) {
        this.browser = wb;
        this.browser.setInfoDelegator(this);
    }

    public WebBrowser getBrowser() {
        if (this.browser == null) {
            this.initBrowser();
        }
        return this.browser;
    }

    public void checkBrowser() {
        if (this.browser != null) {
            this.browser.exitValue();
        }
    }

    public void displayURL(String url) {
        MapHandler mh = (MapHandler)this.getBeanContext();
        Frame frame = null;
        if (mh != null) {
            frame = (Frame)mh.get(class$java$awt$Frame == null ? (class$java$awt$Frame = InformationDelegator.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
        try {
            MiniBrowser.display(frame, new URL(url));
        }
        catch (MalformedURLException murle) {
            Debug.error("InformationDelegator can't launch " + url);
        }
    }

    public void displayBrowserContent(String content) {
        MapHandler mh = (MapHandler)this.getBeanContext();
        Frame frame = null;
        if (mh != null) {
            frame = (Frame)mh.get(class$java$awt$Frame == null ? (class$java$awt$Frame = InformationDelegator.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
        MiniBrowser.display(frame, "text/html", content);
    }

    public void displayInfoLine(String infoLine) {
        this.displayInfoLine(infoLine, 0);
    }

    public void displayInfoLine(String infoLine, int labelDesignator) {
        if (this.infoLineHolder != null) {
            this.setLabel(infoLine != null && infoLine.length() > 0 ? infoLine : this.fudgeString, labelDesignator);
        }
    }

    public void displayMessage(String title, String message) {
        JOptionPane.showMessageDialog(null, message, title, 1);
    }

    public void requestURL(InfoDisplayEvent event) {
        this.displayURL(event.getInformation());
    }

    public void requestMessage(InfoDisplayEvent event) {
        Layer l = event.getLayer();
        String layername = l == null ? null : l.getName();
        this.displayMessage("Message from " + layername + " layer:", event.getInformation());
    }

    public void requestInfoLine(InfoDisplayEvent event) {
        this.displayInfoLine(event.getInformation(), event.getPreferredLocation());
    }

    public void requestBrowserContent(InfoDisplayEvent event) {
        this.displayBrowserContent(event.getInformation());
    }

    public void requestShowToolTip(MouseEvent me, InfoDisplayEvent event) {
        this.requestShowToolTip(event);
    }

    public void requestShowToolTip(InfoDisplayEvent event) {
        if (this.map != null) {
            if (this.ttmanager == null) {
                this.ttmanager = ToolTipManager.sharedInstance();
                this.ttmanager.registerComponent(this.map);
            }
            this.map.setToolTipText(event.getInformation());
            this.ttmanager.setEnabled(true);
        }
    }

    public void requestHideToolTip(MouseEvent me) {
        this.requestHideToolTip();
    }

    public void requestHideToolTip() {
        if (this.ttmanager == null) {
            return;
        }
        this.ttmanager.setEnabled(false);
        this.initToolTip();
    }

    public void initToolTip() {
        if (this.ttmanager == null) {
            return;
        }
        if (this.map != null) {
            this.map.setToolTipText(null);
        }
    }

    public void requestCursor(Cursor cursor) {
        if (cursor == null) {
            if (this.showWaitCursor && !this.waitingForLayers) {
                this.resetCursor();
            }
            this.currentMapBeanCursor = null;
        } else if (this.map != null) {
            Cursor newCursor;
            if (this.showWaitCursor && this.waitingForLayers) {
                newCursor = Cursor.getPredefinedCursor(3);
                this.currentMapBeanCursor = cursor;
            } else {
                newCursor = cursor;
            }
            this.map.setCursor(newCursor);
        }
    }

    public void setResetCursor(Cursor cursor) {
        this.fallbackMapBeanCursor = cursor;
    }

    public void resetCursor() {
        if (this.map != null) {
            this.map.setCursor(this.fallbackMapBeanCursor);
        }
    }

    public void setShowWaitCursor(boolean value) {
        this.showWaitCursor = value;
    }

    public boolean isShowWaitCursor() {
        return this.showWaitCursor;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            this.setMap((MapBean)someObj);
        }
        if (someObj instanceof MouseDelegator) {
            MouseDelegator md = (MouseDelegator)someObj;
            md.addPropertyChangeListener(this);
        }
        this.statusBar.findAndInit(someObj);
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean) {
            this.setMap(null);
        }
        if (someObj instanceof MouseDelegator) {
            MouseDelegator md = (MouseDelegator)someObj;
            md.removePropertyChangeListener(this);
        }
        this.statusBar.findAndUndo(someObj);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.statusBar.setProperties(prefix, props);
        this.setShowLights(LayerUtils.booleanFromProperties(props, prefix + ShowLightsProperty, this.showLights));
        this.setShowInfoLine(LayerUtils.booleanFromProperties(props, prefix + ShowInfoLineProperty, this.showInfoLine));
        String pl = props.getProperty(prefix + "preferredLocation");
        if (pl != null) {
            this.setPreferredLocation(pl);
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.statusBar.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + ShowLightsProperty, new Boolean(this.showLights).toString());
        props.put(prefix + ShowInfoLineProperty, new Boolean(this.showInfoLine).toString());
        props.put(prefix + "preferredLocation", this.getPreferredLocation());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.statusBar.getPropertyInfo(props);
        props.put(ShowLightsProperty, "Show the layer status lights");
        props.put("showLights.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        props.put(ShowInfoLineProperty, "Show the information line below the map");
        props.put("showInfoLine.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        props.put("preferredLocation", "The preferred BorderLayout direction to place this component.");
        return props;
    }

    public void setInfoLineHolder(JLabel ilh) {
        this.infoLineHolder = ilh;
    }

    public JLabel getInfoLineHolder() {
        return this.infoLineHolder;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setShowLights(boolean set) {
        this.showLights = set;
        this.statusBar.setVisible(set);
    }

    public boolean getShowLights() {
        return this.showLights;
    }

    public void setShowInfoLine(boolean set) {
        this.showInfoLine = set;
        this.infoLineHolder.setVisible(set);
    }

    public boolean getShowInfoLine() {
        return this.showInfoLine;
    }

    public void setLightTriggers(boolean set) {
        this.statusBar.setLightTriggers(set);
    }

    public boolean getLightTriggers() {
        return this.statusBar.getLightTriggers();
    }

    public void setFloatable(boolean value) {
    }

    public void setPreferredLocation(String value) {
        this.preferredLocation = value;
    }

    public String getPreferredLocation() {
        return this.preferredLocation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

