/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.I18n;
import com.bbn.openmap.util.Debug;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BasicI18n
implements I18n {
    public static final String DEBUG = "i18n";
    public static final String ResourceFileNamePrefix = "I18N";
    private Locale loc;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$javax$swing$JButton;
    static /* synthetic */ Class class$javax$swing$JMenu;
    static /* synthetic */ Class class$javax$swing$JMenuItem;
    static /* synthetic */ Class class$javax$swing$JDialog;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$javax$swing$JComponent;

    public BasicI18n() {
        this(Locale.getDefault());
    }

    public BasicI18n(Locale loc) {
        this.loc = loc;
    }

    public String get(Object requestor, String field, String defaultString) {
        return this.get(requestor, field, 1, defaultString);
    }

    public String get(Object requestor, String field, int type, String defaultString) {
        return this.get(requestor.getClass(), field, type, defaultString);
    }

    public String get(Class requestor, String field, String defaultString) {
        return this.get(requestor, field, 1, defaultString);
    }

    public String get(Class requestor, String field, int type, String defaultString) {
        String ret = this.getInternal(requestor, field, type);
        if (ret == null) {
            return defaultString;
        }
        return ret;
    }

    public String get(Object requestor, String field, String defaultString, Object param1) {
        return this.get(requestor.getClass(), field, 1, defaultString, new Object[]{param1});
    }

    public String get(Object requestor, String field, int type, String defaultString, Object param1) {
        return this.get(requestor.getClass(), field, type, defaultString, new Object[]{param1});
    }

    public String get(Class requestor, String field, String defaultString, Object param1) {
        return this.get(requestor, field, 1, defaultString, new Object[]{param1});
    }

    public String get(Class requestor, String field, int type, String defaultString, Object param1) {
        return this.get(requestor, field, type, defaultString, new Object[]{param1});
    }

    public String get(Object requestor, String field, String defaultString, Object param1, Object param2) {
        return this.get(requestor.getClass(), field, 1, defaultString, new Object[]{param1, param2});
    }

    public String get(Object requestor, String field, int type, String defaultString, Object param1, Object param2) {
        return this.get(requestor.getClass(), field, type, defaultString, new Object[]{param1, param2});
    }

    public String get(Class requestor, String field, String defaultString, Object param1, Object param2) {
        return this.get(requestor, field, 1, defaultString, new Object[]{param1, param2});
    }

    public String get(Class requestor, String field, int type, String defaultString, Object param1, Object param2) {
        return this.get(requestor, field, type, defaultString, new Object[]{param1, param2});
    }

    public String get(Object requestor, String field, String defaultString, Object[] params) {
        return this.get(requestor.getClass(), field, 1, defaultString, params);
    }

    public String get(Object requestor, String field, int type, String defaultString, Object[] params) {
        return this.get(requestor.getClass(), field, type, defaultString, params);
    }

    public String get(Class requestor, String field, String defaultString, Object[] params) {
        return this.get(requestor, field, 1, defaultString, params);
    }

    public String get(Class requestor, String field, int type, String defaultString, Object[] params) {
        return MessageFormat.format(this.get(requestor, field, type, defaultString), params);
    }

    public void set(Object requestor, String field, JLabel comp) {
        this.set(requestor, field, (JComponent)comp);
        comp.setText(this.getTEXT(requestor, field, comp.getText()));
        comp.setDisplayedMnemonic(this.getMNEMONIC(requestor, field, comp.getDisplayedMnemonic(), false));
    }

    public void set(Object requestor, String field, JButton comp) {
        this.set(requestor, field, (JComponent)comp);
        comp.setText(this.getTEXT(requestor, field, comp.getText()));
        comp.setMnemonic(this.getMNEMONIC(requestor, field, comp.getMnemonic(), false));
    }

    public void set(Object requestor, String field, JMenu comp) {
        this.set(requestor, field, (JComponent)comp);
        comp.setText(this.getTEXT(requestor, field, comp.getText()));
        comp.setMnemonic(this.getMNEMONIC(requestor, field, comp.getMnemonic(), true));
    }

    public void set(Object requestor, String field, JMenuItem comp) {
        this.set(requestor, field, (JComponent)comp);
        comp.setText(this.getTEXT(requestor, field, comp.getText()));
        comp.setMnemonic(this.getMNEMONIC(requestor, field, comp.getMnemonic(), true));
    }

    public void set(Object requestor, String field, JDialog comp) {
        comp.setTitle(this.getTITLE(requestor, field, comp.getTitle()));
    }

    public void set(Object requestor, String field, JFrame comp) {
        comp.setTitle(this.getTITLE(requestor, field, comp.getTitle()));
    }

    public void set(Object requestor, String field, JComponent comp) {
        this.setTOOLTIP(requestor, field, comp);
        Border b = comp.getBorder();
        if (b instanceof TitledBorder) {
            TitledBorder t = (TitledBorder)b;
            t.setTitle(this.getTITLE(requestor, field, t.getTitle()));
        }
    }

    public void set(Object requestor, String field) {
        Class<?> c = requestor.getClass();
        Field f = null;
        try {
            f = c.getField(field);
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            MissingResourceException r = new MissingResourceException("SecurityException trying to reflect on field field", c.getName(), field);
            r.initCause(e);
            throw r;
        }
        if (f == null) {
            try {
                f = c.getDeclaredField(field);
            }
            catch (NoSuchFieldException e) {
                MissingResourceException r = new MissingResourceException("Can't find field via reflection", c.getName(), field);
                r.initCause(e);
                throw r;
            }
            catch (SecurityException e) {
                MissingResourceException r = new MissingResourceException("SecurityException trying to reflect on field field", c.getName(), field);
                r.initCause(e);
                throw r;
            }
        }
        try {
            f.setAccessible(true);
        }
        catch (SecurityException e) {
            Debug.message(DEBUG, "Coudn't set field " + field + " accessible");
        }
        Class<?> type = f.getType();
        Object fd = null;
        try {
            fd = f.get(requestor);
        }
        catch (IllegalArgumentException e) {
            MissingResourceException r = new MissingResourceException("Couldn't get field", c.getName(), field);
            r.initCause(e);
            throw r;
        }
        catch (IllegalAccessException e) {
            MissingResourceException r = new MissingResourceException("Couldn't access field", c.getName(), field);
            r.initCause(e);
            throw r;
        }
        if ((class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = BasicI18n.class$("javax.swing.JLabel")) : class$javax$swing$JLabel).isInstance(type)) {
            this.set(requestor, field, (JLabel)fd);
        } else if ((class$javax$swing$JButton == null ? (class$javax$swing$JButton = BasicI18n.class$("javax.swing.JButton")) : class$javax$swing$JButton).isInstance(type)) {
            this.set(requestor, field, (JButton)fd);
        } else if ((class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = BasicI18n.class$("javax.swing.JMenu")) : class$javax$swing$JMenu).isInstance(type)) {
            this.set(requestor, field, (JMenu)fd);
        } else if ((class$javax$swing$JMenuItem == null ? (class$javax$swing$JMenuItem = BasicI18n.class$("javax.swing.JMenuItem")) : class$javax$swing$JMenuItem).isInstance(type)) {
            this.set(requestor, field, (JMenuItem)fd);
        } else if ((class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = BasicI18n.class$("javax.swing.JDialog")) : class$javax$swing$JDialog).isInstance(type)) {
            this.set(requestor, field, (JDialog)fd);
        } else if ((class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = BasicI18n.class$("javax.swing.JFrame")) : class$javax$swing$JFrame).isInstance(type)) {
            this.set(requestor, field, (JFrame)fd);
        } else if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = BasicI18n.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isInstance(type)) {
            this.set(requestor, field, (JComponent)fd);
        } else {
            Debug.message(DEBUG, "Couldn't assign data for unknown type: " + type);
        }
    }

    public void fill(Object requestor) {
    }

    protected void setTOOLTIP(Object requestor, String field, JComponent comp) {
        String tooltip = this.get(requestor, field, 3, comp.getToolTipText());
        if (tooltip != null) {
            comp.setToolTipText(tooltip);
        } else {
            Debug.message(DEBUG, "No tooltip for: " + BasicI18n.getKeyRef(requestor, field));
        }
    }

    protected String getTEXT(Object requestor, String field, String defaultString) {
        String text = this.get(requestor, field, 1, defaultString);
        if (text == null) {
            throw new MissingResourceException("No TEXT resource", requestor.getClass().getName(), field);
        }
        return text;
    }

    protected String getTITLE(Object requestor, String field, String defaultString) {
        String title = this.get(requestor, field, 2, defaultString);
        if (title == null) {
            throw new MissingResourceException("No TITLE resource", requestor.getClass().getName(), field);
        }
        return title;
    }

    protected int getMNEMONIC(Object requestor, String field, int defaultInt, boolean verbose) {
        String mn = this.get(requestor, field, 4, Character.toString((char)defaultInt));
        if (mn == null) {
            if (verbose) {
                Debug.message(DEBUG, "No MNEMONIC resource for " + BasicI18n.getKeyRef(requestor, field));
            }
            return defaultInt;
        }
        return Character.getNumericValue(mn.charAt(0));
    }

    protected String getInternal(Class requestor, String field, int type) {
        ResourceBundle bundle = null;
        String bString = requestor.getPackage().getName() + "." + ResourceFileNamePrefix;
        try {
            bundle = ResourceBundle.getBundle(bString, this.loc);
        }
        catch (MissingResourceException e) {
            Debug.message(DEBUG, "Could not locate resource: " + bString.replace('.', '/') + ".properties");
            return null;
        }
        String key = BasicI18n.shortClassName(requestor) + "." + field;
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                key = key + ".title";
                break;
            }
            case 3: {
                key = key + ".tooltip";
                break;
            }
            case 4: {
                key = key + ".mnemonic";
            }
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            Debug.message(DEBUG, "Could not locate string in resource: " + requestor.getPackage().getName().replace('.', '/') + ".properties for key: " + key);
            return null;
        }
    }

    private static String shortClassName(Class c) {
        String name = c.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private static String getKeyRef(Object requestor, String field) {
        return requestor.getClass().getName() + "." + field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

