/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.util;

import java.io.Serializable;

public class JID
implements Serializable,
Comparable {
    public static int USERNAME = 1;
    public static int SERVER = 2;
    public static int RESOURCE = 4;
    private String username;
    private String server;
    private String resource;

    public JID(String string) {
        if (string == null || string.equals("")) {
            throw new RuntimeException("illegal null domain value");
        }
        if (string.getBytes().length > 255) {
            throw new RuntimeException("illegal length for domain value");
        }
        this.resource = null;
        this.username = null;
        this.server = string;
        this.server.intern();
    }

    public JID(String string, String string2, String string3) {
        this(string2);
        if (null != string) {
            if (string.getBytes().length > 256) {
                throw new RuntimeException("illegal length for node value");
            }
            if ("".equals(string)) {
                this.username = null;
            } else {
                this.username = string;
                this.username.intern();
            }
        }
        if (null != string3) {
            if (string3.getBytes().length > 256) {
                throw new RuntimeException("illegal length for resource value");
            }
            if ("".equals(string3)) {
                this.resource = null;
            } else {
                this.resource = string3;
                this.resource.intern();
            }
        }
    }

    public static JID fromString(String string) {
        String string2;
        String string3;
        String string4;
        int n;
        if (string.regionMatches(true, 0, "jabber:", 0, 7)) {
            string = string.substring(7);
        }
        if ((n = string.indexOf("@")) == -1) {
            string4 = null;
        } else {
            string4 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        n = string.indexOf("/");
        if (n == -1) {
            string3 = null;
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return new JID(string4, string2, string3);
    }

    public String getUsername() {
        return this.username;
    }

    public String getServer() {
        return this.server;
    }

    public String getResource() {
        return this.resource;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.username) {
            stringBuffer.append(this.username).append('@');
        }
        stringBuffer.append(this.server);
        if (null != this.resource) {
            stringBuffer.append('/').append(this.resource);
        }
        return new String(stringBuffer);
    }

    public String toPrettyString() {
        String string = this.toString();
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String toSimpleString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.username) {
            stringBuffer.append(this.username).append('@');
        }
        stringBuffer.append(this.server);
        return new String(stringBuffer);
    }

    public String getBaseAddress() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.username) {
            stringBuffer.append(this.username).append('@');
        }
        stringBuffer.append(this.server);
        return new String(stringBuffer);
    }

    public JID getBaseJID() {
        return new JID(this.username, this.server, null);
    }

    public boolean equals(JID jID) {
        return null == jID ? false : this.normalize().equals(jID.normalize());
    }

    public boolean equals(Object object) {
        return object instanceof JID ? this.equals((JID)object) : false;
    }

    public boolean equals(JID jID, int n) {
        if (null == jID) {
            return false;
        }
        if (0 >= n) {
            return this.equals(jID);
        }
        if ((n & USERNAME) > 0 && this.getUsername().compareToIgnoreCase(jID.getUsername()) != 0) {
            return false;
        }
        if ((n & SERVER) > 0 && this.getServer().compareToIgnoreCase(jID.getServer()) != 0) {
            return false;
        }
        return (n & RESOURCE) <= 0 || this.getResource().compareTo(jID.getResource()) == 0;
    }

    public int compareTo(Object object) {
        return object instanceof JID ? this.normalize().compareTo(((JID)object).normalize()) : -2;
    }

    public int compare(Object object) {
        return this.compareTo(object);
    }

    public static int compare(Object object, Object object2) {
        if (object instanceof JID && object2 instanceof JID) {
            return ((JID)object).normalize().compareTo(((JID)object2).normalize());
        }
        return -2;
    }

    public String normalize() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.username) {
            stringBuffer.append(this.username.toLowerCase()).append('@');
        }
        stringBuffer.append(this.server.toLowerCase());
        if (null != this.resource) {
            stringBuffer.append('/').append(this.resource);
        }
        return new String(stringBuffer);
    }

    public static String normalize(JID jID) {
        return new String(jID.normalize());
    }

    public int hashCode() {
        return this.normalize().hashCode();
    }
}

