/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.Packet;
import org.jabber.jabberbeans.sax.XMLStreamDocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class InputStreamHandler
extends Thread {
    private InputStream in = null;
    private ConnectionBean.InputStreamInterface isi = null;
    private boolean parsingDone;
    private String parsername;
    private static final String CHANGE_PARSER_TOO_LATE = "You must set the parser before connecting.";
    private static final String DEFAULT_PARSER = "com.microstar.xml.SAXDriver";

    public InputStreamHandler(ConnectionBean.InputStreamInterface inputStreamInterface) {
        this.isi = inputStreamInterface;
        this.parsingDone = false;
        this.parsername = DEFAULT_PARSER;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public final void run() {
        Parser parser;
        if (this.in == null) {
            throw new RuntimeException("attempting to start InputStreamHandler without input to monitor");
        }
        try {
            parser = (Parser)Class.forName(this.parsername).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("InputStreamHandler:" + exception.toString());
        }
        XMLStreamDocumentHandler xMLStreamDocumentHandler = new XMLStreamDocumentHandler();
        xMLStreamDocumentHandler.setPacketHandler(this.isi);
        xMLStreamDocumentHandler.setParser(parser);
        parser.setDocumentHandler(xMLStreamDocumentHandler);
        try {
            InputSource inputSource = new InputSource(new InputStreamReader(this.in, "UTF8"));
            parser.parse(inputSource);
        }
        catch (IOException iOException) {
            if (this.parsingDone) {
                return;
            }
            this.isi.unexpectedThreadDeath(iOException);
        }
        catch (SAXException sAXException) {
            if (this.parsingDone) {
                return;
            }
            this.isi.unexpectedThreadDeath(sAXException);
        }
        System.err.println("InputStream: parsing done");
        this.parsingDone = true;
    }

    public void received(Packet packet) {
        this.isi.received(packet);
    }

    public void shutdown() {
        System.err.println("InputStream: shutdown");
        this.parsingDone = true;
        this.interrupt();
        System.err.println("InputStream: interrupted");
    }

    public void setParser(String string) {
        if (this.in != null) {
            throw new RuntimeException(CHANGE_PARSER_TOO_LATE);
        }
        this.parsername = string;
    }

    public String getParser() {
        return this.parsername;
    }
}

