/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.sax;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jabber.jabberbeans.sax.HandlerEntry;
import org.jabber.jabberbeans.sax.SubHandler;
import org.xml.sax.AttributeList;

public class HandlerFactory {
    private Hashtable hash;
    private static final String FILENAME = "/Properties/Handlers.properties";
    private HandlerEntry defaultHandler = null;

    public HandlerFactory() throws FileNotFoundException, IOException {
        Object object;
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream(FILENAME);
        if (inputStream == null) {
            throw new FileNotFoundException("properties for Handler factory not found");
        }
        properties.load(inputStream);
        Enumeration<Object> enumeration = properties.propertyNames();
        this.hash = new Hashtable();
        while (enumeration.hasMoreElements()) {
            HandlerEntry handlerEntry;
            String string;
            String string2;
            object = (String)enumeration.nextElement();
            if (((String)object).endsWith(".ns")) {
                string2 = ((String)object).substring(0, ((String)object).length() - 3);
                if (this.hash.get(string2) != null) {
                    throw new RuntimeException("Duplicate entries in file /Properties/Handlers.properties");
                }
                string = properties.getProperty((String)object);
                handlerEntry = new HandlerEntry(string2, string, null);
                this.hash.put(string, handlerEntry);
                continue;
            }
            if (!((String)object).endsWith(".element")) continue;
            string2 = ((String)object).substring(0, ((String)object).length() - 8);
            if (this.hash.get(string2) != null) {
                throw new RuntimeException("Duplicate entries in file /Properties/Handlers.properties");
            }
            string = properties.getProperty((String)object);
            handlerEntry = new HandlerEntry(string2, null, string);
            this.hash.put(string, handlerEntry);
        }
        enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            object = (HandlerEntry)enumeration.nextElement();
            ((HandlerEntry)object).setDescription(properties.getProperty(((HandlerEntry)object).getPrefix() + ".desc"));
            ((HandlerEntry)object).setBuilder(properties.getProperty(((HandlerEntry)object).getPrefix() + ".builder"));
            ((HandlerEntry)object).setHandler(properties.getProperty(((HandlerEntry)object).getPrefix() + ".handler"));
            ((HandlerEntry)object).setProduct(properties.getProperty(((HandlerEntry)object).getPrefix() + ".product"));
        }
        this.defaultHandler = new HandlerEntry("xmlns.default", "default", null);
        this.defaultHandler.setDescription(properties.getProperty(this.defaultHandler.getPrefix() + ".desc"));
        this.defaultHandler.setBuilder(properties.getProperty(this.defaultHandler.getPrefix() + ".builder"));
        this.defaultHandler.setHandler(properties.getProperty(this.defaultHandler.getPrefix() + ".handler"));
        this.defaultHandler.setProduct(properties.getProperty(this.defaultHandler.getPrefix() + ".product"));
        enumeration = null;
        properties = null;
    }

    public SubHandler getHandlerInstance(String string, AttributeList attributeList) {
        HandlerEntry handlerEntry = this.locateEntry(string, attributeList);
        try {
            if (handlerEntry == null) {
                handlerEntry = this.locateDefaultEntry();
            }
            return handlerEntry.getHandlerClass();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (handlerEntry == null) {
                throw (RuntimeException)exception;
            }
            System.err.println("error creating handler class: " + handlerEntry.getHandler());
            exception.printStackTrace();
            return null;
        }
    }

    public HandlerEntry locateEntry(String string) {
        HandlerEntry handlerEntry = (HandlerEntry)this.hash.get(string);
        if (handlerEntry == null) {
            if (this.hash.containsKey(string)) {
                throw new RuntimeException("Invalid hashtable");
            }
            return null;
        }
        return handlerEntry;
    }

    public HandlerEntry locateDefaultEntry() {
        if (this.defaultHandler.getHandler() == null) {
            throw new RuntimeException("No default specified");
        }
        return this.defaultHandler;
    }

    public HandlerEntry locateEntry(String string, AttributeList attributeList) {
        HandlerEntry handlerEntry = (HandlerEntry)this.hash.get(string);
        if (handlerEntry != null) {
            return handlerEntry;
        }
        String string2 = attributeList.getValue("xmlns");
        if (string2 == null) {
            return null;
        }
        handlerEntry = (HandlerEntry)this.hash.get(string2);
        return handlerEntry;
    }
}

