/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.sax.Extension;

import org.jabber.jabberbeans.Extension.XDataBuilder;
import org.jabber.jabberbeans.Extension.XDataField;
import org.jabber.jabberbeans.sax.HandlerFactory;
import org.jabber.jabberbeans.sax.SubHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XDataHandler
extends SubHandler {
    private StringBuffer elementChars;
    private XDataBuilder builder = new XDataBuilder();
    private boolean reported = false;
    private static final String[] elementTypes = new String[]{"reported", "instructions"};

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.elementChars.append(cArray, n, n2);
    }

    protected void startHandler(String string, AttributeList attributeList) throws SAXException {
        this.builder.reset();
        this.reported = false;
        this.elementChars = new StringBuffer();
    }

    protected Object stopHandler(String string) throws SAXException {
        this.reported = false;
        try {
            return this.builder.build();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.fillInStackTrace();
            throw new SAXException(instantiationException);
        }
    }

    protected void handleStartElement(String string, AttributeList attributeList) throws SAXException {
        this.elementChars = new StringBuffer();
        if (string.equals(elementTypes[0])) {
            this.reported = true;
        }
        if (this.checkStartElement(string, attributeList)) {
            return;
        }
        HandlerFactory handlerFactory = this.getHandlerFactory();
        SubHandler subHandler = handlerFactory.getHandlerInstance(string, attributeList);
        if (subHandler != null) {
            this.setChildSubHandler(subHandler, string, attributeList);
        }
    }

    protected void handleEndElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals(elementTypes[0])) {
            this.reported = false;
        } else if (string.equals(elementTypes[1])) {
            this.builder.setInstructions(new String(this.elementChars));
        }
    }

    protected void receiveChildData(SubHandler subHandler, Object object) {
        if (this.reported) {
            this.builder.addReported((XDataField)object);
        } else {
            this.builder.addField((XDataField)object);
        }
    }

    protected final boolean checkStartElement(String string, AttributeList attributeList) {
        int n = 0;
        while (n < elementTypes.length) {
            if (string.equals(elementTypes[n])) {
                this.elementChars = new StringBuffer();
                return true;
            }
            ++n;
        }
        return false;
    }
}

