/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.sax.Extension;

import org.jabber.jabberbeans.Extension.Extension;
import org.jabber.jabberbeans.Extension.VCardBuilder;
import org.jabber.jabberbeans.sax.HandlerFactory;
import org.jabber.jabberbeans.sax.SubHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class VCardHandler
extends SubHandler {
    StringBuffer elementChars = new StringBuffer();
    VCardBuilder vcardBuilder;
    private static final String[] elementTypes = new String[]{"FN", "GIVEN", "FAMILY", "MIDDLE", "PREFIX", "SUFFIX", "NICKNAME", "PHOTO", "URL", "HOMECELL", "WORKCELL", "UID", "PRODID", "BDAY", "JABBERID", "TZ", "LAT", "LON", "ORG", "ORGNAME", "ORGUNIT", "TITLE", "ROLE", "LOGO"};

    public VCardHandler() {
        this.createVCardBuilder();
    }

    protected void createVCardBuilder() {
        this.vcardBuilder = new VCardBuilder();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 > 0) {
            this.elementChars.append(cArray, n, n2);
        }
    }

    protected void startHandler(String string, AttributeList attributeList) throws SAXException {
        this.vcardBuilder.reset();
        this.vcardBuilder.setVersion(attributeList.getValue("version"));
    }

    protected void handleStartElement(String string, AttributeList attributeList) throws SAXException {
        this.elementChars = new StringBuffer();
        if (this.checkStartElement(string, attributeList)) {
            return;
        }
        HandlerFactory handlerFactory = this.getHandlerFactory();
        SubHandler subHandler = handlerFactory.getHandlerInstance(string, attributeList);
        if (subHandler != null) {
            this.setChildSubHandler(subHandler, string, attributeList);
            return;
        }
    }

    protected void handleEndElement(String string) throws SAXException {
        if (string.equalsIgnoreCase("FN")) {
            this.vcardBuilder.setFN(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("GIVEN")) {
            this.vcardBuilder.setGIVEN(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("FAMILY")) {
            this.vcardBuilder.setFAMILY(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("MIDDLE")) {
            this.vcardBuilder.setMIDDLE(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("PREFIX")) {
            this.vcardBuilder.setPREFIX(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("SUFFIX")) {
            this.vcardBuilder.setSUFFIX(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("NICKNAME")) {
            this.vcardBuilder.setNICKNAME(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("PHOTO")) {
            this.vcardBuilder.setPHOTO(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("URL")) {
            this.vcardBuilder.setURL(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("HOMECELL")) {
            this.vcardBuilder.setHOMECELL(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("WORKCELL")) {
            this.vcardBuilder.setWORKCELL(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("UID")) {
            this.vcardBuilder.setUID(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("PRODID")) {
            this.vcardBuilder.setPRODID(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("BDAY")) {
            this.vcardBuilder.setBDAY(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("JABBERID")) {
            this.vcardBuilder.setJABBERID(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("MAILER")) {
            this.vcardBuilder.setMAILER(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("TZ")) {
            this.vcardBuilder.setTZ(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("LAT")) {
            this.vcardBuilder.setLAT(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("LON")) {
            this.vcardBuilder.setLON(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("ORG")) {
            // empty if block
        }
        if (string.equalsIgnoreCase("ORGNAME")) {
            this.vcardBuilder.setORGNAME(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("ORGUNIT")) {
            this.vcardBuilder.setORGUNIT(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("TITLE")) {
            this.vcardBuilder.setTITLE(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("ROLE")) {
            this.vcardBuilder.setROLE(this.checkBuffer(new String(this.elementChars)));
        }
        if (string.equalsIgnoreCase("LOGO")) {
            this.vcardBuilder.setLOGO(this.checkBuffer(new String(this.elementChars)));
        }
    }

    protected Object stopHandler(String string) throws SAXException {
        try {
            return this.vcardBuilder.build();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.fillInStackTrace();
            throw new SAXException(instantiationException);
        }
    }

    protected void receiveChildData(SubHandler subHandler, Object object) {
        this.vcardBuilder.addExtension((Extension)object);
    }

    protected final boolean checkStartElement(String string, AttributeList attributeList) {
        int n = 0;
        while (n < elementTypes.length) {
            if (string.equals(elementTypes[n])) {
                this.elementChars = new StringBuffer();
                return true;
            }
            ++n;
        }
        return false;
    }

    private String checkBuffer(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        return string.trim();
    }
}

