/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.sax.Extension;

import org.jabber.jabberbeans.Extension.RosterBuilder;
import org.jabber.jabberbeans.RosterItemBuilder;
import org.jabber.jabberbeans.sax.SubHandler;
import org.jabber.jabberbeans.util.JID;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class RosterHandler
extends SubHandler {
    StringBuffer elementChars = new StringBuffer();
    RosterBuilder listBuilder;
    RosterItemBuilder itemBuilder = new RosterItemBuilder();
    private static final String[] elementType = new String[]{"item"};

    public RosterHandler() {
        this.createListBuilder();
    }

    protected void createListBuilder() {
        this.listBuilder = new RosterBuilder();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.elementChars.append(cArray, n, n2);
    }

    protected void startHandler(String string, AttributeList attributeList) throws SAXException {
        this.listBuilder.reset();
        try {
            if (attributeList.getValue("xmlns").equals("jabber:iq:roster")) {
                this.listBuilder.setIQRoster(true);
            } else {
                this.listBuilder.setIQRoster(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new SAXException("Invalid XML Namespace");
        }
    }

    protected void handleStartElement(String string, AttributeList attributeList) throws SAXException {
        this.elementChars = new StringBuffer();
        if (!string.equals("item")) {
            return;
        }
        this.itemBuilder.reset();
        this.itemBuilder.setJID(JID.fromString(attributeList.getValue("jid")));
        this.itemBuilder.setSubscriptionType(attributeList.getValue("subscription"));
        this.itemBuilder.setWaitingStateType(attributeList.getValue("ask"));
        this.itemBuilder.setFriendlyName(attributeList.getValue("name"));
        this.itemBuilder.setHidden(attributeList.getValue("hidden"));
        this.itemBuilder.setSubscribe(attributeList.getValue("subscribe"));
    }

    protected void handleEndElement(String string) throws SAXException {
        if (string.equals("group")) {
            this.itemBuilder.addGroup(new String(this.elementChars));
        }
        try {
            if (string.equals("item")) {
                this.listBuilder.addRosterItem(this.itemBuilder.build());
            }
        }
        catch (InstantiationException instantiationException) {
            instantiationException.fillInStackTrace();
            throw new SAXException(instantiationException);
        }
    }

    protected Object stopHandler(String string) throws SAXException {
        try {
            return this.listBuilder.build();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.fillInStackTrace();
            throw new SAXException(instantiationException);
        }
    }

    protected void receiveChildData(SubHandler subHandler, Object object) {
    }
}

