/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.core;

import java.util.Enumeration;
import java.util.Vector;
import org.jabber.jabberbeans.core.Attribute;
import org.jabber.jabberbeans.core.Element;
import org.jabber.jabberbeans.core.ElementBuilder;
import org.jabber.jabberbeans.core.Registry;
import org.jabber.jabberbeans.core.XMLAttribute;
import org.jabber.jabberbeans.core.XMLAttributeRegistry;
import org.jabber.jabberbeans.core.XMLElementRegistry;

public abstract class XMLElementBuilder
implements ElementBuilder {
    private String m_name = null;
    private String m_content = null;
    private XMLAttributeRegistry m_attributes = null;
    private XMLElementRegistry m_elements = null;

    public XMLElementBuilder(String string, String string2, XMLElementBuilder xMLElementBuilder) {
        this(string, string2);
        try {
            this.setElement(xMLElementBuilder.build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XMLElementBuilder(Element element) {
        this.m_name = element.getName();
        Enumeration enumeration = element.getAttributes();
        while (enumeration.hasMoreElements()) {
            this.setAttribute((Attribute)enumeration.nextElement());
        }
        enumeration = element.getElements();
        if (enumeration.hasMoreElements()) {
            this.m_elements = new XMLElementRegistry();
            while (enumeration.hasMoreElements()) {
                this.m_elements.addNode(enumeration.nextElement());
            }
        }
    }

    public XMLElementBuilder(String string, String string2) {
        this.m_name = string;
        if (string2 != null) {
            if (this.m_attributes == null) {
                this.m_attributes = new XMLAttributeRegistry();
            }
            this.m_attributes.addNode(new XMLAttribute("xmlns", string2));
        }
    }

    public XMLElementBuilder(String string) {
        this.m_name = string;
    }

    private XMLElementBuilder() {
    }

    public void reset() {
        this.m_name = null;
        this.m_content = null;
        this.m_attributes = null;
        this.m_elements = null;
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String string) {
        this.m_name = string;
    }

    public String getNamespace() {
        if (this.m_attributes == null) {
            return null;
        }
        return (String)this.m_attributes.getNode("xmlns");
    }

    protected void setNamespace(String string) {
        this.setAttribute(new XMLAttribute("xmlns", string));
    }

    public String getText() {
        return this.m_content;
    }

    protected void setText(String string) {
        this.m_content = string;
    }

    public Enumeration getAttributes() {
        if (this.m_attributes == null) {
            return new Vector(0).elements();
        }
        return this.m_attributes.getNodes();
    }

    public Registry getAttributeRegistry() {
        return this.m_attributes;
    }

    public Attribute getAttribute(String string) {
        if (this.m_attributes == null) {
            return null;
        }
        return (Attribute)this.m_attributes.getNode(string);
    }

    protected void setAttribute(Attribute attribute) {
        if (this.m_attributes == null) {
            this.m_attributes = new XMLAttributeRegistry();
        }
        this.m_attributes.addNode(attribute);
    }

    public Enumeration getElements() {
        if (this.m_elements == null) {
            return new Vector(0).elements();
        }
        return this.m_elements.getNodes();
    }

    public Registry getElementRegistry() {
        return this.m_elements;
    }

    public Element getElement(String string) {
        if (this.m_elements == null) {
            return null;
        }
        return (Element)this.m_elements.getNode(string);
    }

    protected void setElement(Element element) {
        if (this.m_elements == null) {
            this.m_elements = new XMLElementRegistry();
        }
        this.m_elements.addNode(element);
    }

    public boolean isEmpty() {
        return this.m_content == null && (this.m_elements == null || this.m_elements.isEmpty());
    }

    public abstract Element build() throws InstantiationException;
}

