/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jabber.jabberbeans.core.Attribute;
import org.jabber.jabberbeans.core.Element;
import org.jabber.jabberbeans.core.XMLAttributeRegistry;
import org.jabber.jabberbeans.core.XMLBase;
import org.jabber.jabberbeans.core.XMLElement;
import org.jabber.jabberbeans.core.XMLElementBuilder;
import org.jabber.jabberbeans.core.XMLElementRegistry;

public class AbstractElement
extends XMLBase
implements Serializable,
Cloneable,
Element {
    private XMLAttributeRegistry m_attributes;
    private XMLElementRegistry m_elements;
    private String m_content;

    AbstractElement(String string, String string2, XMLAttributeRegistry xMLAttributeRegistry, XMLElementRegistry xMLElementRegistry) {
        super(string);
        this.reset(string2, xMLAttributeRegistry, xMLElementRegistry);
    }

    AbstractElement(String string, String string2) {
        super(string);
        this.reset(string2, null, null);
    }

    AbstractElement(String string) {
        super(string);
    }

    public AbstractElement(XMLElementBuilder xMLElementBuilder) throws InstantiationException {
        super(xMLElementBuilder.getName());
        this.reset(xMLElementBuilder.getText(), (XMLAttributeRegistry)xMLElementBuilder.getAttributeRegistry(), (XMLElementRegistry)xMLElementBuilder.getElementRegistry());
    }

    public AbstractElement(XMLElement xMLElement) throws InstantiationException {
        super(new String(xMLElement.getName()));
        Enumeration enumeration = xMLElement.getAttributes();
        XMLAttributeRegistry xMLAttributeRegistry = null;
        if (enumeration.hasMoreElements()) {
            xMLAttributeRegistry = new XMLAttributeRegistry(enumeration);
        }
        XMLElementRegistry xMLElementRegistry = null;
        if (enumeration.hasMoreElements()) {
            xMLElementRegistry = new XMLElementRegistry(enumeration);
        }
        this.reset(new String(xMLElement.getText()), xMLAttributeRegistry, xMLElementRegistry);
    }

    void reset(String string, XMLAttributeRegistry xMLAttributeRegistry, XMLElementRegistry xMLElementRegistry) {
        this.m_content = string;
        this.m_attributes = xMLAttributeRegistry;
        this.m_elements = xMLElementRegistry;
    }

    public String getNamespace() {
        if (this.m_attributes == null) {
            return null;
        }
        return (String)this.m_attributes.getNode("xmlns");
    }

    public String getQualifiedName() {
        if (this.getNamespace() == null) {
            return this.getName();
        }
        return this.getNamespace() + ":" + this.getName();
    }

    public String getText() {
        return this.m_content;
    }

    public Enumeration getAttributes() {
        if (this.m_attributes == null) {
            return new Vector(0).elements();
        }
        return this.m_attributes.getNodes();
    }

    public Attribute getAttribute(String string) {
        if (this.m_attributes == null) {
            return null;
        }
        return (Attribute)this.m_attributes.getNode(string);
    }

    public Enumeration getElements() {
        if (this.m_elements == null) {
            return new Vector(0).elements();
        }
        return this.m_elements.getNodes();
    }

    public Element getElement(String string) {
        if (this.m_elements == null) {
            return null;
        }
        return (Element)this.m_elements.getNode(string);
    }

    public Element lookupElement(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            Element element = ((Element)enumeration.nextElement()).lookupElement(string);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendItem(stringBuffer);
        return stringBuffer.toString();
    }

    public void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append('<').append(this.getName());
        if (this.m_attributes != null) {
            this.m_attributes.appendItem(stringBuffer);
        }
        if (this.isEmpty()) {
            stringBuffer.append('/').append('>');
        } else {
            stringBuffer.append('>');
            this.escapeString(stringBuffer, this.m_content);
            if (this.m_elements != null) {
                this.m_elements.appendItem(stringBuffer);
            }
            stringBuffer.append('<').append('/').append(this.getName()).append('>');
        }
    }

    public boolean isEmpty() {
        return this.m_content == null && (this.m_elements == null || this.m_elements.isEmpty());
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public Object clone() {
        return new AbstractElement(new String(this.getName()), new String(this.getText()), (XMLAttributeRegistry)this.m_attributes.clone(), (XMLElementRegistry)this.m_elements.clone());
    }
}

