/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketListener;
import org.jabber.jabberbeans.PacketListenerRegistrar;

public abstract class PacketRebroadcaster
implements PacketListener,
Serializable,
PacketListenerRegistrar {
    private Vector listeners = new Vector();

    public void registerListener(ConnectionBean connectionBean) {
        connectionBean.addPacketListener(this);
    }

    public void unregisterListener(ConnectionBean connectionBean) {
        connectionBean.delPacketListener(this);
    }

    public abstract void receivedPacket(PacketEvent var1);

    public abstract void sentPacket(PacketEvent var1);

    public abstract void sendFailed(PacketEvent var1);

    public final void addPacketListener(PacketListener packetListener) {
        this.listeners.addElement(packetListener);
    }

    public final void delPacketListener(PacketListener packetListener) {
        if (this.listeners.contains(packetListener)) {
            this.listeners.removeElement(packetListener);
        }
    }

    protected final void fireReceived(PacketEvent packetEvent) {
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((PacketListener)enumeration.nextElement()).receivedPacket(packetEvent);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected final void fireSent(PacketEvent packetEvent) {
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((PacketListener)enumeration.nextElement()).sentPacket(packetEvent);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected final void fireSendFailed(PacketEvent packetEvent) {
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((PacketListener)enumeration.nextElement()).sendFailed(packetEvent);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

