/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import java.util.Enumeration;
import org.jabber.jabberbeans.ContentPacket;
import org.jabber.jabberbeans.MessageBuilder;
import org.jabber.jabberbeans.XMLData;

public final class Message
extends ContentPacket
implements Serializable {
    private String subject;
    private String thread;
    private String body;

    public Message(MessageBuilder messageBuilder) throws InstantiationException {
        super(messageBuilder);
        if (this.type == null || "normal".equals(this.type)) {
            this.type = null;
        } else {
            this.type.intern();
        }
        this.subject = messageBuilder.getSubject();
        this.thread = messageBuilder.getThread();
        this.body = messageBuilder.getBody();
        if (this.subject != null) {
            this.subject.intern();
        }
        if (this.thread != null) {
            this.thread.intern();
        }
        if (this.body != null) {
            this.body.intern();
        }
    }

    public final String getSubject() {
        return this.subject;
    }

    public final String getThread() {
        return this.thread;
    }

    public final String getBody() {
        return this.body;
    }

    public boolean isEmtpy() {
        return !(null != this.getBody() && !"".equals(this.getBody()) || null != this.getSubject() && !"".equals(this.getSubject()));
    }

    public final void appendItem(StringBuffer stringBuffer) {
        stringBuffer.append("<message");
        this.appendBaseAttribs(stringBuffer);
        stringBuffer.append(">");
        this.appendAnyError(stringBuffer);
        XMLData.appendChild(stringBuffer, "subject", this.subject);
        XMLData.appendChild(stringBuffer, "thread", this.thread);
        XMLData.appendChild(stringBuffer, "body", this.body);
        Enumeration enumeration = this.Extensions();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement());
            }
        }
        stringBuffer.append("</message>");
    }
}

