/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.InfoQuery;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketListener;
import org.jabber.jabberbeans.PacketListenerRegistrar;
import org.jabber.jabberbeans.PacketRebroadcaster;

public class IQBean
implements Serializable,
PacketListenerRegistrar {
    private ConnectionBean connection = null;
    private IQListener rebroadcaster = new IQListener();

    public IQBean() {
    }

    public IQBean(ConnectionBean connectionBean) {
        this();
        this.setConnection(connectionBean);
    }

    public void send(InfoQuery infoQuery) {
        if (this.connection == null) {
            throw new RuntimeException("IQBean not connected to a Connection object");
        }
        this.connection.send(infoQuery);
    }

    public void setConnection(ConnectionBean connectionBean) {
        if (this.connection != null) {
            throw new RuntimeException("Cannot change connection of an active IQ Bean");
        }
        this.connection = connectionBean;
        this.rebroadcaster.registerListener(connectionBean);
    }

    public ConnectionBean getConnection() {
        return this.connection;
    }

    public final void addPacketListener(PacketListener packetListener) {
        this.rebroadcaster.addPacketListener(packetListener);
    }

    public final void delPacketListener(PacketListener packetListener) {
        this.rebroadcaster.delPacketListener(packetListener);
    }

    class IQListener
    extends PacketRebroadcaster {
        IQListener() {
        }

        public void receivedPacket(PacketEvent packetEvent) {
            if (packetEvent.getPacket() instanceof InfoQuery) {
                this.fireReceived(packetEvent);
            }
        }

        public void sentPacket(PacketEvent packetEvent) {
            if (packetEvent.getPacket() instanceof InfoQuery) {
                this.fireSent(packetEvent);
            }
        }

        public void sendFailed(PacketEvent packetEvent) {
            if (packetEvent.getPacket() instanceof InfoQuery) {
                this.fireSendFailed(packetEvent);
            }
        }
    }
}

