/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.GroupChatListener;
import org.jabber.jabberbeans.Message;
import org.jabber.jabberbeans.MessageBuilder;
import org.jabber.jabberbeans.PacketAdapter;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.Presence;
import org.jabber.jabberbeans.PresenceBean;
import org.jabber.jabberbeans.PresenceBuilder;
import org.jabber.jabberbeans.PresenceUserNode;
import org.jabber.jabberbeans.util.JID;

public class GroupChatBean
implements Serializable {
    private JID address = null;
    private boolean debug = false;
    private ConnectionBean cb = null;
    private Vector chatListeners = new Vector();
    private Hashtable participantList = new Hashtable();
    private InternalPacketListener listener = null;
    private PresenceBean pb = null;

    public GroupChatBean(ConnectionBean connectionBean, JID jID, PresenceBean presenceBean) {
        this.reset(connectionBean, jID, presenceBean);
    }

    public void reset(ConnectionBean connectionBean, JID jID, PresenceBean presenceBean) {
        try {
            connectionBean.delPacketListener(this.listener);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.listener = new InternalPacketListener();
        connectionBean.addPacketListener(this.listener);
        this.cb = connectionBean;
        this.address = jID;
        this.pb = presenceBean;
        this.participantList.clear();
        presenceBean.setBlacklistEnable(true);
        presenceBean.addToBlacklist(new JID(jID.getUsername(), jID.getServer(), null));
        this.sendPresence(null, "available", "available");
    }

    public void shutdown() {
        this.pb.removeFromBlacklist(this.address);
        this.sendPresence("unavailable", "unavailable", "unavailable");
    }

    public void setAddress(JID jID) {
        if (jID != null) {
            this.address = jID;
        }
        this.sendPresence(null, "available", "available");
    }

    public JID getAddress() {
        return this.address;
    }

    public void setNickName(String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        this.address = new JID(this.address.getUsername(), this.address.getServer(), string);
        this.sendPresence(null, "available", "available");
    }

    public String getNickName() {
        return this.address.getResource();
    }

    public boolean sendPresence(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            return false;
        }
        try {
            PresenceBuilder presenceBuilder = new PresenceBuilder();
            presenceBuilder.reset();
            if (string != null) {
                presenceBuilder.setType(string);
            }
            presenceBuilder.setStateShow(string2);
            presenceBuilder.setStatus(string3);
            presenceBuilder.setToAddress(this.address);
            this.cb.send(presenceBuilder.build());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean sendMessage(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        try {
            MessageBuilder messageBuilder = new MessageBuilder();
            messageBuilder.reset();
            messageBuilder.setToAddress(new JID(this.address.getUsername(), this.address.getServer(), null));
            messageBuilder.setType("groupchat");
            if (string != null) {
                messageBuilder.setSubject(string);
            }
            messageBuilder.setBody(string2);
            this.cb.send(messageBuilder.build());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void PresenceHandler(Presence presence) {
        String string = presence.getType();
        JID jID = presence.getFromAddress();
        String string2 = presence.getStateShow();
        String string3 = presence.getStatus();
        JID jID2 = jID;
        JID jID3 = JID.fromString(jID.toSimpleString());
        boolean bl = this.participantList.containsKey(jID3);
        if (string == null || "available".equals(string)) {
            if (!bl) {
                if (this.debug) {
                    System.err.println("Adding user the first time.");
                }
                PresenceUserNode presenceUserNode = new PresenceUserNode(jID, string2, string3);
                if (this.debug) {
                    System.err.println("Node: " + presenceUserNode);
                }
                this.participantList.put(jID3, presenceUserNode);
                this.fireChangedPresence(this.participantList, presence, presenceUserNode, "online");
                if (this.debug) {
                    System.err.println("Fired changed presence event.");
                }
            } else {
                PresenceUserNode presenceUserNode = (PresenceUserNode)this.participantList.get(jID3);
                if (presenceUserNode.containsResource(jID2)) {
                    if (this.debug) {
                        System.err.println(jID2 + " adjusted for state info.");
                    }
                    presenceUserNode.setState(jID, string2);
                    presenceUserNode.setStatus(jID, string3);
                    this.fireChangedPresence(this.participantList, presence, presenceUserNode, "status");
                } else {
                    if (this.debug) {
                        System.err.println(jID + " added as a resource to the user node.");
                    }
                    presenceUserNode.addResource(jID, string2, string3);
                    if (this.debug) {
                        System.err.println("Adding resource " + jID + ".\nResources: " + presenceUserNode.getNumResources());
                    }
                    this.fireChangedPresence(this.participantList, presence, presenceUserNode, "online");
                }
                if (this.debug) {
                    System.err.println("Fired changed presence event.");
                }
            }
        } else if ("unavailable".equals(string)) {
            if (bl) {
                PresenceUserNode presenceUserNode = (PresenceUserNode)this.participantList.get(jID3);
                if (presenceUserNode.getNumResources() <= 1) {
                    this.participantList.remove(jID3);
                    if (this.debug) {
                        System.err.println("Removing room " + jID3);
                    }
                } else {
                    if (this.debug) {
                        System.err.println("Removing resource " + jID2 + ".\nResources: " + presenceUserNode.getNumResources());
                    }
                    presenceUserNode.removeResource(jID2);
                    if (this.debug) {
                        System.err.println("Removing resource " + jID2 + ".\nResources: " + presenceUserNode.getNumResources());
                    }
                }
                this.fireChangedPresence(this.participantList, presence, null, "offline");
            }
        } else {
            if (this.debug) {
                System.err.println("Error presence packet recieved");
            }
            this.fireError(presence);
        }
    }

    public void MessageHandler(Message message) {
        if ("groupchat".equals(message.getType())) {
            this.fireMessageReceived(message);
        }
    }

    public ConnectionBean getConnBean() {
        return this.cb;
    }

    public Hashtable getParticipantList() {
        return this.participantList;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public String toString() {
        String string = new String();
        Collection collection = this.participantList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PresenceUserNode presenceUserNode = (PresenceUserNode)iterator.next();
            string = string + presenceUserNode.toString();
        }
        return string;
    }

    public void fireChangedPresence(Hashtable hashtable, Presence presence, PresenceUserNode presenceUserNode, String string) {
        try {
            Vector vector = (Vector)this.chatListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((GroupChatListener)enumeration.nextElement()).ChangedPresence(hashtable, presence, presenceUserNode, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fireError(Presence presence) {
        try {
            Vector vector = (Vector)this.chatListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((GroupChatListener)enumeration.nextElement()).Error(presence);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fireMessageReceived(Message message) {
        try {
            Vector vector = (Vector)this.chatListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((GroupChatListener)enumeration.nextElement()).ReceivedMessage(message);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void addGroupChatListener(GroupChatListener groupChatListener) {
        if (!this.chatListeners.contains(groupChatListener)) {
            this.chatListeners.addElement(groupChatListener);
        }
    }

    public synchronized void delGroupChatListener(GroupChatListener groupChatListener) {
        if (this.chatListeners.contains(groupChatListener)) {
            this.chatListeners.removeElement(groupChatListener);
        }
    }

    class InternalPacketListener
    extends PacketAdapter {
        InternalPacketListener() {
        }

        public void receivedPacket(PacketEvent packetEvent) {
            try {
                if (GroupChatBean.this.debug) {
                    System.err.println(packetEvent.getPacket());
                }
                if (packetEvent.getPacket() instanceof Presence) {
                    Presence presence = (Presence)packetEvent.getPacket();
                    if (presence.getFromAddress().toSimpleString().equals(GroupChatBean.this.address.toSimpleString())) {
                        GroupChatBean.this.PresenceHandler(presence);
                    }
                    return;
                }
                if (packetEvent.getPacket() instanceof Message) {
                    Message message = (Message)packetEvent.getPacket();
                    if (message.getFromAddress().toSimpleString().equals(GroupChatBean.this.address.toSimpleString())) {
                        GroupChatBean.this.MessageHandler((Message)packetEvent.getPacket());
                    }
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

