/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jabber.jabberbeans.Extension.Extension;
import org.jabber.jabberbeans.IdentifierCounter;
import org.jabber.jabberbeans.Packet;
import org.jabber.jabberbeans.PacketBuilder;
import org.jabber.jabberbeans.XMLData;
import org.jabber.jabberbeans.util.JID;

public abstract class ContentPacket
extends XMLData
implements Packet,
Extension,
Serializable {
    protected JID toAddress;
    protected JID fromAddress;
    protected String identifier;
    protected String type;
    protected String errorCode;
    protected String errorText;
    protected Vector extensions;

    protected ContentPacket(PacketBuilder packetBuilder) {
        this.toAddress = packetBuilder.getToAddress();
        this.fromAddress = packetBuilder.getFromAddress();
        this.type = packetBuilder.getType();
        if (this.type != null) {
            this.type.intern();
        }
        this.identifier = packetBuilder.getIdentifier();
        if (this.identifier == null) {
            this.identifier = IdentifierCounter.getNewIdentifier();
        } else if (this.identifier.equals("none")) {
            this.identifier = null;
        }
        this.errorCode = packetBuilder.getErrorCode();
        this.errorText = packetBuilder.getErrorText();
        this.extensions = packetBuilder.getExtensionVector();
        if (this.identifier != null) {
            this.identifier.intern();
        }
        if (this.errorCode != null) {
            this.errorCode.intern();
        }
        if (this.errorText != null) {
            this.errorText.intern();
        }
    }

    public JID getToAddress() {
        return this.toAddress;
    }

    public JID getFromAddress() {
        return this.fromAddress;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getType() {
        return this.type;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public Enumeration Extensions() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.elements();
    }

    protected void appendBaseAttribs(StringBuffer stringBuffer) {
        XMLData.appendAttrib(stringBuffer, "to", this.toAddress);
        XMLData.appendAttrib(stringBuffer, "from", this.fromAddress);
        XMLData.appendAttrib(stringBuffer, "id", this.identifier);
        XMLData.appendAttrib(stringBuffer, "type", this.type);
    }

    protected void appendAnyError(StringBuffer stringBuffer) {
        if (this.type == null || !this.type.equals("error")) {
            return;
        }
        stringBuffer.append("<error");
        if (null != this.errorCode && this.errorCode.length() != 0) {
            stringBuffer.append(" code=\"" + this.errorCode + "\"");
        }
        if (this.errorText == null) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append(">");
        XMLData.escapeString(stringBuffer, this.errorText);
        stringBuffer.append("</error>");
    }
}

