/*
 * Decompiled with CFR 0.152.
 */
package org.jabber.jabberbeans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jabber.jabberbeans.BrowseListener;
import org.jabber.jabberbeans.ConnectionBean;
import org.jabber.jabberbeans.Extension.BrowseItem;
import org.jabber.jabberbeans.Extension.IQBrowseBuilder;
import org.jabber.jabberbeans.InfoQuery;
import org.jabber.jabberbeans.InfoQueryBuilder;
import org.jabber.jabberbeans.PacketEvent;
import org.jabber.jabberbeans.PacketID;
import org.jabber.jabberbeans.PacketListener;
import org.jabber.jabberbeans.util.JID;

public class BrowseBean
implements Serializable {
    ConnectionBean cb = null;
    Vector browseListeners = null;
    Hashtable cache = null;
    boolean debug = false;
    BrowsePacketListener packetListener = new BrowsePacketListener();

    public BrowseBean() {
        this.reset();
    }

    public void reset() {
        this.browseListeners = new Vector();
        this.cache = new Hashtable();
        this.debug = false;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setConnectionBean(ConnectionBean connectionBean) {
        if (this.cb != null) {
            this.cb.delPacketListener(this.packetListener);
        }
        this.cb = connectionBean;
        this.cb.addPacketListener(this.packetListener);
    }

    public ConnectionBean getConnectionBean() {
        return this.cb;
    }

    public void browseTo(String string, PacketID packetID, boolean bl) {
        this.browseTo(JID.fromString(string), packetID, bl);
    }

    public void browseTo(JID jID, PacketID packetID, boolean bl) {
        if (jID == null) {
            return;
        }
        if (!bl && this.cache.containsKey(jID.toString())) {
            if (packetID != null) {
                packetID.setID(((InfoQuery)this.cache.get(jID.toString())).getIdentifier());
            }
            this.packetHandler((InfoQuery)this.cache.get(jID.toString()));
        }
        try {
            InfoQueryBuilder infoQueryBuilder = new InfoQueryBuilder();
            InfoQuery infoQuery = null;
            infoQueryBuilder.reset();
            infoQueryBuilder.setType("get");
            infoQueryBuilder.setToAddress(jID);
            IQBrowseBuilder iQBrowseBuilder = new IQBrowseBuilder();
            iQBrowseBuilder.reset();
            iQBrowseBuilder.setIQ(true);
            infoQueryBuilder.addExtension(iQBrowseBuilder.build());
            infoQuery = (InfoQuery)infoQueryBuilder.build();
            if (packetID != null) {
                packetID.setID(infoQuery.getIdentifier());
            }
            this.cb.send(infoQuery);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void packetHandler(InfoQuery infoQuery) {
        Enumeration enumeration = null;
        try {
            enumeration = infoQuery.Extensions();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof BrowseItem)) continue;
                if (infoQuery.getErrorCode() != null) {
                    this.fireError(infoQuery, infoQuery.getIdentifier());
                    continue;
                }
                if (((BrowseItem)e).getJID() != null) {
                    if (this.debug) {
                        System.err.println("Caching JID in BrowseBean:  " + ((BrowseItem)e).getJID().toString());
                    }
                    this.cache.put(((BrowseItem)e).getJID().toString(), infoQuery);
                }
                this.fireReceived((BrowseItem)e, infoQuery.getIdentifier());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void addBrowseListener(BrowseListener browseListener) {
        if (!this.browseListeners.contains(browseListener)) {
            this.browseListeners.addElement(browseListener);
        }
    }

    public synchronized void delBrowseListener(BrowseListener browseListener) {
        if (this.browseListeners.contains(browseListener)) {
            this.browseListeners.removeElement(browseListener);
        }
    }

    private void fireReceived(BrowseItem browseItem, String string) {
        if (this.debug) {
            System.err.println("Received event fired.");
        }
        try {
            Vector vector = (Vector)this.browseListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((BrowseListener)enumeration.nextElement()).received(browseItem, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireError(InfoQuery infoQuery, String string) {
        if (this.debug) {
            System.err.println("Error event fired.");
        }
        try {
            Vector vector = (Vector)this.browseListeners.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((BrowseListener)enumeration.nextElement()).error(infoQuery, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class BrowsePacketListener
    implements PacketListener {
        public void receivedPacket(PacketEvent packetEvent) {
            if (!(packetEvent.getPacket() instanceof InfoQuery)) {
                return;
            }
            InfoQuery infoQuery = null;
            try {
                infoQuery = (InfoQuery)packetEvent.getPacket();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            BrowseBean.this.packetHandler(infoQuery);
        }

        public void sendFailed(PacketEvent packetEvent) {
            if (BrowseBean.this.debug) {
                System.err.println("Browse packet failed to send");
            }
        }

        public void sentPacket(PacketEvent packetEvent) {
            if (BrowseBean.this.debug) {
                System.err.println("Browse packet sent");
            }
        }
    }
}

