/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml;

import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXDriver
implements XmlHandler,
Locator,
AttributeList,
Parser {
    private HandlerBase base = new HandlerBase();
    private XmlParser parser;
    private boolean seenDTDEvents = false;
    private EntityResolver entityResolver = this.base;
    private DTDHandler dtdHandler = this.base;
    private DocumentHandler documentHandler = this.base;
    private ErrorHandler errorHandler = this.base;
    private String elementName = null;
    private Stack entityStack = new Stack();
    private Vector attributeNames = new Vector();
    private Vector attributeValues = new Vector();

    public void setLocale(Locale locale) throws SAXException {
        throw new SAXException("AElfred driver does not yet have locale support.");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /*
     * Loose catch block
     */
    public void parse(InputSource inputSource) throws SAXException {
        block13: {
            block12: {
                this.parser = new XmlParser();
                this.parser.setHandler(this);
                if (inputSource.getCharacterStream() != null) {
                    this.parser.parse(inputSource.getSystemId(), inputSource.getPublicId(), inputSource.getCharacterStream());
                    break block12;
                }
                if (inputSource.getByteStream() != null) {
                    this.parser.parse(inputSource.getSystemId(), inputSource.getPublicId(), inputSource.getByteStream(), inputSource.getEncoding());
                    break block12;
                }
                this.parser.parse(inputSource.getSystemId(), inputSource.getPublicId(), inputSource.getEncoding());
            }
            Object var5_2 = null;
            try {
                this.closeStreams(inputSource);
            }
            catch (Exception exception) {}
            break block13;
            {
                catch (SAXException sAXException) {
                    throw sAXException;
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var5_3 = null;
                try {
                    this.closeStreams(inputSource);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.closeStreams(inputSource);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void parse(String string) throws SAXException {
        this.parse(new InputSource(string));
    }

    private void closeStreams(InputSource inputSource) throws IOException {
        if (inputSource.getCharacterStream() != null) {
            inputSource.getCharacterStream().close();
        }
        if (inputSource.getByteStream() != null) {
            inputSource.getByteStream().close();
        }
    }

    public void startDocument() throws SAXException {
        this.documentHandler.setDocumentLocator(this);
        this.documentHandler.startDocument();
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    public void endDocument() throws SAXException {
        this.documentHandler.endDocument();
    }

    public Object resolveEntity(String string, String string2) throws SAXException, IOException {
        InputSource inputSource = this.entityResolver.resolveEntity(string, string2);
        if (inputSource == null) {
            return null;
        }
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return inputSource.getByteStream();
        }
        return inputSource.getSystemId();
    }

    public void startExternalEntity(String string) throws SAXException {
        this.entityStack.push(string);
    }

    public void endExternalEntity(String string) throws SAXException {
        this.entityStack.pop();
    }

    public void doctypeDecl(String string, String string2, String string3) throws SAXException {
    }

    public void attribute(String string, String string2, boolean bl) throws SAXException {
        if (string2 != null) {
            this.attributeNames.addElement(string);
            this.attributeValues.addElement(string2);
        }
    }

    public void startElement(String string) throws SAXException {
        if (!this.seenDTDEvents) {
            this.deliverDTDEvents();
            this.seenDTDEvents = true;
        }
        this.elementName = string;
        this.documentHandler.startElement(string, this);
        this.elementName = null;
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    public void endElement(String string) throws SAXException {
        this.documentHandler.endElement(string);
    }

    public void charData(char[] cArray, int n, int n2) throws SAXException {
        this.documentHandler.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.documentHandler.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.documentHandler.processingInstruction(string, string2);
    }

    public void error(String string, String string2, int n, int n2) throws SAXException {
        this.errorHandler.fatalError(new SAXParseException(string, null, string2, n, n2));
    }

    private void deliverDTDEvents() throws SAXException {
        String string;
        String string2;
        String string3;
        Enumeration enumeration = this.parser.declaredNotations();
        Enumeration enumeration2 = this.parser.declaredEntities();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = this.parser.getNotationPublicId(string3);
            string = this.parser.getNotationSystemId(string3);
            this.dtdHandler.notationDecl(string3, string2, string);
        }
        while (enumeration2.hasMoreElements()) {
            String string4 = (String)enumeration2.nextElement();
            if (this.parser.getEntityType(string4) != 2) continue;
            string2 = this.parser.getEntityPublicId(string4);
            string = this.parser.getEntitySystemId(string4);
            string3 = this.parser.getEntityNotationName(string4);
            this.dtdHandler.unparsedEntityDecl(string4, string2, string, string3);
        }
    }

    public int getLength() {
        return this.attributeNames.size();
    }

    public String getName(int n) {
        return (String)this.attributeNames.elementAt(n);
    }

    public String getType(int n) {
        switch (this.parser.getAttributeType(this.elementName, this.getName(n))) {
            case 0: 
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: 
            case 9: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 10: {
                return "NOTATION";
            }
        }
        return null;
    }

    public String getValue(int n) {
        return (String)this.attributeValues.elementAt(n);
    }

    public String getType(String string) {
        int n = 0;
        while (n < this.getLength()) {
            if (string.equals(this.getName(n))) {
                return this.getType(n);
            }
            ++n;
        }
        return null;
    }

    public String getValue(String string) {
        int n = 0;
        while (n < this.getLength()) {
            if (string.equals(this.getName(n))) {
                return this.getValue(n);
            }
            ++n;
        }
        return null;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return (String)this.entityStack.peek();
    }

    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }
}

