/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.graph.view.looks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import lt.monarch.graph.view.looks.RectangularNode;
import lt.monarch.graph.view.looks.SimpleRectangularPin;
import lt.monarch.graph.view.utils.BodyBlock;
import lt.monarch.graph.view.utils.TextBlock;

public class RectangularPin
extends SimpleRectangularPin {
    private static Font j = new Font(RectangularPin.b("%+V?,&"), 0, 10);
    private static Insets k = new Insets(2, 6, 0, 6);
    public static Color defaultBackground = new Color(247, 247, 157);
    public static Color defaultForeground = Color.black;
    protected Color background = defaultBackground;
    protected Color foreground = defaultForeground;
    protected BodyBlock body;

    public void setLabel(String string) {
        TextBlock textBlock = new TextBlock(string);
        textBlock.setFont(j);
        textBlock.setInsets(k);
        textBlock.setHorizontalAlignment(1);
        textBlock.setVerticalAlignment(1);
        textBlock.setMargin(10);
        this.setBody(textBlock);
    }

    public void setBody(BodyBlock bodyBlock) {
        if (this.body != null) {
            this.body.dispose();
        }
        this.body = bodyBlock;
        if (this.body != null) {
            this.body.setParent(this);
        }
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void dispose() {
        this.setBody(null);
        super.dispose();
    }

    public Dimension getMinimumSize(Graphics2D graphics2D) {
        return this.body.getPreferredSize(graphics2D);
    }

    public void setBounds(Rectangle rectangle) {
        this.body.setBounds(rectangle);
        super.setBounds(rectangle);
    }

    public boolean contains(Point point) {
        return this.getBoundsInternal().contains(point);
    }

    public void paint(Graphics2D graphics2D) {
        Rectangle rectangle = this.getBoundsInternal();
        graphics2D.setColor(this.background);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics2D.setColor(this.foreground);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        this.body.paint(graphics2D);
    }

    public int getConnectionAngle(Point point) {
        switch (((RectangularNode)this.getNode()).getOrientation()) {
            case 2: {
                return this.getConnectionPoint().y > this.getNode().getPosition().y ? -90 : 90;
            }
            case 1: {
                return this.getConnectionPoint().x > this.getNode().getPosition().x ? 0 : 180;
            }
        }
        return 0;
    }

    public RectangularPin(RectangularNode rectangularNode, Object object) {
        super(rectangularNode, object);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String b(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n > 1) continue;
            char[] cArray2 = cArray;
            int n3 = n2;
            while (true) {
                int n4;
                char c2 = cArray2[n3];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 65;
                        break;
                    }
                    case 1: {
                        n4 = 66;
                        break;
                    }
                    case 2: {
                        n4 = 55;
                        break;
                    }
                    case 3: {
                        n4 = 83;
                        break;
                    }
                    default: {
                        n4 = 67;
                    }
                }
                cArray2[n3] = (char)(c2 ^ n4);
                ++n2;
                if (n != 0) continue block6;
                cArray2 = cArray;
                n3 = n;
            }
        } while (n2 < n);
        return new String(cArray);
    }
}

