/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.graph.view.looks;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import lt.monarch.graph.view.PinView;
import lt.monarch.graph.view.looks.LinkPaintUtilities;
import lt.monarch.graph.view.looks.LinkViewBase;
import lt.monarch.graph.view.looks.SimpleRectangularPin;

public class DirectLink
extends LinkViewBase {
    Point k;
    Point l;

    protected void invalidateLinkLayout() {
        this.l = null;
        this.k = null;
        Point point = this.getOriginPin().getConnectionPoint();
        Point point2 = this.getTargetPin().getConnectionPoint();
        this.setBounds(new Rectangle(Math.min(point.x, point2.x) - 5, Math.min(point.y, point2.y) - 5, Math.abs(point.x - point2.x) + 10, Math.abs(point.y - point2.y) + 10));
    }

    public void layout(Graphics2D graphics2D) {
        Point point = this.getOriginPin().getConnectionPoint();
        Point point2 = this.getTargetPin().getConnectionPoint();
        Point point3 = new Point((point.x + point2.x) / 2, (point.y + point2.y) / 2);
        this.k = this.getOriginPin().getConnectionPoint(point3);
        this.l = this.getTargetPin().getConnectionPoint(point3);
        this.setBounds(new Rectangle(Math.min(this.k.x, this.l.x) - 5, Math.min(this.k.y, this.l.y) - 5, Math.abs(this.k.x - this.l.x) + 10, Math.abs(this.k.y - this.l.y) + 10));
    }

    public void paint(Graphics2D graphics2D) {
        block3: {
            block4: {
                boolean bl;
                block2: {
                    bl = SimpleRectangularPin.i;
                    if (this.k != null && this.l != null) break block2;
                    Point point = this.getOriginPin().getConnectionPoint();
                    Point point2 = this.getTargetPin().getConnectionPoint();
                    graphics2D.setColor(Color.gray);
                    LinkPaintUtilities.drawDraftLink(graphics2D, point, point2);
                    if (!bl) break block3;
                }
                graphics2D.setColor(this.color);
                graphics2D.setStroke(this.stroke);
                if (DirectLink.distance(this.k, this.l) >= 4) break block4;
                LinkPaintUtilities.drawCircle(graphics2D, this.k);
                if (!bl) break block3;
            }
            LinkPaintUtilities.drawLink(graphics2D, this.k, this.l, this.startConnector, this.endConnector);
        }
    }

    protected static final int distance(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        return (int)Math.sqrt(n * n + n2 * n2);
    }

    public PinView getNearestPinAt(Point point) {
        Point point2 = this.k;
        Point point3 = this.l;
        int n = (point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y);
        int n2 = (point3.x - point.x) * (point3.x - point.x) + (point3.y - point.y) * (point3.y - point.y);
        return 2 * n > n2 ? this.getTargetPin() : this.getOriginPin();
    }

    public boolean contains(Point point) {
        int n = 3;
        if (this.k == null || this.l == null) {
            return false;
        }
        if (this.k == null || this.l == null || point.x < Math.min(this.k.x, this.l.x) - 3 || point.x > Math.max(this.k.x, this.l.x) + 3 || point.y < Math.min(this.k.y, this.l.y) - 3 || point.y > Math.max(this.k.y, this.l.y) + 3) {
            return false;
        }
        double d2 = (double)((point.x - this.k.x) * (this.l.x - this.k.x) + (point.y - this.k.y) * (this.l.y - this.k.y)) / (double)((this.l.x - this.k.x) * (this.l.x - this.k.x) + (this.l.y - this.k.y) * (this.l.y - this.k.y));
        double d3 = (double)this.k.x + d2 * (double)(this.l.x - this.k.x);
        double d4 = (double)this.k.y + d2 * (double)(this.l.y - this.k.y);
        return (d3 - (double)point.x) * (d3 - (double)point.x) + (d4 - (double)point.y) * (d4 - (double)point.y) < 18.0;
    }

    public Point getOriginPoint() {
        return this.k != null ? this.k : this.getOriginPin().getConnectionPoint();
    }

    public Point getTargetPoint() {
        return this.l != null ? this.l : this.getTargetPin().getConnectionPoint();
    }

    public Point getCenterPoint() {
        if (this.k == null || this.l == null) {
            return null;
        }
        return new Point((this.k.x + this.l.x) / 2, (this.k.y + this.l.y) / 2);
    }

    public DirectLink(PinView pinView, PinView pinView2) {
        super(pinView, pinView2);
    }
}

