/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.graph.view.looks;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import lt.monarch.graph.GraphView;
import lt.monarch.graph.view.PinView;
import lt.monarch.graph.view.ViewObject;
import lt.monarch.graph.view.looks.DiamondPin;
import lt.monarch.graph.view.looks.NodeViewBase;
import lt.monarch.graph.view.looks.SimpleRectangularPin;

public class DiamondNode
extends NodeViewBase {
    protected final GraphView graphView;
    private Rectangle i = new Rectangle();
    protected DiamondPin inputPin;
    protected DiamondPin leftPin;
    protected DiamondPin rightPin;

    public PinView[] getPins() {
        return new PinView[]{this.inputPin, this.leftPin, this.rightPin};
    }

    public void setInputPin(Object object, String string) {
        this.inputPin.dispose();
        this.inputPin = new DiamondPin(this, object);
        this.inputPin.setLabel(string);
        this.addSubView(this.inputPin);
        this.graphView.pinRegistry.setViewFor(object, this.inputPin);
    }

    public void setLeftPin(Object object, String string) {
        this.leftPin.dispose();
        this.leftPin = new DiamondPin(this, object);
        this.leftPin.setLabel(string);
        this.addSubView(this.leftPin);
        this.graphView.pinRegistry.setViewFor(object, this.leftPin);
    }

    public void setRightPin(Object object, String string) {
        this.rightPin.dispose();
        this.rightPin = new DiamondPin(this, object);
        this.rightPin.setLabel(string);
        this.addSubView(this.rightPin);
        this.graphView.pinRegistry.setViewFor(object, this.rightPin);
    }

    public Point getPosition() {
        return new Point(this.i.x + this.i.width / 2, this.i.y + this.i.height / 2);
    }

    public void setPosition(Point point) {
        Point point2 = this.getPosition();
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        this.i.translate(n, n2);
        this.body.setBounds(this.i);
        Point point3 = this.inputPin.getConnectionPoint();
        point3.translate(n, n2);
        this.inputPin.a(point3);
        point3 = this.leftPin.getConnectionPoint();
        point3.translate(n, n2);
        this.leftPin.a(point3);
        point3 = this.rightPin.getConnectionPoint();
        point3.translate(n, n2);
        this.rightPin.a(point3);
        Rectangle rectangle = this.getBounds();
        rectangle.translate(n, n2);
        this.setBounds(rectangle);
        this.fireViewChanged();
    }

    public boolean contains(Point point) {
        int n;
        if (!super.contains(point)) {
            return false;
        }
        int n2 = Math.abs(point.x - this.i.x - this.i.width / 2);
        return (double)n2 / (double)(this.i.width / 2) < 1.0 - (double)(n = Math.abs(point.y - this.i.y - this.i.height / 2)) / (double)(this.i.height / 2);
    }

    public void layout(Graphics2D graphics2D) {
        boolean bl = SimpleRectangularPin.i;
        Point point = this.getPosition();
        Dimension dimension = this.body.getPreferredSize(graphics2D);
        int n = dimension.width * 8 / 5;
        int n2 = Math.max(n * 2 / 5, dimension.height * 8 / 5);
        this.i = new Rectangle(point.x - n / 2, point.y - n2 / 2, n, n2);
        Rectangle rectangle = new Rectangle(this.i);
        this.inputPin.layout(graphics2D);
        this.inputPin.a(new Point(point.x, point.y - this.i.height / 2));
        rectangle.add(this.inputPin.getBounds());
        this.leftPin.layout(graphics2D);
        this.leftPin.a(new Point(point.x - this.i.width / 2, point.y));
        rectangle.add(this.leftPin.getBounds());
        this.rightPin.layout(graphics2D);
        this.rightPin.a(new Point(point.x + this.i.width / 2, point.y));
        rectangle.add(this.rightPin.getBounds());
        this.body.setBounds(this.i);
        rectangle.grow(2, 2);
        this.setBounds(rectangle);
        this.invalidate();
        if (bl) {
            int n3 = ViewObject.d;
            ViewObject.d = ++n3;
        }
    }

    public void paint(Graphics2D graphics2D) {
        boolean bl = SimpleRectangularPin.i;
        this.paintSubViews(graphics2D);
        int[] nArray = new int[]{this.i.x, this.i.x + this.i.width / 2, this.i.x + this.i.width, this.i.x + this.i.width / 2};
        int[] nArray2 = new int[]{this.i.y + this.i.height / 2, this.i.y, this.i.y + this.i.height / 2, this.i.y + this.i.height};
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.background);
        graphics2D.fillPolygon(nArray, nArray2, 4);
        graphics2D.setColor(this.foreground);
        graphics2D.drawPolygon(nArray, nArray2, 4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.body.paint(graphics2D);
        if (ViewObject.d != 0) {
            SimpleRectangularPin.i = !bl;
        }
    }

    public DiamondNode(GraphView graphView, Object object) {
        super(object);
        this.graphView = graphView;
        this.inputPin = new DiamondPin(this, null);
        this.leftPin = new DiamondPin(this, null);
        this.rightPin = new DiamondPin(this, null);
        this.addSubView(this.inputPin);
        this.addSubView(this.leftPin);
        this.addSubView(this.rightPin);
    }
}

