/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.graph.plugins;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import lt.monarch.graph.AbstractGraphViewPlugin;
import lt.monarch.graph.GraphView;
import lt.monarch.graph.plugins.NodeSelectionManager;
import lt.monarch.graph.view.NodeView;
import lt.monarch.graph.view.ViewObject;

public class NodeBoxSelector
extends AbstractGraphViewPlugin
implements MouseMotionListener,
MouseListener {
    private NodeSelectionManager b;
    private Point c;
    private Point d;

    public void install(GraphView graphView) {
        super.install(graphView);
        graphView.addMouseListener(5, this);
        graphView.addMouseMotionListener(5, this);
    }

    public void uninstall(GraphView graphView) {
        graphView.removeMouseListener(5, this);
        graphView.removeMouseMotionListener(5, this);
        super.uninstall(graphView);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.c = mouseEvent.getPoint();
        this.d = null;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!mouseEvent.isControlDown() && this.getGraphView().nodeLayer.getViewAt(this.c) == null && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.d = this.c;
            mouseEvent.consume();
            return;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = NodeSelectionManager.d;
        if (this.d != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object = this.getGraphView().getContainer().getUpdateGraphics();
            this.paintDragRect((Graphics2D)object);
            ((Graphics)object).dispose();
            object = new Rectangle(Math.min(this.c.x, this.d.x), Math.min(this.c.y, this.d.y), Math.abs(this.c.x - this.d.x) + 1, Math.abs(this.c.y - this.d.y) + 1);
            this.d = null;
            this.c = null;
            if (((Rectangle)object).width > 3 && ((Rectangle)object).height > 3) {
                Iterator iterator = this.getGraphView().nodeLayer.getViews();
                boolean bl = true;
                block0: do {
                    if (bl && !(bl = false) && n == 0) continue;
                    ViewObject viewObject = (ViewObject)iterator.next();
                    boolean bl2 = viewObject instanceof NodeView;
                    while (bl2) {
                        bl2 = ((Rectangle)object).contains(viewObject.getBounds());
                        if (n != 0) continue;
                        if (!bl2) continue block0;
                        bl2 = arrayList.add(((NodeView)viewObject).getModelNode());
                        if (n != 0) continue;
                    }
                } while (iterator.hasNext());
            }
            this.b.selectNodes(((AbstractList)arrayList).iterator());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.d != null) {
            mouseEvent.consume();
            Graphics2D graphics2D = this.getGraphView().getContainer().getUpdateGraphics();
            this.paintDragRect(graphics2D);
            this.d = mouseEvent.getPoint();
            this.paintDragRect(graphics2D);
            graphics2D.dispose();
        }
    }

    public void paintDragRect(Graphics2D graphics2D) {
        int n = NodeSelectionManager.d;
        graphics2D.setXORMode(Color.white);
        graphics2D.setColor(Color.lightGray);
        Point point = new Point(this.c);
        Point point2 = new Point(this.d);
        graphics2D.drawRect(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point.x - point2.x), Math.abs(point.y - point2.y));
        graphics2D.setPaintMode();
        if (n != 0) {
            int n2 = ViewObject.d;
            ViewObject.d = ++n2;
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.c != null && this.d != null) {
            this.paintDragRect(graphics2D);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public NodeBoxSelector(NodeSelectionManager nodeSelectionManager) {
        this.b = nodeSelectionManager;
    }
}

