;;; The domain for the power plant (pp):

types
  Place = (MyIsland CityA CityB CityC CityD CityE EC PP H1 H2),
  Road = (RoadED RoadDA RoadAB RoadBC),
  PowerPlant = (PP);
  Person = (Employee1 Employee2 Employee3 Employee4),
  Machine = (Generator1, Generator2),
  Generator = (Generator1, Generator2),
  EngineeringCompany = (EC),
  Hospital = (H1 H2),

always
  {Has Location CityA MyIsland} = true,
  {Has Location CityB MyIsland} = true,
  {Has Location CityC MyIsland} = true,
  {Has Location CityD MyIsland} = true,
  {Has Location CityE MyIsland} = true,
  {Has Location Generator1 PP},
  {Has Location Generator2 PP},
  {Has Location EC CityA} = true,
  {Has Location H1 CityB} = true,
  {Has Location H2 CityD} = true,
  {Has Location PP CityE} = true,
  {Connects RoadED CityE CityD} = true,
  {Connects RoadDA CityD CityA} = true,
  {Connects RoadAB CityA CityB} = true,
  {Connects RoadBC CityB CityC} = true;

task Scenario1;
  nodes 
    1 start, 2 finish;
  orderings
    1 ---> 2;
  effects
    {Is Employee2 Injured} = true at 1,
    {Is Generator1 Broken} = true at 1;
  conditions
    achieve {Is Employee2 Injured} = false at 2,
    achieve {Is Generator1 Broken} = false at 2;
end_task;
  