;;; The domain for the first hospital (h1):

types
  Place = (MyIsland CityA CityB CityC CityD CityE PP H1 H2),
  Person = (Doctor1 Doctor2 Driver1),
  Road = (RoadED RoadDA RoadAB RoadBC),
  Hospital = (H1 H2),
  PowerPlant = (PP);

always
  {Has Location CityA MyIsland} = true,
  {Has Location CityB MyIsland} = true,
  {Has Location CityC MyIsland} = true,
  {Has Location CityD MyIsland} = true,
  {Has Location CityE MyIsland} = true,
  {Has Location H1 CityB} = true,
  {Has Location H2 CityD} = true,
  {Has Location PP CityE} = true,
  {Connects RoadED CityE CityD} = true,
  {Connects RoadDA CityD CityA} = true,
  {Connects RoadAB CityA CityB} = true,
  {Connects RoadBC CityB CityC} = true;

schema treat_patient;
;;; treat a patient that is at the hospital:
  vars ?patient = ?{type Person};
  expands {treat ?patient};
  conditions
    achieve {Has Location ?patient H1} = true;
  effects
    {Is ?patient Injured} = false;
end_schema;