;;; The domain for the ambulance service (as):

types
  Place = (MyIsland CityA CityB CityC CityD CityE PP H1 H2),
  Person = (Driver1 Driver2),
  Road = (RoadED RoadDA RoadAB RoadBC),
  Hospital = (H1 H2),
  PowerPlant = (PP);

always
  {Has Location CityA MyIsland} = true,
  {Has Location CityB MyIsland} = true,
  {Has Location CityC MyIsland} = true,
  {Has Location CityD MyIsland} = true,
  {Has Location CityE MyIsland} = true,
  {Has Location H1 CityB} = true,
  {Has Location H2 CityD} = true,
  {Has Location PP CityE} = true,
  {Connects RoadED CityE CityD} = true,
  {Connects RoadDA CityD CityA} = true,
  {Connects RoadAB CityA CityB} = true,
  {Connects RoadBC CityB CityC} = true;

schema trans_patient;
;;; drive an ambulance to wherever the patient is, load the patient,
;;; and transport him presumably to a hospital:
  vars ?patient = ?{type Person}, ?from = ?{type Place}, ?to = ?{type Place};
  expands {tranport ?patient};
  conditions
    only_use_for_query {Has Location ?patient ?from} = true;
    ;;; add reachability condition here
  effects
    {Has Location ?patient ?from} = false,
    {Has Location ?patient ?to} = true;
end_schema;
