;;; The domain for the first hospital (h1):

types
  Place = (MyIsland CityA CityB CityC CityD CityE PP H1 H2),
  Person = (Doctor1 Doctor2 Driver1),
  Road = (RoadED RoadDA RoadAB RoadBC),
  Hospital = (H1 H2),
  PowerPlant = (PP);

always
  {Has Location CityA MyIsland} = true,
  {Has Location CityB MyIsland} = true,
  {Has Location CityC MyIsland} = true,
  {Has Location CityD MyIsland} = true,
  {Has Location CityE MyIsland} = true,
  {Has Location H1 CityB} = true,
  {Has Location H2 CityD} = true,
  {Has Location PP CityE} = true,
  {Connects RoadED CityE CityD} = true,
  {Connects RoadDA CityD CityA} = true,
  {Connects RoadAB CityA CityB} = true,
  {Connects RoadBC CityB CityC} = true;

schema fetch_patient;
;;; drive an ambulance to wherever the patient is, load the patient,
;;; and return to h1:
  vars ?patient = ?{type Person}, ?place = ?{type Place};
  expands {fetch ?patient};
  conditions
    only_use_for_query {Has Location ?patient ?place} = true;
    ;;; add reachability condition here
  effects
    {Has Location ?patient ?place} = false,
    {Has Location ?patient H1} = true;
end_schema;

schema treat_patient;
;;; treat a patient that is at the hospital:
  vars ?patient = ?{type Person};
  expands {treat ?patient};
  conditions
    achieve {Has Location ?patient H1} = true;
  effects
    {Is ?patient Injured} = false;
end_schema;