;;; The domain for the engineering company (ec):

types
  Place = (MyIsland CityA CityB CityC CityD CityE EC PP H1 H2),
  Road = (RoadED RoadDA RoadAB RoadBC),
  EngineeringCompany = (EC),
  Person = (Engineer1 Engineer2),
  Truck = (ECTruck),
  Machine = (),
  Hospital = (H1 H2),
  PowerPlant = (PP);

always
  {Has Location CityA MyIsland} = true,
  {Has Location CityB MyIsland} = true,
  {Has Location CityC MyIsland} = true,
  {Has Location CityD MyIsland} = true,
  {Has Location CityE MyIsland} = true,
  {Has Location EC CityA} = true,
  {Has Location H1 CityB} = true,
  {Has Location H2 CityD} = true,
  {Has Location PP CityE} = true,
  {Connects RoadED CityE CityD} = true,
  {Connects RoadDA CityD CityA} = true,
  {Connects RoadAB CityA CityB} = true,
  {Connects RoadBC CityB CityC} = true;

schema drive_to;
;;; go to the place where something is to be repaired:
  vars ?place = ?{type Place}, ?place2 = ?{type Place};
  expands {drive_to ?place};
  conditions
    only_use_for_query {Has Location ECTruck ?place2} = true;
    ;;; add reachability condition here
  effects
    {Has Location ECTruck ?place2} = false,
    {Has Location ECTruck ?place} = true;
end_schema;

schema repair;
;;; repair a machine:
  vars ?machine = ?{type Machine}, ?place = ?{type Place};
  expands {repair ?machine};
  conditions
    only_use_for_query {Has Location ?machine ?place} = true,
    achieve {Has Location ECTruck ?place} = true;
  effects
    {Is ?machine Broken} = false;
end_schema;