package test;

import JavaAgent.resource.*;
import JavaAgent.agent.Agent;
import java.awt.*;

/**
 * Subclass of Interpreter used to test the NetworkClassLoader mechanism.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class TestInterpreter extends Interpreter {
  
  /**
   * Interpret the Language instance, from the message, for the reciever
   * according to the present Interpreter.
   *
   * @param message Message which needs to be interpreted.
   * @param receiver Agent who received the message.
   * @param language Instance of Language which represents the message
   * contents.
   */
  
  protected void interpretLanguage(KQMLmessage message, Agent receiver, 
				   Language language)
    throws InterpretationException {
			   
      if(message.getValue("language").equals("KQML")){
	KQMLmessage content = (KQMLmessage)language;
	String performative = content.getValue("performative");
		
	if(performative.equals("test1")){
	  test1Action(content,receiver);
	} else if(performative.equals("test2")){
	  test2Action(content, receiver);
	}
      } else {
	throw new InterpretationException("Interpreter " + 
					  message.getValue("ontology") +
					  " does not support language " +
					  message.getValue("langauge"));
      } 
    }
  
  /**
   * Handles test1 messages.
   */

  private void test1Action(KQMLmessage message, Agent parent){
    String test_content = message.getValue("content");
    parent.addSystemMessage(test_content);
  }
  
  /**
   * Handles test2 messages.
   */

  private void test2Action(KQMLmessage message, Agent parent){
    
    if(parent.hasGUI()){
      parent.addPanel(new PanelTest());
    }
    
  }
   
}

class PanelTest extends Panel{
  
  
  public PanelTest(){
   
    setLayout(new BorderLayout());

    add("Center", new Label("Test 2"));
    add("South", new Button("Quit"));

    resize(new Dimension(200,200));
    
  }
  
  public boolean action(Event evt, Object arg) {
    if("Quit".equals(arg)) {
      Frame f = (Frame)getParent();
      f.dispose();
    }
    return true;
  }
  
}
