

/*  Set tabstop = 4 to read this file.
*
*   Maintanence History:
*/


//  File: KifTerm.java

package jkp;

import jbf.*;
import java.lang.*;


/**
 * The abstract base class for KIF terms
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public abstract class KifTerm extends KifObj {

	/**
	 * For indvar, string and objconst, it is the corresponding string.
	 * for functerm, it is the funconst.
	 */
	protected String _termString;

	public KifTerm(String termString)
	{
		_termString = termString;
	}


	public KifTerm()
	{
		_termString = null;
	}


	/**
	 * @return
	 * For indvar, string and objconst, it is the corresponding string.
	 * for functerm, it is the funconst.
	 */
	public String
	termString()
	{
		return _termString;
	}


	/**
	 * @return the integer value of term KifInt/ KifReal
	 */
	public int
	intValue()
	{
		return Integer.parseInt(_termString);
	}


	/**
	 * @return the real value of term KifInt/ KifReal
	 */
	public float
	floatValue()
	{
		return Float.valueOf(_termString).floatValue();
	}


	public String
	toString()
	{
		return _termString;
	}
}



