// File: KifSeq.java

/*  Set tabstop = 4 to read this file.
*
*   Maintanence History:
*/


package jkp;

import jbf.*;
import java.lang.*;
import java.util.*;



/**
 * The class for KIF object sequence, such as term sequence,
 * sentence sequence, etc. A very important class in this parser.
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifSeq extends KifObj {

	private Vector	_content;

	public KifSeq()
	{
		setType(KifObj.KIF_SEQ);
		_content = new Vector();
	}

	
	/**
	 * Create an instance of KifSeq with only one object in the sequence.
	 * @param obj The only one object in the sequence.
	 */
	public KifSeq(KifObj obj)
	{
		setType(KifObj.KIF_SEQ);
		_content = new Vector();
		_content.addElement(obj);
	}
	

	/**
	 * Create an instance of KifSeq with the given object as the first
	 * object in the sequence, and objects in the given sequence as the 
	 * subsequent object in the sequence.
	 * @param obj the first object in the created sequence.
	 * @param seq the objects of which will be the second part of the new
	 *            sequence.
	 */
	public KifSeq(KifObj obj, KifSeq seq)
	{
		/*
		setType(KifObj.KIF_SEQ);
		_content = new Vector();

		_content.addElement(obj);

		for(int i=0; i<seq.size(); i++)
			_content.addElement(seq.ithObj(i));
		*/
		this(obj);
		append(seq);
	}


	/**
	 * Append the given object to the given sequence to get a new sequence.
	 */
	public KifSeq(KifSeq seq, KifObj obj)
	{
		/*
		setType(KifObj.KIF_SEQ);
		_content = new Vector();

		for(int i=0; i<seq.size(); i++)
			_content.addElement(seq.ithObj(i));

		_content.addElement(obj);
		*/
		this(seq);
		append(obj);
	}

	
	/**
	 * Create a new copy of the given sequence.
	 */
	public KifSeq(KifSeq seq)
	{
		setType(KifObj.KIF_SEQ);
		_content = new Vector();
		for(int i = 0; i< seq.size(); i++)
			_content.addElement(seq.ithObj(i));
	}


	/**
	 * @return return the ith Kif object in the sequence.
	 */
	public KifObj
	ithObj(int i) throws KifRTException
	{
		if( i>= size()) {
			throw (new KifRTException("ithObj: bad index"));
		}

		return (KifObj)_content.elementAt(i);
	}


	public void
	append(KifObj obj)
	{
		_content.addElement(obj);
	}


	public void
	append(KifSeq seq)
	{
		for(int i=0; i<seq.size(); i++)
			_content.addElement(seq.ithObj(i));
	}


	public boolean 
	isEmpty()
	{
		return _content.isEmpty();
	}


	/**
	 * @return Return the first element of the sequence.
	 */
	public KifObj
	car()
	{
		if(size() <= 0)
			return null;
		
		return (KifObj)_content.elementAt(0);
	}


	/**
	 * @return Return the subsquence(from 2nd element to end) of the sequence.
	 */
	public KifSeq 
	cdr()
	{
		if(size()<2)
			return null;

		KifSeq seq = new KifSeq();

		for(int i=1; i<size(); i++)
			seq.append(ithObj(i));
		
		return seq;
	}


	public int 
	size()
	{
		return _content.size();

	}


	public String
	toString()
	{
		StringBuffer buf = new StringBuffer();
		
		if(size() > 0)
			buf.append(ithObj(0).toString());
		for(int i=1; i<size(); i++) 
			buf.append(" " + ithObj(i).toString());

		return buf.toString();
	}
}

