//  File: KifRelSent.java

package jkp;

import jbf.*;
import java.lang.*;


/**
 * The class for  KIF relational sentence, something like 'predicate'
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifRelSent extends KifSent {
	private String	_relConst;
	private KifSeq	_termSeq;


	public KifRelSent(String relConst, KifSeq termSeq)
	{
		setType(KifObj.KIF_RELSENT);

		_relConst = relConst;
		_termSeq = termSeq;
	}


	public KifRelSent(String relConst)
	{
		setType(KifObj.KIF_RELSENT);

		_relConst = relConst;
		_termSeq = null;
	}


	/**
	 * @return Return the relational constant (predicate name).
	 */
	public String 
	relConst()
	{
		return _relConst;
	}


	public KifSeq 
	termSeq()
	{
		return _termSeq;
	}


	public String
	toString()
	{
		if(_termSeq == null)
			return "(" + _relConst + ")";

		return "(" + _relConst + " " + _termSeq.toString() + ")";
	}
}

